/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessage;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamRecords;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.util.SafeEncoder;

class StreamConverters {
    StreamConverters() {
    }

    static byte[][] entryIdsToBytes(List<RecordId> recordIds) {
        byte[][] target = new byte[recordIds.size()][];
        for (int i = 0; i < recordIds.size(); ++i) {
            RecordId id = recordIds.get(i);
            target[i] = JedisConverters.toBytes(id.getValue());
        }
        return target;
    }

    static String getLowerValue(Range<String> range) {
        return StreamConverters.getValue((Range.Bound<String>)range.getLowerBound(), "-");
    }

    static String getUpperValue(Range<String> range) {
        return StreamConverters.getValue((Range.Bound<String>)range.getUpperBound(), "+");
    }

    private static String getValue(Range.Bound<String> bound, String fallbackValue) {
        if (bound.equals((Object)Range.Bound.unbounded())) {
            return fallbackValue;
        }
        return bound.getValue().map(it -> bound.isInclusive() ? it : "(" + it).orElse(fallbackValue);
    }

    static List<Object> mapToList(Map<String, Object> map) {
        ArrayList<Object> sources = new ArrayList<Object>(map.size() * 2);
        map.forEach((k, v) -> {
            sources.add(k);
            if (v instanceof StreamEntryID) {
                sources.add(v.toString());
            } else if (v instanceof StreamEntry) {
                ArrayList<Object> entries = new ArrayList<Object>(2);
                StreamEntry streamEntry = (StreamEntry)v;
                entries.add(streamEntry.getID().toString());
                entries.add(streamEntry.getFields());
                sources.add(entries);
            } else {
                sources.add(v);
            }
        });
        return sources;
    }

    static Map<byte[], byte[]> toStreamOffsets(StreamOffset<byte[]>[] streams) {
        return Arrays.stream(streams).collect(Collectors.toMap(StreamOffset::getKey, v -> JedisConverters.toBytes(v.getOffset().getOffset())));
    }

    static List<ByteRecord> convertToByteRecord(byte[] key, Object source) {
        List objectList = (List)source;
        ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(objectList.size() / 2);
        if (objectList.isEmpty()) {
            return result;
        }
        for (List res : objectList) {
            if (res == null) {
                result.add(null);
                continue;
            }
            String entryIdString = SafeEncoder.encode((byte[])((byte[])res.get(0)));
            List hash = (List)res.get(1);
            Iterator hashIterator = hash.iterator();
            HashMap<byte[], byte[]> fields = new HashMap<byte[], byte[]>(hash.size() / 2);
            while (hashIterator.hasNext()) {
                fields.put((byte[])hashIterator.next(), (byte[])hashIterator.next());
            }
            result.add(StreamRecords.newRecord().in(key).withId(entryIdString).ofBytes(fields));
        }
        return result;
    }

    static List<ByteRecord> convertToByteRecords(List<?> sources) {
        ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(sources.size() / 2);
        for (Object source : sources) {
            List stream = (List)source;
            result.addAll(StreamConverters.convertToByteRecord((byte[])stream.get(0), stream.get(1)));
        }
        return result;
    }

    static PendingMessages toPendingMessages(String groupName, Range<?> range, List<StreamPendingEntry> response) {
        List<PendingMessage> messages = response.stream().map(streamPendingEntry -> new PendingMessage(RecordId.of(streamPendingEntry.getID().toString()), Consumer.from(groupName, streamPendingEntry.getConsumerName()), Duration.ofMillis(streamPendingEntry.getIdleTime()), streamPendingEntry.getDeliveredTimes())).collect(Collectors.toList());
        return new PendingMessages(groupName, messages).withinRange(range);
    }

    static XAddParams toXAddParams(MapRecord<byte[], byte[], byte[]> record, RedisStreamCommands.XAddOptions options) {
        XAddParams params = XAddParams.xAddParams();
        params.id(record.getId().getValue());
        if (options.hasMaxlen()) {
            params.maxLen(options.getMaxlen().longValue());
        }
        if (options.hasMinId()) {
            params.minId(options.getMinId().getValue());
        }
        if (options.isNoMkStream()) {
            params.noMkStream();
        }
        if (options.isApproximateTrimming()) {
            params.approximateTrimming();
        }
        return params;
    }
}

