/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.file;

import java.io.File;
import java.util.function.Consumer;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.ozhera.log.agent.common.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileListener
implements FileAlterationListener {
    private static final Logger log = LoggerFactory.getLogger(FileListener.class);
    private Consumer<String> consumer;

    public void onStart(FileAlterationObserver fileAlterationObserver) {
        log.debug("FileListener onStart ,filepath:{}", (Object)fileAlterationObserver.getDirectory());
    }

    public void onDirectoryCreate(File file) {
    }

    public void onDirectoryChange(File file) {
    }

    public void onDirectoryDelete(File file) {
    }

    public void onFileCreate(File file) {
        log.info("onFileCreate:" + file.getAbsolutePath());
        ExecutorUtil.submit(() -> this.consumer.accept(file.getAbsolutePath()));
    }

    public void onFileChange(File file) {
    }

    public void onFileDelete(File file) {
    }

    public void onStop(FileAlterationObserver fileAlterationObserver) {
        log.debug("FileListener onStop ,filepath:{}", (Object)fileAlterationObserver.getDirectory());
    }

    public FileListener() {
    }

    public FileListener(Consumer<String> consumer) {
        this.consumer = consumer;
    }
}

