/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.impl;

import com.xiaomi.data.push.nacos.NacosNaming;
import javax.annotation.PostConstruct;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.ozhera.prometheus.agent.service.InitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InitServiceImpl
implements InitService {
    private static final Logger log = LoggerFactory.getLogger(InitServiceImpl.class);
    @Autowired
    private NacosNaming nacosNaming;
    @Value(value="${server.port}")
    private String httpPort;
    @Value(value="${dubbo.group}")
    private String group;
    @Value(value="${app.name}")
    private String appName;

    @Override
    @PostConstruct
    public void init() {
        String host = System.getenv("host.ip") == null ? NetUtils.getLocalHost() : System.getenv("host.ip");
        String port = this.httpPort;
        try {
            this.nacosNaming.registerInstance(this.appName, host, Integer.valueOf(port).intValue(), this.group);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    this.nacosNaming.deregisterInstance(this.appName, host, Integer.valueOf(port).intValue(), this.group);
                }
                catch (Exception e) {
                    log.error("nacos init service : ", (Throwable)e);
                }
            }));
        }
        catch (Exception e) {
            log.error("nacos init service : ", (Throwable)e);
        }
    }
}

