/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.TypeMeta;
import io.fabric8.kubernetes.api.model.TypeMetaFluent;
import io.fabric8.kubernetes.api.model.TypeMetaFluentImpl;
import java.util.Objects;

public class TypeMetaBuilder
extends TypeMetaFluentImpl<TypeMetaBuilder>
implements VisitableBuilder<TypeMeta, TypeMetaBuilder> {
    TypeMetaFluent<?> fluent;
    Boolean validationEnabled;

    public TypeMetaBuilder() {
        this(false);
    }

    public TypeMetaBuilder(Boolean validationEnabled) {
        this(new TypeMeta(), validationEnabled);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TypeMeta(), validationEnabled);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent, TypeMeta instance) {
        this(fluent, instance, false);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent, TypeMeta instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public TypeMetaBuilder(TypeMeta instance) {
        this(instance, (Boolean)false);
    }

    public TypeMetaBuilder(TypeMeta instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public TypeMeta build() {
        TypeMeta buildable = new TypeMeta(this.fluent.getApiVersion(), this.fluent.getKind());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeMetaBuilder that = (TypeMetaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

