/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.demo;

import com.google.common.collect.Lists;
import com.xiaomi.data.push.bo.ClientInfo;
import com.xiaomi.data.push.rpc.RpcClient;
import com.xiaomi.data.push.rpc.common.NetUtils;
import com.xiaomi.data.push.rpc.common.Pair;
import com.xiaomi.data.push.rpc.processor.GetInfoProcessor;
import com.xiaomi.data.push.rpc.processor.SFile2Processor;
import com.xiaomi.data.push.rpc.processor.SFileProcessor;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.data.push.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoClient {
    private static final Logger log = LoggerFactory.getLogger(DemoClient.class);

    public static void main(String ... args) throws InterruptedException {
        RpcClient client = new RpcClient("127.0.0.1:80", "demo_server1");
        client.setReconnection(false);
        ClientInfo clientInfo = new ClientInfo("demo_client", NetUtils.getLocalAddress().getHostAddress(), 0, "0.0.1");
        client.setClientInfo(clientInfo);
        client.setProcessorList(Lists.newArrayList((Object[])new Pair[]{new Pair<Integer, GetInfoProcessor>(2000, new GetInfoProcessor()), new Pair<Integer, SFileProcessor>(0, new SFileProcessor()), new Pair<Integer, SFile2Processor>(10, new SFile2Processor())}));
        client.setTasks(Lists.newArrayList((Object[])new Task[]{new Task(() -> {
            try {
                log.info("send ping");
                RemotingCommand req = RemotingCommand.createRequestCommand(1001);
                req.setBody("ping".getBytes());
                client.sendMessage(client.getServerAddrs(), req, f -> log.info(new String(f.getResponseCommand().getBody())));
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }, 5L)}));
        client.init();
        client.start();
        client.getClient().createChannel();
    }
}

