/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.aop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.ozhera.app.api.model.HeraAppMqInfo;
import org.apache.ozhera.app.common.Constant;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.enums.OperateEnum;
import org.apache.ozhera.app.model.HeraAppBaseInfo;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OperateAppBaseInfoAspect {
    private static final Logger log = LoggerFactory.getLogger(OperateAppBaseInfoAspect.class);
    private final String appGetResultDataPoint = "execution(* org.apache.ozhera.app.service.impl.HeraAppBaseInfoServiceImpl.appBaseInfoOperate(..))";
    @Value(value="${rocket.mq.hera.app.topic}")
    private String topic;
    @Value(value="${rocket.mq.hera.app.tag}")
    private String tag;
    @Autowired
    private DefaultMQProducer defaultMQProducer;

    @AfterReturning(value="execution(* org.apache.ozhera.app.service.impl.HeraAppBaseInfoServiceImpl.appBaseInfoOperate(..))", returning="result")
    public void afterOperateAppBaseInfo(JoinPoint joinPoint, Object result) throws IOException {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        try {
            Object[] joinPointArgs = joinPoint.getArgs();
            HeraAppBaseInfo parameterAppBaseInfo = (HeraAppBaseInfo)joinPointArgs[0];
            HeraAppBaseInfo resultAppBaseInfo = (HeraAppBaseInfo)result;
            OperateEnum operateEnum = (OperateEnum)joinPointArgs[1];
            String mqMessage = Constant.GSON.toJson((Object)Result.success((Object)this.assemblyAppMqInfo(parameterAppBaseInfo, resultAppBaseInfo, operateEnum)));
            log.info("mq data:{}", (Object)mqMessage);
            Message message = new Message();
            message.setTopic(this.topic);
            message.setTags(this.tag);
            message.setBody(mqMessage.getBytes(StandardCharsets.UTF_8));
            this.defaultMQProducer.send(message);
            log.info("\u53d1\u9001mq\u6d88\u606f\u6210\u529f");
        }
        catch (Throwable e) {
            log.error("hear app operate send mq error", e);
        }
    }

    private HeraAppMqInfo assemblyAppMqInfo(HeraAppBaseInfo parameterAppBaseInfo, HeraAppBaseInfo resultAppBaseInfo, OperateEnum operateEnum) {
        HeraAppMqInfo heraAppMqInfo = new HeraAppMqInfo();
        heraAppMqInfo.setOperateEnum(operateEnum);
        if (OperateEnum.ADD_OPERATE == operateEnum) {
            parameterAppBaseInfo.setId(null);
            heraAppMqInfo.setBeforeAppBaseInfo(this.appBaseInfoTransferMqBaseInfo(parameterAppBaseInfo));
            heraAppMqInfo.setAfterAppBaseInfo(this.appBaseInfoTransferMqBaseInfo(resultAppBaseInfo));
        }
        if (OperateEnum.UPDATE_OPERATE == operateEnum) {
            heraAppMqInfo.setBeforeAppBaseInfo(this.appBaseInfoTransferMqBaseInfo(resultAppBaseInfo));
            heraAppMqInfo.setAfterAppBaseInfo(this.appBaseInfoTransferMqBaseInfo(parameterAppBaseInfo));
        }
        if (OperateEnum.DELETE_OPERATE == operateEnum) {
            heraAppMqInfo.setBeforeAppBaseInfo(this.appBaseInfoTransferMqBaseInfo(parameterAppBaseInfo));
        }
        return heraAppMqInfo;
    }

    private HeraAppMqInfo.HeraAppBaseInfo appBaseInfoTransferMqBaseInfo(HeraAppBaseInfo heraAppBaseInfo) {
        HeraAppMqInfo.HeraAppBaseInfo mqAppBaseInfo = new HeraAppMqInfo.HeraAppBaseInfo();
        BeanUtils.copyProperties((Object)heraAppBaseInfo, (Object)mqAppBaseInfo);
        return mqAppBaseInfo;
    }
}

