/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.controller;

import java.util.List;
import org.apache.ozhera.prometheus.agent.domain.Ips;
import org.apache.ozhera.prometheus.agent.service.PrometheusVmService;
import org.apache.ozhera.prometheus.agent.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/vm"})
public class PrometheusVMController {
    private static final Logger log = LoggerFactory.getLogger(PrometheusVMController.class);
    @Autowired
    PrometheusVmService vmService;
    @Value(value="${vm.scrape.job.path}")
    private String scrapeJobFilePath;
    @Value(value="${vm.alert.rule.path}")
    private String alertRuleFilePath;

    @RequestMapping(value={"/reloadScrapeJob"}, method={RequestMethod.GET}, produces={"application/yaml"})
    public String reloadScrapeJob() {
        log.info("PrometheusVMController.reloadScrapeJob begin");
        try {
            return FileUtil.LoadFile((String)this.scrapeJobFilePath);
        }
        catch (Exception ex) {
            log.error("PrometheusVMController.reloadScrapeJob error", (Throwable)ex);
            return ex.getMessage();
        }
    }

    @RequestMapping(value={"/reloadAlertRule"}, method={RequestMethod.GET}, produces={"application/yaml"})
    public String reloadAlertRule() {
        log.info("PrometheusVMController.reloadAlertRule begin");
        try {
            return FileUtil.LoadFile((String)this.alertRuleFilePath);
        }
        catch (Exception ex) {
            log.error("PrometheusVMController.reloadAlertRule error", (Throwable)ex);
            return ex.getMessage();
        }
    }

    @RequestMapping(value={"/getClusterIp"}, method={RequestMethod.GET})
    public List<Ips> getClusterIp(String name) {
        log.info("getClusterIp begin,name:{}", (Object)name);
        return this.vmService.getVMClusterIp(name);
    }
}

