/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xiaomi.youpin.infra.rpc.Result;
import com.xiaomi.youpin.infra.rpc.errors.ErrorCode;
import com.xiaomi.youpin.infra.rpc.errors.GeneralCodes;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.api.service.TraceEtlService;
import org.apache.ozhera.trace.etl.domain.HeraTraceConfigVo;
import org.apache.ozhera.trace.etl.domain.HeraTraceEtlConfig;
import org.apache.ozhera.trace.etl.domain.PageData;
import org.apache.ozhera.trace.etl.mapper.HeraTraceEtlConfigMapper;
import org.apache.ozhera.trace.etl.service.ManagerService;
import org.apache.ozhera.trace.etl.util.pool.AsyncNotify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagerServiceImpl
implements ManagerService {
    private static final Logger log = LoggerFactory.getLogger(ManagerServiceImpl.class);
    @Autowired
    private AsyncNotify asyncNotify;
    private TraceEtlService traceEtlService;
    private HeraTraceEtlConfigMapper heraTraceEtlConfigMapper;

    public ManagerServiceImpl(HeraTraceEtlConfigMapper heraTraceEtlConfigMapper) {
        this.heraTraceEtlConfigMapper = heraTraceEtlConfigMapper;
    }

    public ManagerServiceImpl(HeraTraceEtlConfigMapper heraTraceEtlConfigMapper, TraceEtlService traceEtlService) {
        this.heraTraceEtlConfigMapper = heraTraceEtlConfigMapper;
        this.traceEtlService = traceEtlService;
    }

    @Override
    public List<HeraTraceEtlConfig> getAll(HeraTraceConfigVo vo) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"status", (Object)"1");
        if (vo.getBindId() != null) {
            qw.eq((Object)"bind_id", (Object)vo.getBindId());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getAppName())) {
            qw.eq((Object)"app_name", (Object)vo.getAppName());
        }
        return this.heraTraceEtlConfigMapper.selectList((Wrapper)qw);
    }

    @Override
    public PageData<List<HeraTraceEtlConfig>> getAllPage(HeraTraceConfigVo vo) {
        PageData pageData = new PageData();
        pageData.setPage(Integer.valueOf(vo.getPage()));
        pageData.setPageSize(vo.getPageSize());
        PageHelper.startPage((int)vo.getPage(), (int)vo.getPageSize());
        Page all = this.heraTraceEtlConfigMapper.getAllPage(vo.getUser());
        PageInfo heraTraceEtlConfigPageInfo = new PageInfo((List)all);
        pageData.setTotal(Long.valueOf(heraTraceEtlConfigPageInfo.getTotal()));
        pageData.setPages(Integer.valueOf(heraTraceEtlConfigPageInfo.getPages()));
        pageData.setList((Object)heraTraceEtlConfigPageInfo.getList());
        return pageData;
    }

    @Override
    public HeraTraceEtlConfig getByBaseInfoId(Integer baseInfoId) {
        return this.heraTraceEtlConfigMapper.getByBaseInfoId(baseInfoId);
    }

    @Override
    public HeraTraceEtlConfig getById(Integer id) {
        return (HeraTraceEtlConfig)this.heraTraceEtlConfigMapper.selectById((Serializable)id);
    }

    @Override
    public Result insertOrUpdate(HeraTraceEtlConfig config, String user) {
        Date now = new Date();
        int i = 0;
        if (config.getId() == null) {
            HeraTraceEtlConfig byBaseInfoId = this.heraTraceEtlConfigMapper.getByBaseInfoId(config.getBaseInfoId());
            if (byBaseInfoId != null) {
                return Result.fail((ErrorCode)GeneralCodes.InternalError, (String)"The item configuration already exists. Do not add it again");
            }
            config.setCreateTime(now);
            config.setUpdateTime(now);
            config.setCreateUser(user);
            i = this.heraTraceEtlConfigMapper.insert((Object)config);
            if (i > 0) {
                this.asyncNotify.submit(() -> {
                    try {
                        this.traceEtlService.insertConfig(config);
                    }
                    catch (Exception e) {
                        log.error("insert sync etl error : ", (Throwable)e);
                    }
                });
            }
        } else {
            config.setUpdateTime(now);
            config.setUpdateUser(user);
            i = this.heraTraceEtlConfigMapper.updateById((Object)config);
            if (i > 0) {
                this.asyncNotify.submit(() -> {
                    try {
                        this.traceEtlService.updateConfig(config);
                    }
                    catch (Exception e) {
                        log.error("update sync etl error : ", (Throwable)e);
                    }
                });
            }
        }
        return i > 0 ? Result.success(null) : Result.fail((ErrorCode)GeneralCodes.InternalError, (String)"Operation failure");
    }

    @Override
    public int delete(HeraTraceEtlConfig config) {
        HeraTraceEtlConfig heraTraceEtlConfig = (HeraTraceEtlConfig)this.heraTraceEtlConfigMapper.selectById((Serializable)config.getId());
        int i = this.heraTraceEtlConfigMapper.deleteById((Serializable)config.getId());
        if (i > 0) {
            this.asyncNotify.submit(() -> {
                try {
                    this.traceEtlService.deleteConfig(heraTraceEtlConfig);
                }
                catch (Exception e) {
                    log.error("delete sync etl error : ", (Throwable)e);
                }
            });
        }
        return i;
    }
}

