/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HostUtil {
    private static final Pattern ipv4Regx = Pattern.compile("^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$");
    private static final Pattern ipv6Regx = Pattern.compile("^([\\da-fA-F]{1,4}:){6}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^::([\\da-fA-F]{1,4}:){0,4}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:):([\\da-fA-F]{1,4}:){0,3}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:){2}:([\\da-fA-F]{1,4}:){0,2}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:){3}:([\\da-fA-F]{1,4}:){0,1}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:){4}:((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:){7}[\\da-fA-F]{1,4}$|^:((:[\\da-fA-F]{1,4}){1,6}|:)$|^[\\da-fA-F]{1,4}:((:[\\da-fA-F]{1,4}){1,5}|:)$|^([\\da-fA-F]{1,4}:){2}((:[\\da-fA-F]{1,4}){1,4}|:)$|^([\\da-fA-F]{1,4}:){3}((:[\\da-fA-F]{1,4}){1,3}|:)$|^([\\da-fA-F]{1,4}:){4}((:[\\da-fA-F]{1,4}){1,2}|:)$|^([\\da-fA-F]{1,4}:){5}:([\\da-fA-F]{1,4})?$|^([\\da-fA-F]{1,4}:){6}:$");

    public static final String getDomain(String origin) {
        if (StringUtils.isBlank((CharSequence)origin)) {
            return null;
        }
        String host = null;
        try {
            boolean hasProtocol;
            boolean bl = hasProtocol = ((String)origin).startsWith("http://") || ((String)origin).startsWith("https://");
            if (!hasProtocol) {
                origin = "http://" + (String)origin;
            }
            host = new URL((String)origin).getHost();
        }
        catch (MalformedURLException hasProtocol) {
            // empty catch block
        }
        if (StringUtils.isBlank(host)) {
            return null;
        }
        if (ipv4Regx.matcher(host).find()) {
            return null;
        }
        if (ipv6Regx.matcher(host).find()) {
            return null;
        }
        int findCt = 0;
        StringBuilder domain = new StringBuilder();
        char[] cs = host.toCharArray();
        for (int i = cs.length - 1; i >= 0 && (cs[i] != '.' || ++findCt < 2); --i) {
            domain.append(cs[i]);
        }
        if (findCt >= 2) {
            return domain.reverse().toString();
        }
        return host;
    }
}

