/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.util;

import com.xiaomi.mone.tpc.login.util.HostUtil;
import com.xiaomi.mone.tpc.login.vo.AuthTokenVo;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoceanTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(DoceanTokenUtil.class);

    public static void setCookie(AuthUserVo userVo, MvcContext mvcContext) {
        String domain;
        StringBuilder setCookie = new StringBuilder();
        setCookie.append("TPC_TOKEN").append("=").append(userVo.getToken());
        setCookie.append("; ");
        String origin = Optional.ofNullable((String)mvcContext.getHeaders().get("Origin")).orElse((String)mvcContext.getHeaders().get("origin"));
        if (StringUtils.isBlank((CharSequence)origin)) {
            origin = Optional.ofNullable((String)mvcContext.getHeaders().get("Host")).orElse((String)mvcContext.getHeaders().get("host"));
        }
        if (StringUtils.isNotBlank((CharSequence)(domain = HostUtil.getDomain(origin)))) {
            setCookie.append("domain=").append(domain);
            setCookie.append("; ");
        }
        setCookie.append("MaxAge=").append(userVo.getExprTime());
        setCookie.append("; ");
        setCookie.append("Path=/");
        mvcContext.getResHeaders().put("Set-Cookie", setCookie.toString());
    }

    public static final AuthTokenVo parseAuthToken(MvcContext mvcContext) {
        String[] kvArr;
        String authToken;
        if (mvcContext.getParams() != null && mvcContext.getParams().getAsJsonObject().get("TPC_TOKEN") != null && StringUtils.isNotBlank((CharSequence)(authToken = mvcContext.getParams().getAsJsonObject().get("TPC_TOKEN").getAsString()))) {
            AuthTokenVo tokenVo = new AuthTokenVo();
            tokenVo.setAuthToken(authToken);
            tokenVo.setFromCookie(false);
            return tokenVo;
        }
        String referer = Optional.ofNullable((String)mvcContext.getHeaders().get("Referer")).orElse((String)mvcContext.getHeaders().get("referer"));
        logger.info("referer={}", (Object)referer);
        if (StringUtils.isBlank((CharSequence)referer)) {
            return DoceanTokenUtil.getAuthToken(mvcContext);
        }
        String[] arr = referer.split("\\?");
        if (arr.length != 2) {
            return DoceanTokenUtil.getAuthToken(mvcContext);
        }
        HashMap params = new HashMap();
        for (String kv : kvArr = arr[1].split("\\&")) {
            String[] subKvArr = kv.split("\\=");
            if (subKvArr.length != 2 || !subKvArr[0].equals("TPC_TOKEN")) continue;
            AuthTokenVo tokenVo = new AuthTokenVo();
            tokenVo.setAuthToken(subKvArr[1]);
            tokenVo.setFromCookie(false);
            return tokenVo;
        }
        return DoceanTokenUtil.getAuthToken(mvcContext);
    }

    private static final AuthTokenVo getAuthToken(MvcContext mvcContext) {
        String[] cookies;
        String cookieStr = Optional.ofNullable((String)mvcContext.getHeaders().get("Cookie")).orElse((String)mvcContext.getHeaders().get("cookie"));
        if (StringUtils.isBlank((CharSequence)cookieStr)) {
            return null;
        }
        for (String cookie : cookies = cookieStr.split("; ")) {
            String[] kv = cookie.split("=");
            if (kv == null || kv.length != 2) {
                return null;
            }
            if (!kv[0].equals("TPC_TOKEN")) continue;
            AuthTokenVo tokenVo = new AuthTokenVo();
            tokenVo.setAuthToken(kv[1]);
            tokenVo.setFromCookie(true);
            return tokenVo;
        }
        return null;
    }
}

