/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ozhera.log.parse.CustomLogParser;
import org.apache.ozhera.log.parse.JsonLogParser;
import org.apache.ozhera.log.parse.LogParser;
import org.apache.ozhera.log.parse.LogParserData;
import org.apache.ozhera.log.parse.NginxLogParser;
import org.apache.ozhera.log.parse.RawLogParser;
import org.apache.ozhera.log.parse.RegexLogParser;
import org.apache.ozhera.log.parse.SeparatorLogParser;

public class LogParserFactory {
    private LogParserFactory() {
    }

    public static LogParser getLogParser(Integer parseType, String keyList, String valueList, String parseScript) {
        return LogParserFactory.getLogParser(parseType, keyList, valueList, parseScript, "", "", "", "");
    }

    public static LogParser getLogParser(Integer parseType, String keyList, String valueList, String parseScript, String topicName, String tailName, String mqTag, String logStoreName) {
        LogParserData logParserData = LogParserData.builder().keyList(keyList).valueList(valueList).parseScript(parseScript).topicName(topicName).tailName(tailName).mqTag(mqTag).logStoreName(logStoreName).build();
        LogParserEnum parserEnum = LogParserEnum.getByCode(parseType);
        if (null == parserEnum) {
            return new RawLogParser(logParserData);
        }
        switch (parserEnum.ordinal()) {
            case 1: {
                return new SeparatorLogParser(logParserData);
            }
            case 2: {
                return new CustomLogParser(logParserData);
            }
            case 3: {
                return new RegexLogParser(logParserData);
            }
            case 4: {
                return new JsonLogParser(logParserData);
            }
            case 5: {
                return new NginxLogParser(logParserData);
            }
        }
        return new RawLogParser(logParserData);
    }

    public static enum LogParserEnum {
        RAW_LOG_PARSE(1, "\u539f\u59cb\u683c\u5f0f"),
        SEPARATOR_PARSE(2, "\u5206\u5272\u7b26\u89e3\u6790"),
        CUSTOM_PARSE(5, "\u81ea\u5b9a\u4e49\u811a\u672c\u89e3\u6790"),
        REGEX_PARSE(6, "\u6b63\u5219\u8868\u8fbe\u5f0f"),
        JSON_PARSE(7, "JSON\u89e3\u6790"),
        NGINX_PARSE(8, "Nginx\u89e3\u6790");

        private Integer code;
        private String name;

        private LogParserEnum(Integer code, String name) {
            this.code = code;
            this.name = name;
        }

        public static LogParserEnum getByCode(Integer code) {
            return Arrays.stream(LogParserEnum.values()).filter(logParserEnum -> Objects.equals(logParserEnum.code, code)).findFirst().orElse(null);
        }

        public Integer getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }
    }
}

