/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathUtils.class);
    private static final int MINIMUM_LEVELS = 3;
    public static final String PATH_WILDCARD = "*";
    public static final String MULTI_FILE_PREFIX = "(";
    public static final String MULTI_FILE_SUFFIX = ")";
    private static final String NEO_FILE_PREFIX = "/home/work/logs/neo-logs/(";
    public static final String SPLIT_VERTICAL_LINE = "\\|";
    public static final String SEPARATOR = "/";

    public static List<String> parseLevel5Directory(String origPath) {
        String[] pathArray;
        ArrayList pathList = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)origPath)) {
            return pathList;
        }
        for (String path : pathArray = origPath.split(",")) {
            path = PathUtils.pathTrim(path);
            String basePath = path.substring(0, path.lastIndexOf(SEPARATOR));
            String fileName = path.substring(path.lastIndexOf(SEPARATOR) + 1);
            String[] fileArray = path.split(SEPARATOR);
            if (fileArray.length < 3) {
                pathList.add(path);
                continue;
            }
            String fixedBasePath = basePath.substring(0, basePath.lastIndexOf(SEPARATOR));
            Object regexPattern = basePath.substring(basePath.lastIndexOf(SEPARATOR) + 1);
            if (StringUtils.startsWith((CharSequence)fixedBasePath, (CharSequence)NEO_FILE_PREFIX)) {
                regexPattern = MULTI_FILE_PREFIX + StringUtils.substringBetween((String)fixedBasePath, (String)MULTI_FILE_PREFIX, (String)MULTI_FILE_SUFFIX) + MULTI_FILE_SUFFIX;
                fixedBasePath = NEO_FILE_PREFIX.substring(0, NEO_FILE_PREFIX.length() - 2);
            }
            if (((String)regexPattern).trim().equals(PATH_WILDCARD)) {
                try {
                    PathUtils.readFile(fixedBasePath, fileName, pathList);
                }
                catch (FileNotFoundException e) {
                    log.error("[PathUtils.ParseLevel5Directory] file[{}] not found err:", (Object)(basePath + fileName), (Object)e);
                }
                catch (Exception e) {
                    log.error("[PathUtils.ParseLevel5Directory] path:[{}],err:", (Object)(basePath + fileName), (Object)e);
                }
                continue;
            }
            if (basePath.contains(MULTI_FILE_PREFIX) && basePath.contains(MULTI_FILE_SUFFIX) && !fileName.contains(PATH_WILDCARD)) {
                String multiDirectories = StringUtils.substringBetween((String)basePath, (String)MULTI_FILE_PREFIX, (String)MULTI_FILE_SUFFIX);
                String directoryPrefix = StringUtils.substringBefore((String)basePath, (String)MULTI_FILE_PREFIX);
                String directorySuffix = StringUtils.substringAfter((String)basePath, (String)MULTI_FILE_SUFFIX);
                PathUtils.handleMultiDirectories(multiDirectories, fileName, directoryPrefix, directorySuffix, SEPARATOR, pathList);
                continue;
            }
            if (fileName.contains(PATH_WILDCARD)) {
                PathUtils.handleMultipleDirectoryFile(basePath, fileName, pathList);
                continue;
            }
            if (origPath.contains(PATH_WILDCARD)) {
                basePath = StringUtils.substringBefore((String)origPath, (String)PATH_WILDCARD);
                String fileSuffix = StringUtils.substringAfter((String)origPath, (String)PATH_WILDCARD);
                try {
                    PathUtils.readFile(basePath, fileSuffix, pathList);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (String serverName : fileName.split(SPLIT_VERTICAL_LINE)) {
                pathList.add(basePath + SEPARATOR + serverName);
            }
        }
        return pathList;
    }

    public static List<String> buildMultipleDirectories(String multipleDire) {
        String[] multipleDts;
        ArrayList pathList = Lists.newArrayList();
        for (String multipleDt : multipleDts = multipleDire.split(",")) {
            if (multipleDt.contains(MULTI_FILE_PREFIX) && multipleDt.contains(MULTI_FILE_SUFFIX)) {
                String[] directoryArray = multipleDt.split(SEPARATOR);
                String directory = "";
                List<Object> directories = Lists.newArrayList();
                for (String perDire : directoryArray) {
                    if (!perDire.startsWith(MULTI_FILE_PREFIX) || !perDire.endsWith(MULTI_FILE_SUFFIX)) continue;
                    directory = perDire;
                    directories = Arrays.asList(StringUtils.substringBetween((String)perDire, (String)MULTI_FILE_PREFIX, (String)MULTI_FILE_SUFFIX).split(SPLIT_VERTICAL_LINE));
                }
                if (!StringUtils.isNotBlank((CharSequence)directory)) continue;
                String prefix = StringUtils.substringBeforeLast((String)multipleDt, (String)directory);
                String suffix = StringUtils.substringAfter((String)multipleDt, (String)directory);
                for (String directoryTemp : directories) {
                    pathList.add(String.format("%s%s%s", prefix, directoryTemp, suffix));
                }
                continue;
            }
            pathList.add(multipleDt);
        }
        return pathList;
    }

    private static void handleMultipleDirectoryFile(String basePath, String fileNamePattern, List<String> pathList) {
        if (basePath.contains(MULTI_FILE_PREFIX) && basePath.contains(MULTI_FILE_SUFFIX)) {
            String multiDirectories = StringUtils.substringBetween((String)basePath, (String)MULTI_FILE_PREFIX, (String)MULTI_FILE_SUFFIX);
            String directoryPrefix = StringUtils.substringBefore((String)basePath, (String)MULTI_FILE_PREFIX);
            String directorySuffix = StringUtils.substringAfter((String)basePath, (String)MULTI_FILE_SUFFIX);
            for (String directory : multiDirectories.split(SPLIT_VERTICAL_LINE)) {
                String basePathSingle = directoryPrefix + directory + directorySuffix;
                pathList.addAll(PathUtils.findRulePatternFiles(basePathSingle, fileNamePattern));
            }
        } else {
            pathList.addAll(PathUtils.findRulePatternFiles(basePath, fileNamePattern));
        }
    }

    private static void handleMultiDirectories(String multiDirectories, String fileName, String directoryPrefix, String directorySuffix, String separator, List<String> pathList) {
        for (String directory : multiDirectories.split(SPLIT_VERTICAL_LINE)) {
            if (fileName.contains(MULTI_FILE_PREFIX) || fileName.contains(MULTI_FILE_SUFFIX)) {
                for (String singleFileName : StringUtils.substringBetween((String)fileName, (String)MULTI_FILE_PREFIX, (String)MULTI_FILE_SUFFIX).split(SPLIT_VERTICAL_LINE)) {
                    pathList.add(directoryPrefix + directory + directorySuffix + separator + singleFileName);
                }
                continue;
            }
            for (String singleFileName : fileName.split(SPLIT_VERTICAL_LINE)) {
                pathList.add(directoryPrefix + directory + directorySuffix + separator + singleFileName);
            }
        }
    }

    public static List<String> parseWatchDirectory(String origPath) {
        String[] pathArray;
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)origPath)) {
            return result;
        }
        for (String path : pathArray = origPath.split(",")) {
            path = PathUtils.pathTrim(path);
            String basePath = path.substring(0, path.lastIndexOf(SEPARATOR));
            String fixedBasePath = basePath.substring(0, basePath.lastIndexOf(SEPARATOR));
            Object regexPattern = basePath.substring(basePath.lastIndexOf(SEPARATOR) + 1);
            if (StringUtils.startsWith((CharSequence)fixedBasePath, (CharSequence)NEO_FILE_PREFIX)) {
                regexPattern = MULTI_FILE_PREFIX + StringUtils.substringBetween((String)fixedBasePath, (String)MULTI_FILE_PREFIX, (String)MULTI_FILE_SUFFIX) + MULTI_FILE_SUFFIX;
                fixedBasePath = NEO_FILE_PREFIX.substring(0, NEO_FILE_PREFIX.length() - 2);
            }
            if (((String)regexPattern).trim().equals(PATH_WILDCARD)) {
                result.add(fixedBasePath);
                continue;
            }
            if (((String)regexPattern).startsWith(MULTI_FILE_PREFIX) && ((String)regexPattern).endsWith(MULTI_FILE_SUFFIX)) {
                String patterns = ((String)regexPattern).substring(1, ((String)regexPattern).length() - 1);
                String[] patternArr = patterns.split(SPLIT_VERTICAL_LINE);
                String originFilePrefix = fixedBasePath + SEPARATOR + (String)regexPattern;
                String regexRightPath = path.substring(originFilePrefix.length() + 1);
                Object rightDir = "";
                if (regexRightPath.split(SEPARATOR).length > 1) {
                    rightDir = regexRightPath.substring(0, regexRightPath.lastIndexOf(SEPARATOR));
                    rightDir = SEPARATOR + Arrays.stream(((String)rightDir).split(SEPARATOR)).findFirst().get();
                }
                for (String p : patternArr) {
                    String watchPath = fixedBasePath + SEPARATOR + p + (String)rightDir;
                    result.add(watchPath);
                }
                continue;
            }
            if (basePath.contains(MULTI_FILE_PREFIX) && basePath.contains(MULTI_FILE_SUFFIX)) {
                String multiDirectories = StringUtils.substringBetween((String)basePath, (String)MULTI_FILE_PREFIX, (String)MULTI_FILE_SUFFIX);
                String directoryPrefix = StringUtils.substringBefore((String)basePath, (String)MULTI_FILE_PREFIX);
                String directorySuffix = StringUtils.substringAfter((String)basePath, (String)MULTI_FILE_SUFFIX);
                for (String directory : multiDirectories.split(SPLIT_VERTICAL_LINE)) {
                    result.add(directoryPrefix + directory + directorySuffix);
                }
                continue;
            }
            result.add(basePath);
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    private static String pathTrim(String path) {
        path = path.replaceAll("//", SEPARATOR);
        return path;
    }

    private static void readFile(String filepath, String fileName, List<String> list) throws FileNotFoundException, IOException {
        try {
            File file = new File(filepath);
            if (!file.isDirectory()) {
                return;
            }
            if (file.isDirectory()) {
                String[] fileList = file.list();
                for (int i = 0; i < fileList.length; ++i) {
                    String subPath = filepath.endsWith(SEPARATOR) ? filepath + fileList[i] : filepath + SEPARATOR + fileList[i];
                    File subFile = new File(subPath);
                    if (!subFile.isDirectory() && StringUtils.equals((CharSequence)subFile.getName(), (CharSequence)fileName)) {
                        list.add(subFile.getPath());
                        continue;
                    }
                    if (!subFile.isDirectory()) continue;
                    PathUtils.readFile(subPath, fileName, list);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private static void readFile(String filepath, String fileName, String dictionaries, List<String> list) throws FileNotFoundException, IOException {
        try {
            File file = new File(filepath);
            if (!file.isDirectory()) {
                return;
            }
            if (file.isDirectory()) {
                String[] fileList = file.list();
                for (int i = 0; i < fileList.length; ++i) {
                    String subPath = filepath.endsWith(SEPARATOR) ? filepath + fileList[i] : filepath + SEPARATOR + fileList[i];
                    File subFile = new File(subPath);
                    if (!subFile.isDirectory() && StringUtils.equals((CharSequence)subFile.getName(), (CharSequence)fileName)) {
                        list.add(subFile.getPath());
                        continue;
                    }
                    if (!subFile.isDirectory()) continue;
                    PathUtils.readFile(subPath, fileName, list);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static List<String> findRulePatternFiles(String directory, String patternStr) {
        File file = new File(directory);
        if (!patternStr.contains(".*")) {
            patternStr = patternStr.replaceAll("\\*", ".*");
        }
        if (patternStr.startsWith(PATH_WILDCARD)) {
            patternStr = patternStr.replaceFirst("\\*", ".*");
        }
        Pattern compile = Pattern.compile(patternStr);
        if (file.isDirectory()) {
            return Arrays.stream(file.list()).filter(name -> compile.matcher((CharSequence)name).matches()).map(s -> String.format("%s%s%s", directory, SEPARATOR, s)).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public static void dismantlingStrWithSymbol(String originStr, List<String> cleanedPathList) {
        if (StringUtils.isBlank((CharSequence)originStr)) {
            return;
        }
        String pathPrefix = StringUtils.substringBefore((String)originStr, (String)MULTI_FILE_PREFIX);
        String betweenStr = StringUtils.substringBetween((String)originStr, (String)MULTI_FILE_PREFIX, (String)MULTI_FILE_SUFFIX);
        if (StringUtils.isBlank((CharSequence)betweenStr)) {
            cleanedPathList.add(originStr);
            return;
        }
        String pathSuffix = StringUtils.substringAfter((String)originStr, (String)MULTI_FILE_SUFFIX);
        if (StringUtils.isNotBlank((CharSequence)betweenStr)) {
            String[] directories;
            for (String perDirectory : directories = StringUtils.split((String)betweenStr, (String)SPLIT_VERTICAL_LINE)) {
                String realPath = String.format("%s%s%s", pathPrefix, perDirectory, pathSuffix);
                PathUtils.dismantlingStrWithSymbol(realPath, cleanedPathList);
            }
        }
    }
}

