/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.internal.asm.ASMUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

final class ConstructorFunction<T>
implements Function<Map<Long, Object>, T> {
    final Constructor constructor;
    final Function function;
    final BiFunction biFunction;
    final Parameter[] parameters;
    final String[] paramNames;
    final boolean kotlinMaker;
    final long[] hashCodes;
    final List<Constructor> alternateConstructors;
    Map<Set<Long>, Constructor> alternateConstructorMap;
    Map<Set<Long>, String[]> alternateConstructorNames;
    Map<Set<Long>, long[]> alternateConstructorNameHashCodes;
    Map<Set<Long>, Type[]> alternateConstructorArgTypes;

    ConstructorFunction(List<Constructor> alternateConstructors, Constructor constructor, Function function, BiFunction biFunction, Constructor markerConstructor, String ... paramNames) {
        this.kotlinMaker = markerConstructor != null;
        this.function = function;
        this.biFunction = biFunction;
        this.constructor = this.kotlinMaker ? markerConstructor : constructor;
        this.parameters = constructor.getParameters();
        this.paramNames = paramNames;
        this.hashCodes = new long[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            String name = i < paramNames.length ? paramNames[i] : this.parameters[i].getName();
            this.hashCodes[i] = Fnv.hashCode64(name);
        }
        this.alternateConstructors = alternateConstructors;
        if (alternateConstructors != null) {
            this.alternateConstructorMap = new HashMap<Set<Long>, Constructor>(alternateConstructors.size());
            this.alternateConstructorNames = new HashMap<Set<Long>, String[]>(alternateConstructors.size());
            this.alternateConstructorArgTypes = new HashMap<Set<Long>, Type[]>(alternateConstructors.size());
            this.alternateConstructorNameHashCodes = new HashMap<Set<Long>, long[]>(alternateConstructors.size());
            for (Constructor alternateConstructor : alternateConstructors) {
                alternateConstructor.setAccessible(true);
                String[] parameterNames = ASMUtils.lookupParameterNames(alternateConstructor);
                long[] parameterNameHashCodes = new long[parameterNames.length];
                Type[] parameterTypes = alternateConstructor.getGenericParameterTypes();
                HashSet<Long> paramHashCodes = new HashSet<Long>(parameterNames.length);
                for (int i = 0; i < parameterNames.length; ++i) {
                    long hashCode64;
                    parameterNameHashCodes[i] = hashCode64 = Fnv.hashCode64(parameterNames[i]);
                    paramHashCodes.add(hashCode64);
                }
                this.alternateConstructorMap.put(paramHashCodes, alternateConstructor);
                this.alternateConstructorNames.put(paramHashCodes, parameterNames);
                this.alternateConstructorNameHashCodes.put(paramHashCodes, parameterNameHashCodes);
                this.alternateConstructorArgTypes.put(paramHashCodes, parameterTypes);
            }
        }
    }

    @Override
    public T apply(Map<Long, Object> values) {
        int i;
        Object[] args;
        Set<Long> key;
        Constructor constructor;
        boolean containsAll = true;
        for (long hashCode : this.hashCodes) {
            if (values.containsKey(hashCode)) continue;
            containsAll = false;
            break;
        }
        if (!containsAll && this.alternateConstructorMap != null && (constructor = this.alternateConstructorMap.get(key = values.keySet())) != null) {
            long[] hashCodes = this.alternateConstructorNameHashCodes.get(key);
            Type[] paramTypes = this.alternateConstructorArgTypes.get(key);
            Object[] args2 = new Object[hashCodes.length];
            for (int i2 = 0; i2 < hashCodes.length; ++i2) {
                Object arg = values.get(hashCodes[i2]);
                Type paramType = paramTypes[i2];
                if (arg == null) {
                    arg = TypeUtils.getDefaultValue(paramType);
                }
                args2[i2] = arg;
            }
            try {
                return constructor.newInstance(args2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("invoke constructor error, " + constructor, e);
            }
        }
        if (this.function != null && this.parameters.length == 1) {
            Parameter param = this.parameters[0];
            Object arg = values.get(this.hashCodes[0]);
            Class<?> paramType = param.getType();
            if (arg == null) {
                arg = TypeUtils.getDefaultValue(paramType);
            } else if (!paramType.isInstance(arg)) {
                arg = TypeUtils.cast(arg, paramType);
            }
            return (T)this.function.apply(arg);
        }
        if (this.biFunction != null && this.parameters.length == 2) {
            Object arg0 = values.get(this.hashCodes[0]);
            Parameter param0 = this.parameters[0];
            Class<?> param0Type = param0.getType();
            if (arg0 == null) {
                arg0 = TypeUtils.getDefaultValue(param0Type);
            } else if (!param0Type.isInstance(arg0)) {
                arg0 = TypeUtils.cast(arg0, param0Type);
            }
            Object arg1 = values.get(this.hashCodes[1]);
            Parameter param1 = this.parameters[1];
            Class<?> param1Type = param1.getType();
            if (arg1 == null) {
                arg1 = TypeUtils.getDefaultValue(param1Type);
            } else if (!param1Type.isInstance(arg1)) {
                arg1 = TypeUtils.cast(arg1, param1Type);
            }
            return (T)this.biFunction.apply(arg0, arg1);
        }
        if (this.kotlinMaker) {
            args = new Object[this.parameters.length + 2];
            int flag = 0;
            for (i = 0; i < this.parameters.length; ++i) {
                Object arg = values.get(this.hashCodes[i]);
                if (arg != null) {
                    args[i] = arg;
                    continue;
                }
                flag |= 1 << i;
                Class<?> paramType = this.parameters[i].getType();
                if (!paramType.isPrimitive()) continue;
                args[i] = TypeUtils.getDefaultValue(paramType);
            }
            args[i] = flag;
        } else {
            args = new Object[this.parameters.length];
            for (i = 0; i < args.length; ++i) {
                Class<?> paramType = this.parameters[i].getType();
                Object arg = values.get(this.hashCodes[i]);
                if (arg == null) {
                    arg = TypeUtils.getDefaultValue(paramType);
                } else if (!paramType.isInstance(arg)) {
                    arg = TypeUtils.cast(arg, paramType);
                }
                args[i] = arg;
            }
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new JSONException("invoke constructor error, " + this.constructor, e);
        }
    }
}

