/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.AppQualityMarketDao;
import org.apache.ozhera.monitor.dao.model.AppQualityMarket;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.QualityMarketService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QualityMarketServiceImpl
implements QualityMarketService {
    private static final Logger log = LoggerFactory.getLogger(QualityMarketServiceImpl.class);
    @Autowired
    AppQualityMarketDao appQualityMarketDao;

    @Override
    public Result createMarket(String user, String marketName, String serviceList, String remark) {
        try {
            String[] services = serviceList.split(";");
            AppQualityMarket appQualityMarket = new AppQualityMarket();
            appQualityMarket.setMarketName(marketName.trim());
            appQualityMarket.setServiceList(serviceList.trim());
            appQualityMarket.setCreator(user);
            appQualityMarket.setLastUpdater(user);
            appQualityMarket.setRemark(remark.trim());
            int dbResult = this.appQualityMarketDao.insertServiceMarket(appQualityMarket);
            log.info("QualityMarketService.createMarket dbResult: {}", (Object)dbResult);
            return Result.success((Object)"success");
        }
        catch (Exception e) {
            log.error("QualityMarketService.createMarket error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result searchMarket(String user, int id) {
        try {
            AppQualityMarket appQualityMarket = this.appQualityMarketDao.SearchAppQualityMarket(id);
            return Result.success((Object)appQualityMarket);
        }
        catch (Exception e) {
            log.error("QualityMarketService.searchMarket error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result updateMarket(String user, int id, String serviceList, String marketName, String remark) {
        try {
            AppQualityMarket appQualityMarket = this.appQualityMarketDao.SearchAppQualityMarket(id);
            if (appQualityMarket == null) {
                return Result.fail((ErrorCode)ErrorCode.nonExistentServiceMarketId);
            }
            appQualityMarket.setMarketName(marketName.trim());
            appQualityMarket.setServiceList(serviceList.trim());
            appQualityMarket.setLastUpdater(user);
            appQualityMarket.setRemark(remark.trim());
            int dbResult = this.appQualityMarketDao.updateQualityMarket(appQualityMarket);
            log.info("QualityMarketService.updateMarket dbResult: {}", (Object)dbResult);
            return Result.success((Object)"success");
        }
        catch (Exception e) {
            log.error("QualityMarketService.updateMarket error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result deleteMarket(String user, Integer id) {
        try {
            AppQualityMarket appQualityMarket = this.appQualityMarketDao.SearchAppQualityMarket(id);
            if (appQualityMarket == null) {
                return Result.fail((ErrorCode)ErrorCode.nonExistentServiceMarketId);
            }
            int result = this.appQualityMarketDao.deleteQualityMarket(id);
            log.info("QualityMarketService.deleteMarket dbResult:{}", (Object)result);
            return Result.success((Object)"success");
        }
        catch (Exception e) {
            log.error("QualityMarketService.deleteMarket error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result searchMarketList(String user, int pageSize, int pageNo, String creator, String marketName, String serviceName) {
        AppQualityMarket appQualityMarket = new AppQualityMarket();
        if (StringUtils.isNotEmpty((CharSequence)creator)) {
            appQualityMarket.setCreator(creator);
        }
        PageData<List<AppQualityMarket>> pd = new PageData<List<AppQualityMarket>>();
        pd.setPage(pageNo);
        pd.setPageSize(pageSize);
        pd.setTotal(this.appQualityMarketDao.getTotal(creator, marketName, serviceName));
        pd.setList(this.appQualityMarketDao.SearchAppQualityMarketList(pageNo, pageSize, creator, marketName, serviceName));
        return Result.success(pd);
    }
}

