/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.aop.action;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.ozhera.monitor.bo.HeraReqInfo;
import org.apache.ozhera.monitor.bo.OperLogAction;
import org.apache.ozhera.monitor.dao.model.AlarmStrategy;
import org.apache.ozhera.monitor.dao.model.AppAlarmRule;
import org.apache.ozhera.monitor.dao.model.HeraOperLog;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionArg2;
import org.apache.ozhera.monitor.service.aop.helper.HeraRequestMappingActionStrategyHelper;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleData;
import org.nutz.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Service
public class HeraRequestMappingActionRuleEdit
extends HeraRequestMappingActionArg2<HttpServletRequest, AlarmRuleData, Result> {
    private static final Logger log = LoggerFactory.getLogger(HeraRequestMappingActionRuleEdit.class);
    @Autowired
    private HeraRequestMappingActionStrategyHelper heraRequestMappingActionStrategyHelper;

    @Override
    public void beforeAction(HttpServletRequest arg1, AlarmRuleData arg2, HeraReqInfo heraReqInfo) {
        if (arg2 == null || arg2.getStrategyId() == null) {
            return;
        }
        Pair<AlarmStrategy, List<AppAlarmRule>> pair = this.heraRequestMappingActionStrategyHelper.queryStrategyById(arg2.getStrategyId());
        HeraOperLog operLog = new HeraOperLog();
        operLog.setOperName(heraReqInfo.getUser());
        operLog.setModuleName(heraReqInfo.getModuleName());
        operLog.setInterfaceName(heraReqInfo.getInterfaceName());
        operLog.setInterfaceUrl(heraReqInfo.getReqUrl());
        operLog.setAction(OperLogAction.STRATEGY_EDIT.getAction());
        this.heraRequestMappingActionStrategyHelper.saveHeraOperLogs(pair, operLog, heraReqInfo);
        if (operLog.getId() != null) {
            heraReqInfo.setOperLog(operLog);
        }
    }

    @Override
    public void afterAction(HttpServletRequest arg1, AlarmRuleData arg2, HeraReqInfo heraReqInfo, Result result) {
        if (arg2 == null || arg2.getStrategyId() == null) {
            return;
        }
        Integer strategyId = this.heraRequestMappingActionStrategyHelper.getStrategyIdByRuleId(arg2.getStrategyId());
        if (strategyId == null) {
            return;
        }
        Pair<AlarmStrategy, List<AppAlarmRule>> pair = this.heraRequestMappingActionStrategyHelper.queryStrategyById(strategyId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", result.getCode());
        resultMap.put("message", result.getMessage());
        heraReqInfo.getOperLog().setResultDesc(Json.toJson(resultMap));
        this.heraRequestMappingActionStrategyHelper.saveHeraOperLogs(pair, heraReqInfo.getOperLog(), heraReqInfo);
    }
}

