/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.ozhera.monitor.dao.model.HeraOperLog;
import org.nutz.dao.Dao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HeraOperLogDao {
    private static final Logger log = LoggerFactory.getLogger(HeraOperLogDao.class);
    @Autowired
    private Dao dao;

    public HeraOperLog getById(Integer id) {
        return (HeraOperLog)this.dao.fetch(HeraOperLog.class, (long)id.intValue());
    }

    public boolean insertOrUpdate(HeraOperLog log) {
        log.setUpdateTime(new Date());
        if (log.getCreateTime() == null) {
            log.setCreateTime(new Date());
        }
        if (log.getOperName() == null) {
            log.setOperName("");
        }
        if (log.getLogType() == null) {
            log.setLogType(0);
        }
        if (log.getDataType() == null) {
            log.setDataType(0);
        }
        if (log.getBeforeParentId() == null) {
            log.setBeforeParentId(0);
        }
        if (log.getAfterParentId() == null) {
            log.setAfterParentId(0);
        }
        try {
            return this.dao.insertOrUpdate((Object)log) != null;
        }
        catch (Exception e) {
            HeraOperLogDao.log.error("HeraOperLog\u8868\u63d2\u5165\u6216\u66f4\u65b0\u5f02\u5e38\uff1b log={}", (Object)log, (Object)e);
            return false;
        }
    }

    public void batchInsert(List<HeraOperLog> logs) {
        if (logs == null || logs.isEmpty()) {
            return;
        }
        for (HeraOperLog log : logs) {
            log.setUpdateTime(new Date());
            if (log.getCreateTime() == null) {
                log.setCreateTime(new Date());
            }
            if (log.getOperName() == null) {
                log.setOperName("");
            }
            if (log.getLogType() == null) {
                log.setLogType(0);
            }
            if (log.getDataType() == null) {
                log.setDataType(0);
            }
            if (log.getBeforeParentId() == null) {
                log.setBeforeParentId(0);
            }
            if (log.getAfterParentId() != null) continue;
            log.setAfterParentId(0);
        }
        try {
            this.dao.fastInsert(logs);
        }
        catch (Exception e) {
            log.error("HeraOperLog\u8868\u6279\u91cf\u63d2\u5165\u5f02\u5e38\uff1b logs={}", logs, (Object)e);
        }
    }

    public boolean updateById(HeraOperLog log) {
        if (log.getUpdateTime() == null) {
            log.setUpdateTime(new Date());
        }
        try {
            return this.dao.updateIgnoreNull((Object)log) > 0;
        }
        catch (Exception e) {
            HeraOperLogDao.log.error("HeraOperLog\u8868\u66f4\u65b0\u5f02\u5e38\uff1b template={}", (Object)log, (Object)e);
            return false;
        }
    }

    public boolean deleteById(Integer id) {
        try {
            return this.dao.delete(HeraOperLog.class, (long)id.intValue()) > 0;
        }
        catch (Exception e) {
            log.error("HeraOperLog\u8868\u5220\u9664\u5f02\u5e38\uff1b id={}", (Object)id, (Object)e);
            return false;
        }
    }
}

