/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.mapper.AppCapacityAutoAdjustRecordMapper;
import org.apache.ozhera.monitor.dao.model.AppCapacityAutoAdjustRecord;
import org.apache.ozhera.monitor.dao.model.AppCapacityAutoAdjustRecordExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class AppCapacityAutoAdjustRecordDao {
    private static final Logger log = LoggerFactory.getLogger(AppCapacityAutoAdjustRecordDao.class);
    @Resource
    private AppCapacityAutoAdjustRecordMapper adjustRecordMapper;

    public Long count(AppCapacityAutoAdjustRecord appCapacityAutoAdjustRecord, boolean isLikeContainer) {
        AppCapacityAutoAdjustRecordExample example = new AppCapacityAutoAdjustRecordExample();
        AppCapacityAutoAdjustRecordExample.Criteria ca = example.createCriteria();
        if (appCapacityAutoAdjustRecord.getStatus() != null) {
            ca.andStatusEqualTo(appCapacityAutoAdjustRecord.getStatus());
        } else {
            ca.andStatusEqualTo(0);
        }
        if (StringUtils.isNotBlank((CharSequence)appCapacityAutoAdjustRecord.getNameSpace())) {
            ca.andNameSpaceEqualTo(appCapacityAutoAdjustRecord.getNameSpace());
        }
        if (StringUtils.isNotBlank((CharSequence)appCapacityAutoAdjustRecord.getContainer())) {
            if (isLikeContainer) {
                ca.andContainerLike(appCapacityAutoAdjustRecord.getContainer() + "%");
            } else {
                ca.andContainerEqualTo(appCapacityAutoAdjustRecord.getContainer());
            }
        }
        try {
            return this.adjustRecordMapper.countByExample(example);
        }
        catch (Exception e) {
            log.error("AppCapacityAutoAdjustDao#count error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<AppCapacityAutoAdjustRecord> query(AppCapacityAutoAdjustRecord appCapacityAutoAdjustRecord, Integer pageCount, Integer pageNum, boolean isLikeContainer) {
        if (pageCount == null) {
            pageCount = 1;
        }
        if (pageNum == null) {
            pageNum = 10;
        }
        AppCapacityAutoAdjustRecordExample example = new AppCapacityAutoAdjustRecordExample();
        AppCapacityAutoAdjustRecordExample.Criteria ca = example.createCriteria();
        if (appCapacityAutoAdjustRecord.getStatus() != null) {
            ca.andStatusEqualTo(appCapacityAutoAdjustRecord.getStatus());
        } else {
            ca.andStatusEqualTo(0);
        }
        if (StringUtils.isNotBlank((CharSequence)appCapacityAutoAdjustRecord.getNameSpace())) {
            ca.andNameSpaceEqualTo(appCapacityAutoAdjustRecord.getNameSpace());
        }
        if (StringUtils.isNotBlank((CharSequence)appCapacityAutoAdjustRecord.getContainer())) {
            if (isLikeContainer) {
                ca.andContainerLike(appCapacityAutoAdjustRecord.getContainer() + "%");
            } else {
                ca.andContainerEqualTo(appCapacityAutoAdjustRecord.getContainer());
            }
        }
        if (appCapacityAutoAdjustRecord.getEnvId() != null) {
            ca.andEnvIdEqualTo(appCapacityAutoAdjustRecord.getEnvId());
        }
        example.setOffset((pageCount - 1) * pageNum);
        example.setLimit(pageNum);
        example.setOrderByClause("id desc");
        try {
            return this.adjustRecordMapper.selectByExample(example);
        }
        catch (Exception e) {
            log.error("AppCapacityAutoAdjustRecordDao#query error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AppCapacityAutoAdjustRecord getById(Integer id) {
        if (id == null) {
            log.info("AppCapacityAutoAdjustRecordDao.getById id is null!");
            return null;
        }
        return this.adjustRecordMapper.selectByPrimaryKey(id);
    }

    public int create(AppCapacityAutoAdjustRecord appCapacityAutoAdjustRecord) {
        if (null == appCapacityAutoAdjustRecord) {
            log.error("[AppCapacityAutoAdjustRecordDao.create] null appCapacityAutoAdjustRecord");
            return 0;
        }
        appCapacityAutoAdjustRecord.setCreateTime(new Date());
        appCapacityAutoAdjustRecord.setUpdateTime(new Date());
        appCapacityAutoAdjustRecord.setStatus(0);
        try {
            int affected = this.adjustRecordMapper.insert(appCapacityAutoAdjustRecord);
            if (affected < 1) {
                log.warn("[AppCapacityAutoAdjustRecordDao.create] failed to insert appCapacityAutoAdjustRecord: {}", (Object)appCapacityAutoAdjustRecord.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppCapacityAutoAdjustRecordDao.create] failed to insert appCapacityAutoAdjustRecord: {}, err: {}", (Object)appCapacityAutoAdjustRecord.toString(), (Object)e);
            return 0;
        }
        return 1;
    }
}

