/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.mapper.AppAlarmRuleMapper;
import org.apache.ozhera.monitor.dao.model.AppAlarmRule;
import org.apache.ozhera.monitor.dao.model.AppAlarmRuleExample;
import org.apache.ozhera.monitor.service.model.prometheus.AppWithAlarmRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AppAlarmRuleDao {
    private static final Logger log = LoggerFactory.getLogger(AppAlarmRuleDao.class);
    @Autowired
    private AppAlarmRuleMapper appAlarmRuleMapper;

    public List<AppWithAlarmRules> queryRulesByAppName(String userName, String appName, Integer page, Integer pageSize) {
        if (page == null || page == 0) {
            page = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        return this.appAlarmRuleMapper.selectAlarmRuleByAppName(userName, appName, (page - 1) * pageSize, pageSize);
    }

    public Long countAlarmRuleByAppName(String userName, String appName) {
        return this.appAlarmRuleMapper.countAlarmRuleByAppName(userName, appName);
    }

    public List<AppWithAlarmRules> queryAppNoAlarmRulesConfig(String userName, String appName, Integer page, Integer pageSize) {
        if (page == null || page == 0) {
            page = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        return this.appAlarmRuleMapper.selectAppNoRulesConfig(userName, appName, (page - 1) * pageSize, pageSize);
    }

    public Long countAppNoAlarmRulesConfig(String userName, String appName) {
        return this.appAlarmRuleMapper.countAppNoRulesConfig(userName, appName);
    }

    public Long getDataTotal() {
        AppAlarmRuleExample example = new AppAlarmRuleExample();
        AppAlarmRuleExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(0);
        return this.appAlarmRuleMapper.countByExample(example);
    }

    public List<AppAlarmRule> queryTeslaRules() {
        AppAlarmRuleExample example = new AppAlarmRuleExample();
        AppAlarmRuleExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(0);
        ca.andAlarmIdIsNotNull();
        ca.andAlertIn((List)Lists.newArrayList((Object[])new String[]{"china_intranet_tesla_p99_time_cost", "tesla_intranet_availability", "tesla_outnet_availability"}));
        example.setOffset(0);
        example.setLimit(1000);
        return this.appAlarmRuleMapper.selectByExampleWithBLOBs(example);
    }

    public List<AppAlarmRule> query(AppAlarmRule appAlarmRule, Integer offset, Integer pageSize) {
        AppAlarmRuleExample example = new AppAlarmRuleExample();
        AppAlarmRuleExample.Criteria ca = example.createCriteria();
        if (appAlarmRule.getTemplateId() != null) {
            ca.andTemplateIdEqualTo(appAlarmRule.getTemplateId());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getCname()})) {
            ca.andCnameLike("%" + appAlarmRule.getCname() + "%");
        }
        if (appAlarmRule.getMetricType() != null) {
            ca.andMetricTypeEqualTo(appAlarmRule.getMetricType());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getAlert()})) {
            ca.andAlertLike("%" + appAlarmRule.getAlert() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getPriority()})) {
            ca.andPriorityEqualTo(appAlarmRule.getPriority());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getEnv()})) {
            ca.andEnvEqualTo(appAlarmRule.getEnv());
        }
        if (appAlarmRule.getIamId() != null) {
            ca.andIamIdEqualTo(appAlarmRule.getIamId());
        }
        if (appAlarmRule.getStrategyId() != null) {
            ca.andStrategyIdEqualTo(appAlarmRule.getStrategyId());
        }
        if (appAlarmRule.getRuleType() != null) {
            ca.andRuleTypeEqualTo(appAlarmRule.getRuleType());
        }
        if (appAlarmRule.getRuleStatus() != null) {
            ca.andRuleStatusEqualTo(appAlarmRule.getRuleStatus());
        }
        if (appAlarmRule.getStatus() != null) {
            ca.andStatusEqualTo(appAlarmRule.getStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getLabels()})) {
            ca.andLabelsLike("%" + appAlarmRule.getLabels() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getRemark()})) {
            ca.andRemarkLike("%" + appAlarmRule.getRemark() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getCreater()})) {
            ca.andCreaterLike("%" + appAlarmRule.getCreater() + "%");
        }
        example.setOffset(offset);
        example.setLimit(pageSize);
        example.setOrderByClause("id asc");
        return this.appAlarmRuleMapper.selectByExampleWithBLOBs(example);
    }

    public Long countByExample(AppAlarmRule appAlarmRule) {
        AppAlarmRuleExample example = new AppAlarmRuleExample();
        AppAlarmRuleExample.Criteria ca = example.createCriteria();
        if (appAlarmRule.getTemplateId() != null) {
            ca.andTemplateIdEqualTo(appAlarmRule.getTemplateId());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getCname()})) {
            ca.andCnameLike("%" + appAlarmRule.getCname() + "%");
        }
        if (appAlarmRule.getMetricType() != null) {
            ca.andMetricTypeEqualTo(appAlarmRule.getMetricType());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getAlert()})) {
            ca.andAlertLike("%" + appAlarmRule.getAlert() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getPriority()})) {
            ca.andPriorityEqualTo(appAlarmRule.getPriority());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getEnv()})) {
            ca.andEnvEqualTo(appAlarmRule.getEnv());
        }
        if (appAlarmRule.getIamId() != null) {
            ca.andIamIdEqualTo(appAlarmRule.getIamId());
        }
        if (appAlarmRule.getStrategyId() != null) {
            ca.andStrategyIdEqualTo(appAlarmRule.getStrategyId());
        }
        if (appAlarmRule.getRuleType() != null) {
            ca.andRuleTypeEqualTo(appAlarmRule.getRuleType());
        }
        if (appAlarmRule.getRuleStatus() != null) {
            ca.andRuleStatusEqualTo(appAlarmRule.getRuleStatus());
        }
        if (appAlarmRule.getStatus() != null) {
            ca.andStatusEqualTo(appAlarmRule.getStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getLabels()})) {
            ca.andLabelsLike("%" + appAlarmRule.getLabels() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getRemark()})) {
            ca.andRemarkLike("%" + appAlarmRule.getRemark() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getCreater()})) {
            ca.andCreaterLike("%" + appAlarmRule.getCreater() + "%");
        }
        return this.appAlarmRuleMapper.countByExample(example);
    }

    public int updateByIdSelective(AppAlarmRule rule) {
        return this.appAlarmRuleMapper.updateByPrimaryKeySelective(rule);
    }

    public int update(AppAlarmRule condition, AppAlarmRule value) {
        AppAlarmRuleExample example = new AppAlarmRuleExample();
        AppAlarmRuleExample.Criteria ca = example.createCriteria();
        if (condition.getTemplateId() != null) {
            ca.andTemplateIdEqualTo(condition.getTemplateId());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getCname()})) {
            ca.andCnameLike(condition.getCname());
        }
        if (condition.getMetricType() != null) {
            ca.andMetricTypeEqualTo(condition.getMetricType());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getAlert()})) {
            ca.andAlertLike(condition.getAlert());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getPriority()})) {
            ca.andPriorityEqualTo(condition.getPriority());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getEnv()})) {
            ca.andEnvEqualTo(condition.getEnv());
        }
        if (condition.getIamId() != null) {
            ca.andIamIdEqualTo(condition.getIamId());
        }
        if (condition.getRuleType() != null) {
            ca.andRuleTypeEqualTo(condition.getRuleType());
        }
        if (condition.getRuleStatus() != null) {
            ca.andRuleStatusEqualTo(condition.getRuleStatus());
        }
        if (condition.getStatus() != null) {
            ca.andStatusEqualTo(condition.getStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getRemark()})) {
            ca.andRemarkLike(condition.getRemark());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getCreater()})) {
            ca.andCreaterLike(condition.getCreater());
        }
        value.setUpdateTime(new Date());
        return this.appAlarmRuleMapper.updateByExampleSelective(value, example);
    }

    public AppAlarmRule getById(Integer id) {
        return this.appAlarmRuleMapper.selectByPrimaryKey(id);
    }

    public List<AppAlarmRule> selectByStrategyIdList(List<Integer> strategyIds) {
        return this.appAlarmRuleMapper.selectByStrategyIdList(strategyIds);
    }

    public List<AppAlarmRule> selectByStrategyId(Integer strategyId) {
        return this.appAlarmRuleMapper.selectByStrategyId(strategyId);
    }

    public int create(AppAlarmRule appAlarmRule) {
        if (null == appAlarmRule) {
            log.error("[AppAlarmRuleDao.create] null appAlarmRule");
            return 0;
        }
        appAlarmRule.setCreateTime(new Date());
        appAlarmRule.setUpdateTime(new Date());
        appAlarmRule.setStatus(0);
        try {
            int affected = this.appAlarmRuleMapper.insert(appAlarmRule);
            if (affected < 1) {
                log.warn("[AppAlarmRuleDao.create] failed to insert appAlarmRule: {}", (Object)appAlarmRule.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppAlarmRuleDao.create] failed to insert appMonitor: {}, err: {}", (Object)appAlarmRule.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public int batchInsert(List<AppAlarmRule> list) {
        try {
            int affected = this.appAlarmRuleMapper.batchInsert(list);
            if (affected < 1) {
                log.warn("[AppAlarmRuleDao.batchInsert] failed to insert ruleList: {}", list);
                return 0;
            }
            return affected;
        }
        catch (Exception e) {
            log.error("[AppAlarmRuleDao.create] failed to insert ruleList: {}", list, (Object)e);
            return 0;
        }
    }

    public int delete(AppAlarmRule appAlarmRule) {
        AppAlarmRuleExample example = new AppAlarmRuleExample();
        AppAlarmRuleExample.Criteria ca = example.createCriteria();
        if (appAlarmRule.getTemplateId() != null) {
            ca.andTemplateIdEqualTo(appAlarmRule.getTemplateId());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getCname()})) {
            ca.andCnameLike(appAlarmRule.getCname());
        }
        if (appAlarmRule.getMetricType() != null) {
            ca.andMetricTypeEqualTo(appAlarmRule.getMetricType());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getAlert()})) {
            ca.andAlertLike(appAlarmRule.getAlert());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getPriority()})) {
            ca.andPriorityEqualTo(appAlarmRule.getPriority());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getEnv()})) {
            ca.andEnvEqualTo(appAlarmRule.getEnv());
        }
        if (appAlarmRule.getIamId() != null) {
            ca.andIamIdEqualTo(appAlarmRule.getIamId());
        }
        if (appAlarmRule.getRuleType() != null) {
            ca.andRuleTypeEqualTo(appAlarmRule.getRuleType());
        }
        if (appAlarmRule.getRuleStatus() != null) {
            ca.andRuleStatusEqualTo(appAlarmRule.getRuleStatus());
        }
        if (appAlarmRule.getStatus() != null) {
            ca.andStatusEqualTo(appAlarmRule.getStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getRemark()})) {
            ca.andRemarkLike(appAlarmRule.getRemark());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appAlarmRule.getCreater()})) {
            ca.andCreaterLike(appAlarmRule.getCreater());
        }
        if (appAlarmRule.getStrategyId() != null) {
            ca.andStrategyIdEqualTo(appAlarmRule.getStrategyId());
        }
        try {
            return this.appAlarmRuleMapper.deleteByExample(example);
        }
        catch (Exception e) {
            log.error("AppAlarmRuleDao.delete error!message : {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    public int delById(Integer id) {
        try {
            return this.appAlarmRuleMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            log.error("AppAlarmRuleDao.delById error!id : {}", (Object)id, (Object)e);
            return 0;
        }
    }
}

