/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.webhook.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.nacos.api.config.annotation.NacosValue;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReview;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.webhook.domain.JsonPatch;
import org.apache.ozhera.webhook.service.HeraWebhookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HeraWebhookController {
    private static final Logger log = LoggerFactory.getLogger(HeraWebhookController.class);
    @Autowired
    private HeraWebhookService heraWebhookService;
    @NacosValue(value="${log-agent.enabled}")
    private String logAgentEnabled;

    @RequestMapping(value={"/hera-env-v1"}, method={RequestMethod.POST})
    public AdmissionReview heraEnvV1(@RequestBody String admissionReview) {
        log.info("hera webhook get request log-agent enable:{},body {}: ", (Object)this.logAgentEnabled, (Object)admissionReview);
        if (StringUtils.isEmpty((CharSequence)this.logAgentEnabled)) {
            this.logAgentEnabled = "false";
        }
        JSONObject admissionReviewJson = JSONObject.parseObject((String)admissionReview);
        JSONObject admissionReviewRequestJson = admissionReviewJson.getJSONObject("request");
        String kind = admissionReviewRequestJson.getJSONObject("kind").getString("kind");
        String uid = admissionReviewRequestJson.getString("uid");
        String patchsJson = null;
        if ("Pod".equals(kind)) {
            List<JsonPatch> patches = this.heraWebhookService.setPodEnv(admissionReviewRequestJson);
            if ("true".equals(this.logAgentEnabled)) {
                this.heraWebhookService.setLogAgent(admissionReviewRequestJson, patches);
            }
            if (patches != null && !patches.isEmpty()) {
                patchsJson = JSONObject.toJSONString(patches, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
            }
        }
        AdmissionReview admissionReviewResp = new AdmissionReview();
        admissionReviewResp.setKind(admissionReviewJson.getString("kind"));
        admissionReviewResp.setApiVersion(admissionReviewJson.getString("apiVersion"));
        AdmissionResponse admissionResponse = new AdmissionResponse();
        admissionResponse.setAllowed(Boolean.valueOf(true));
        admissionResponse.setUid(uid);
        if (StringUtils.isNotEmpty((CharSequence)patchsJson)) {
            log.info("patch json is : " + patchsJson);
            admissionResponse.setPatch(Base64.getEncoder().encodeToString(patchsJson.getBytes(StandardCharsets.UTF_8)));
            admissionResponse.setPatchType("JSONPatch");
        }
        admissionReviewResp.setResponse(admissionResponse);
        return admissionReviewResp;
    }
}

