/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mybatisplus.interceptor;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.plugin.datasource.DatasourceConfig;
import com.xiaomi.youpin.docean.plugin.mybatisplus.bo.QueryParam;
import com.xiaomi.youpin.docean.plugin.mybatisplus.bo.QueryResult;
import com.xiaomi.youpin.docean.plugin.mybatisplus.bo.UpdateParam;
import com.xiaomi.youpin.docean.plugin.mybatisplus.interceptor.InterceptorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class InterceptorForQryAndUpdate
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(InterceptorForQryAndUpdate.class);
    private InterceptorFunction function;
    private DatasourceConfig datasourceConfig;

    public InterceptorForQryAndUpdate(InterceptorFunction function) {
        this.function = function;
    }

    private List<Object> params(BoundSql boundSql, MappedStatement mappedStatement, Object parameterObject) {
        TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        Configuration configuration = mappedStatement.getConfiguration();
        List parameterMappings = boundSql.getParameterMappings();
        ArrayList list = Lists.newArrayList();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                Object value = null;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                JdbcType jdbcType = parameterMapping.getJdbcType();
                list.add(value);
            }
        }
        return list;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement target = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType t = target.getSqlCommandType();
        SqlSource sqlSource = target.getSqlSource();
        BoundSql bsql = sqlSource.getBoundSql(invocation.getArgs()[1]);
        List<Object> params = this.params(bsql, target, invocation.getArgs()[1]);
        log.info("type:{} sql:{}  ->  {} {}", new Object[]{t, bsql.getSql(), bsql.getParameterObject(), params});
        if (t.equals((Object)SqlCommandType.INSERT) || t.equals((Object)SqlCommandType.DELETE) || t.equals((Object)SqlCommandType.UPDATE)) {
            int n = this.function.update(UpdateParam.builder().sql(bsql.getSql()).dsName(this.datasourceConfig.getName()).params((String[])params.stream().map(it -> {
                if (null == it) {
                    return null;
                }
                return it.toString();
            }).toArray(String[]::new)).build());
            return n;
        }
        if (t.equals((Object)SqlCommandType.SELECT)) {
            List maps = target.getResultMaps();
            List mapping = ((ResultMap)maps.get(0)).getResultMappings();
            Class type = ((ResultMap)maps.get(0)).getType();
            QueryResult res = this.function.query(QueryParam.builder().dsName(this.datasourceConfig.getName()).type(type).mappings(mapping).sql(bsql.getSql()).params((String[])params.stream().map(it -> it.toString()).toArray(String[]::new)).build());
            return res.getList();
        }
        return 1;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public void setDatasourceConfig(DatasourceConfig datasourceConfig) {
        this.datasourceConfig = datasourceConfig;
    }
}

