/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.config;

import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.bo.Bean;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DOceanPlugin(order=0)
public class ConfigPlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(ConfigPlugin.class);

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        log.info("init config plugin");
        Config config = new Config();
        if (ioc.containsBean(Config.class.getName())) {
            config = (Config)ioc.getBean(Config.class);
        } else {
            ioc.putBean((Object)config);
        }
        config.forEach((k, v) -> {
            ioc.putBean("$" + String.valueOf(k), v, Bean.Type.config.ordinal());
            ioc.putBean("${" + String.valueOf(k) + "}", v, Bean.Type.config.ordinal());
        });
    }

    public Optional<String> ioc(Ioc ioc, Class type, Annotation[] annotation) {
        Optional optional = this.getAnno(annotation, Value.class);
        if (optional.isPresent()) {
            Value value = (Value)optional.get();
            if (!ioc.containsBean(value.value())) {
                ioc.putBean(value.value(), (Object)value.defaultValue());
            }
            return Optional.of(value.value());
        }
        return Optional.empty();
    }
}

