/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.Impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.Date;
import java.util.List;
import org.apache.ozhera.prometheus.agent.Impl.BaseDao;
import org.apache.ozhera.prometheus.agent.entity.ScrapeConfigEntity;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.enums.ScrapeJobStatusEnum;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ScrapeConfigDao
extends BaseDao {
    private static final Logger log = LoggerFactory.getLogger(ScrapeConfigDao.class);
    @NacosValue(value="${prometheus-agent.client.type:local}")
    private String prometheusAgentClientType;

    public Long CreateScrapeConfig(ScrapeConfigEntity entity) {
        Long id = ((ScrapeConfigEntity)this.dao.insert((Object)entity)).getId();
        return id;
    }

    public int DeleteScrapeConfig(String id) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("id", (Object)id).andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        ScrapeConfigEntity dbRes = (ScrapeConfigEntity)this.dao.fetch(ScrapeConfigEntity.class, (Condition)cnd);
        if (dbRes == null) {
            return -1;
        }
        dbRes.setDeletedBy("xxx");
        dbRes.setDeletedTime(new Date());
        dbRes.setStatus(ScrapeJobStatusEnum.DELETE.getDesc());
        int updateRes = this.dao.update((Object)dbRes);
        return updateRes;
    }

    public ScrapeConfigEntity GetScrapeConfig(String id) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("id", (Object)id).andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        ScrapeConfigEntity dbRes = (ScrapeConfigEntity)this.dao.fetch(ScrapeConfigEntity.class, (Condition)cnd);
        return dbRes;
    }

    public ScrapeConfigEntity GetScrapeConfigByName(String name) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("job_name", (Object)name).andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        ScrapeConfigEntity dbRes = (ScrapeConfigEntity)this.dao.fetch(ScrapeConfigEntity.class, (Condition)cnd);
        return dbRes;
    }

    public List<ScrapeConfigEntity> GetScrapeConfigList(Integer pageSize, Integer pageNo) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        List datas = this.dao.query(ScrapeConfigEntity.class, (Condition)cnd.desc("id"), this.buildPager(pageNo, pageSize));
        return datas;
    }

    public List<ScrapeConfigEntity> GetAllScrapeConfigList(String status) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        List datas = this.dao.query(ScrapeConfigEntity.class, (Condition)cnd.desc("id"));
        return datas;
    }

    public List<ScrapeConfigEntity> GetAllCloudScrapeConfigList(String status) {
        SqlExpressionGroup sqlExpr = new SqlExpressionGroup();
        sqlExpr = status.equals(ScrapeJobStatusEnum.ALL.getDesc()) ? Cnd.cri().where().andNotIsNull("job_name").andNotEquals("status", (Object)ScrapeJobStatusEnum.DONE.getDesc()) : Cnd.cri().where().andNotIsNull("job_name").andEquals("status", (Object)status);
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        List datas = this.dao.query(ScrapeConfigEntity.class, (Condition)cnd.desc("id"));
        return datas;
    }

    public Integer CountScrapeConfig() {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        int count = this.dao.count(ScrapeConfigEntity.class, (Condition)cnd);
        return count;
    }

    public String UpdateScrapeConfigList(String id, ScrapeConfigEntity entity) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("id", (Object)id).andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        try {
            ScrapeConfigEntity data = (ScrapeConfigEntity)this.dao.fetch(ScrapeConfigEntity.class, (Condition)cnd);
            if (data == null) {
                return ErrorCode.invalidParamError.getMessage();
            }
            int update = this.dao.updateIgnoreNull((Object)entity);
            return String.valueOf(update);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public int UpdateScrapeConfigListByJobName(String jobName, String status) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("job_name", (Object)jobName).andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        try {
            ScrapeConfigEntity data = (ScrapeConfigEntity)this.dao.fetch(ScrapeConfigEntity.class, (Condition)cnd);
            data.setStatus(status);
            int update = this.dao.updateIgnoreNull((Object)data);
            return update;
        }
        catch (Exception e) {
            log.error("ScrapeConfigDao UpdateScrapeConfigListByJobName error:{}", (Object)e.getMessage());
            return 0;
        }
    }

    public int UpdateScrapeConfigDeleteToDone(String jobName) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("job_name", (Object)jobName).andEquals("status", (Object)ScrapeJobStatusEnum.DELETE.getDesc());
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        try {
            ScrapeConfigEntity data = (ScrapeConfigEntity)this.dao.fetch(ScrapeConfigEntity.class, (Condition)cnd);
            data.setStatus(ScrapeJobStatusEnum.DONE.getDesc());
            int update = this.dao.updateIgnoreNull((Object)data);
            return update;
        }
        catch (Exception e) {
            log.error("ScrapeConfigDao UpdateScrapeConfigListByJobName error:{}", (Object)e.getMessage());
            return 0;
        }
    }
}

