/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.client.common;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintingEventListener
extends EventListener {
    private static final Logger log = LoggerFactory.getLogger(PrintingEventListener.class);
    long callStartNanos;
    long callId;
    private Stopwatch sw;
    public static final EventListener.Factory FACTORY = new EventListener.Factory(){
        final AtomicLong nextCallId = new AtomicLong(1L);

        public EventListener create(Call call) {
            long callId = this.nextCallId.getAndIncrement();
            log.debug("{} {}", (Object)callId, (Object)call.request().url());
            return new PrintingEventListener(callId, System.nanoTime());
        }
    };

    public PrintingEventListener(long callId, long callStartNanos) {
        this.callId = callId;
        this.callStartNanos = callStartNanos;
        this.sw = Stopwatch.createStarted();
    }

    private void printEvent(String name) {
        long nowNanos = System.nanoTime();
        if (name.equals("callStart")) {
            this.callStartNanos = nowNanos;
        }
        log.debug("{} {} {}", new Object[]{this.callId, this.sw.elapsed(TimeUnit.MILLISECONDS), name});
    }

    public void callStart(Call call) {
        this.printEvent("callStart");
    }

    public void proxySelectStart(Call call, HttpUrl url) {
        this.printEvent("proxySelectStart");
    }

    public void proxySelectEnd(Call call, HttpUrl url, List<Proxy> proxies) {
        this.printEvent("proxySelectEnd");
    }

    public void dnsStart(Call call, String domainName) {
        this.printEvent("dnsStart");
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        this.printEvent("dnsEnd");
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        this.printEvent("connectStart----------------->");
    }

    public void secureConnectStart(Call call) {
        this.printEvent("secureConnectStart");
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        this.printEvent("secureConnectEnd");
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        this.printEvent("connectEnd");
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        this.printEvent("connectFailed");
    }

    public void connectionAcquired(Call call, Connection connection) {
        this.printEvent("connectionAcquired");
    }

    public void connectionReleased(Call call, Connection connection) {
        this.printEvent("connectionReleased");
    }

    public void requestHeadersStart(Call call) {
        this.printEvent("requestHeadersStart");
    }

    public void requestHeadersEnd(Call call, Request request) {
        this.printEvent("requestHeadersEnd");
    }

    public void requestBodyStart(Call call) {
        this.printEvent("requestBodyStart");
    }

    public void requestBodyEnd(Call call, long byteCount) {
        this.printEvent("requestBodyEnd");
    }

    public void requestFailed(Call call, IOException ioe) {
        this.printEvent("requestFailed");
    }

    public void responseHeadersStart(Call call) {
        this.printEvent("responseHeadersStart");
    }

    public void responseHeadersEnd(Call call, Response response) {
        this.printEvent("responseHeadersEnd");
    }

    public void responseBodyStart(Call call) {
        this.printEvent("responseBodyStart");
    }

    public void responseBodyEnd(Call call, long byteCount) {
        this.printEvent("responseBodyEnd");
    }

    public void responseFailed(Call call, IOException ioe) {
        this.printEvent("responseFailed");
    }

    public void callEnd(Call call) {
        this.printEvent("callEnd");
    }

    public void callFailed(Call call, IOException ioe) {
        this.printEvent("callFailed");
    }

    public void canceled(Call call) {
        this.printEvent("canceled");
    }
}

