/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;

public class CreateOrReplaceHelper<T extends HasMetadata> {
    public static final int CREATE_OR_REPLACE_RETRIES = 3;
    private final UnaryOperator<T> createTask;
    private final UnaryOperator<T> replaceTask;
    private final UnaryOperator<T> waitTask;
    private final UnaryOperator<T> reloadTask;

    public CreateOrReplaceHelper(UnaryOperator<T> createTask, UnaryOperator<T> replaceTask, UnaryOperator<T> waitTask, UnaryOperator<T> reloadTask) {
        this.createTask = createTask;
        this.replaceTask = replaceTask;
        this.waitTask = waitTask;
        this.reloadTask = reloadTask;
    }

    public T createOrReplace(T item) {
        String resourceVersion = KubernetesResourceUtil.getResourceVersion(item);
        CompletableFuture<T> future = new CompletableFuture<T>();
        int nTries = 0;
        while (!future.isDone() && nTries < 3) {
            try {
                KubernetesResourceUtil.setResourceVersion(item, null);
                return (T)((HasMetadata)this.createTask.apply(item));
            }
            catch (KubernetesClientException exception) {
                if (this.shouldRetry(exception.getCode())) {
                    HasMetadata itemFromServer = (HasMetadata)this.reloadTask.apply(item);
                    if (itemFromServer == null) {
                        this.waitTask.apply(item);
                        ++nTries;
                        continue;
                    }
                } else if (exception.getCode() != 409) {
                    throw exception;
                }
                future.complete(this.replace(item, resourceVersion));
            }
        }
        return (T)((HasMetadata)future.join());
    }

    private T replace(T item, String resourceVersion) {
        KubernetesResourceUtil.setResourceVersion(item, resourceVersion);
        return (T)((HasMetadata)this.replaceTask.apply(item));
    }

    private boolean shouldRetry(int responseCode) {
        return responseCode > 499;
    }
}

