/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.prometheusClient;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.ozhera.prometheus.agent.client.Client;
import org.apache.ozhera.prometheus.agent.enums.ScrapeJobStatusEnum;
import org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs;
import org.apache.ozhera.prometheus.agent.param.scrapeConfig.ScrapeConfigDetail;
import org.apache.ozhera.prometheus.agent.service.prometheus.ScrapeJobService;
import org.apache.ozhera.prometheus.agent.util.CommitPoolUtil;
import org.apache.ozhera.prometheus.agent.util.FileUtil;
import org.apache.ozhera.prometheus.agent.util.Http;
import org.apache.ozhera.prometheus.agent.util.YamlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PrometheusVMClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(PrometheusVMClient.class);
    @Autowired
    ScrapeJobService scrapeJobService;
    @Value(value="${vm.scrape.job.path}")
    private String filePath;
    @NacosValue(value="${job.prometheus.enabled}", autoRefreshed=true)
    private String enabled;
    @NacosValue(value="${vm.agent.label}", autoRefreshed=true)
    private String vmAgentLabel;
    @NacosValue(value="${vm.agent.port}", autoRefreshed=true)
    private String vmAgentPort;
    public static final Gson gson = new Gson();
    private boolean firstInitSign = false;
    private List<Scrape_configs> localConfigs = new ArrayList<Scrape_configs>();

    @PostConstruct
    public void init() {
        log.info("PrometheusVMClient begin init!");
        if (this.enabled.equals("true")) {
            this.scrapeJobService.setPendingScrapeConfig();
            this.GetLocalConfigs();
            this.CompareAndReload();
        }
    }

    @Override
    public void GetLocalConfigs() {
        CommitPoolUtil.PROMETHEUS_LOCAL_CONFIG_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            log.info("PrometheusVMClient start GetLocalConfigs");
            try {
                List allScrapeConfigList = this.scrapeJobService.getAllScrapeConfigList(ScrapeJobStatusEnum.PENDING.getDesc());
                this.localConfigs.clear();
                allScrapeConfigList.forEach(item -> {
                    ScrapeConfigDetail detail = (ScrapeConfigDetail)gson.fromJson(item.getBody(), ScrapeConfigDetail.class);
                    Scrape_configs sc = new Scrape_configs();
                    sc.setRelabel_configs(detail.getRelabel_configs());
                    sc.setMetric_relabel_configs(detail.getMetric_relabel_configs());
                    sc.setStatic_configs(detail.getStatic_configs());
                    sc.setJob_name(detail.getJob_name());
                    sc.setParams(detail.getParams());
                    sc.setMetrics_path(detail.getMetrics_path());
                    sc.setHonor_labels(detail.isHonor_labels());
                    sc.setHttp_sd_configs(detail.getHttp_sd_configs());
                    sc.setHttp_sd_configs(detail.getHttp_sd_configs());
                    this.localConfigs.add(sc);
                });
                log.info("PrometheusVMClient GetLocalConfigs done ,and jobNum :{}", (Object)this.localConfigs.size());
                this.firstInitSign = true;
            }
            catch (Exception e) {
                log.error("PrometheusVMClient GetLocalConfigs error :{}", (Object)e.getMessage());
            }
            finally {
                log.info("PrometheusVMClient end GetLocalConfigs cost: {}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void CompareAndReload() {
        CommitPoolUtil.PROMETHEUS_COMPARE_RELOAD_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            try {
                if (this.localConfigs.isEmpty()) {
                    log.info("prometheus VM scrapeJob no need to reload");
                    return;
                }
                if (!this.firstInitSign) {
                    log.info("PrometheusVMClient CompareAndReload waiting..");
                    return;
                }
                log.info("PrometheusVMClient start CompareAndReload");
                if (!FileUtil.DeleteFile((String)this.filePath)) {
                    log.error("PrometheusVMClient CompareAndReload delete file error");
                }
                this.writeScrapeConfig2Yaml();
                this.reloadVMAgent();
            }
            catch (Exception e) {
                log.error("PrometheusVMClient CompareAndReload error :{}", (Object)e.getMessage());
            }
            finally {
                log.info("PrometheusVMClient end CompareAndReload cost: {}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private void writeScrapeConfig2Yaml() {
        HashSet jobNames = new HashSet();
        this.localConfigs.forEach(it -> {
            if (jobNames.contains(it.getJob_name())) {
                this.localConfigs.remove(it);
            } else {
                jobNames.add(it.getJob_name());
            }
        });
        String promYml = YamlUtil.toYaml(this.localConfigs);
        if (!this.isFileExists(this.filePath)) {
            log.info("PrometheusVMClient no files path: {} and begin create", (Object)this.filePath);
            FileUtil.GenerateFile((String)this.filePath);
        }
        FileUtil.WriteFile((String)this.filePath, (String)promYml);
    }

    private boolean isFileExists(String filePath) {
        return FileUtil.IsHaveFile((String)filePath);
    }

    private void reloadVMAgent() {
        Set<String> vmAgentPodIP = this.getVMAgentPodIP();
        if (vmAgentPodIP == null || vmAgentPodIP.isEmpty()) {
            return;
        }
        vmAgentPodIP.forEach(pod -> {
            String reloadUrl = String.format("http://%s:%s/-/reload", pod, this.vmAgentPort);
            log.info("PrometheusVMClient reload url: {}", (Object)reloadUrl);
            String getRes = Http.innerRequest((String)"", (String)reloadUrl, (String)"GET");
            log.info("PrometheusVMClient reload result: {}", (Object)getRes);
        });
    }

    private Set<String> getVMAgentPodIP() {
        HashSet<String> hashSet;
        HashSet<String> podNameSet = new HashSet<String>();
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        try {
            String labelName = "app";
            String labelValue = this.vmAgentLabel;
            PodList podList = (PodList)((FilterWatchListDeletable)client.pods().withLabel(labelName, labelValue)).list();
            podList.getItems().forEach(pod -> podNameSet.add(pod.getStatus().getPodIP()));
            hashSet = podNameSet;
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("PrometheusVMClient getVMAgentPodName error: {}", (Throwable)e);
                return null;
            }
        }
        client.close();
        return hashSet;
    }
}

