/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.alertManagerClient;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.apache.ozhera.prometheus.agent.client.Client;
import org.apache.ozhera.prometheus.agent.param.alertManager.AlertManagerConfig;
import org.apache.ozhera.prometheus.agent.param.alertManager.Group;
import org.apache.ozhera.prometheus.agent.param.alertManager.Rule;
import org.apache.ozhera.prometheus.agent.service.prometheus.RuleAlertService;
import org.apache.ozhera.prometheus.agent.util.CommitPoolUtil;
import org.apache.ozhera.prometheus.agent.util.FileUtil;
import org.apache.ozhera.prometheus.agent.util.Http;
import org.apache.ozhera.prometheus.agent.util.YamlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class AlertManagerVMClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(AlertManagerVMClient.class);
    @Autowired
    RuleAlertService ruleAlertService;
    @Value(value="${vm.alert.rule.path}")
    private String filePath;
    @NacosValue(value="${job.alertManager.enabled}", autoRefreshed=true)
    private String enabled;
    @NacosValue(value="${vm.Alert.label}", autoRefreshed=true)
    private String vmAlertLabel;
    @NacosValue(value="${vm.Alert.Port}", autoRefreshed=true)
    private String vmAlertPort;
    private ConcurrentHashMap<String, CopyOnWriteArrayList<Rule>> localRuleList = new ConcurrentHashMap();
    private static final Gson gson = new Gson();
    private ReentrantLock lock = new ReentrantLock();
    private boolean firstInitSign = false;

    @PostConstruct
    public void init() {
        if (this.enabled.equals("true")) {
            this.GetLocalConfigs();
            this.CompareAndReload();
        } else {
            log.info("AlertManagerVMClient not init");
        }
    }

    @Override
    public void GetLocalConfigs() {
        CommitPoolUtil.ALERTMANAGER_LOCAL_CONFIG_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            log.info("AlertManagerVMClient start GetLocalConfigs");
            try {
                List allRuleAlertList = this.ruleAlertService.GetAllRuleAlertList();
                this.localRuleList.clear();
                log.info("AlertManagerVMClient GetLocalConfigs allRuleAlertList: {}", (Object)allRuleAlertList);
                allRuleAlertList.forEach(item -> {
                    String tmpGroup = item.getAlert_group();
                    Rule rule = new Rule();
                    rule.setAlert(item.getName());
                    rule.setAnnotations(this.transAnnotation2Map(item.getAnnotation()));
                    rule.setLabels(this.transLabel2Map(item.getLabels()));
                    rule.setExpr(item.getExpr());
                    rule.setFor(item.getAlertFor());
                    if (this.localRuleList.containsKey(tmpGroup)) {
                        this.localRuleList.get(tmpGroup).add(rule);
                    } else {
                        CopyOnWriteArrayList rules = new CopyOnWriteArrayList();
                        this.localRuleList.put(tmpGroup, rules);
                        this.localRuleList.get(tmpGroup).add(rule);
                    }
                });
                log.info("AlertManagerVMClient GetLocalConfigs done!");
                this.firstInitSign = true;
            }
            catch (Exception e) {
                log.error("AlertManagerVMClient GetLocalConfigs error:{}", (Object)e.getMessage());
            }
            finally {
                log.info("AlertManagerVMClient GetLocalConfigs batch time:{}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void CompareAndReload() {
        CommitPoolUtil.ALERTMANAGER_COMPARE_RELOAD_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            try {
                if (this.localRuleList.isEmpty()) {
                    log.info("localRuleList is empty and no need reload");
                    return;
                }
                if (!this.firstInitSign) {
                    log.info("AlertManagerVMClient CompareAndReload waiting..");
                    return;
                }
                if (!FileUtil.DeleteFile((String)this.filePath)) {
                    log.error("AlertManagerVMClient CompareAndReload delete file error");
                }
                log.info("AlertManagerVMClient start CompareAndReload");
                AlertManagerConfig ruleAlertConfig = new AlertManagerConfig();
                ArrayList<Group> group = new ArrayList<Group>();
                for (Map.Entry<String, CopyOnWriteArrayList<Rule>> entry : this.localRuleList.entrySet()) {
                    Group tmpGroup = new Group();
                    tmpGroup.setName(entry.getKey());
                    tmpGroup.setRules((List)entry.getValue());
                    group.add(tmpGroup);
                }
                ruleAlertConfig.setGroups(group);
                this.writeAlertRule2Yaml(ruleAlertConfig);
                this.reloadVMAlert();
            }
            catch (Exception e) {
                log.error("AlertManagerVMClient CompareAndReload error: {}", (Throwable)e);
            }
            finally {
                log.info("AlertManagerVMClient CompareAndReload batch time:{}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private Map<String, String> transLabel2Map(String labels) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        try {
            Arrays.stream(labels.split(",")).forEach(item -> {
                String[] split = item.split("=", 2);
                if (split.length != 2) {
                    return;
                }
                labelMap.put(split[0], split[1]);
            });
            return labelMap;
        }
        catch (Exception e) {
            log.error("AlertManagerVMClient transLabel2Map error: {}", (Throwable)e);
            return labelMap;
        }
    }

    private Map<String, String> transAnnotation2Map(String annotations) {
        return (Map)gson.fromJson(annotations, Map.class);
    }

    private void writeAlertRule2Yaml(AlertManagerConfig ruleAlertConfig) {
        String promYml = YamlUtil.toYaml((Object)ruleAlertConfig);
        if (!this.isFileExists(this.filePath)) {
            log.info("AlertManagerVMClient no files path: {} and begin create", (Object)this.filePath);
            FileUtil.GenerateFile((String)this.filePath);
        }
        FileUtil.WriteFile((String)this.filePath, (String)promYml);
    }

    private boolean isFileExists(String filePath) {
        return FileUtil.IsHaveFile((String)filePath);
    }

    private void reloadVMAlert() {
        Set<String> vmAlertPodIp = this.getVMAlertPodIp();
        if (vmAlertPodIp == null || vmAlertPodIp.isEmpty()) {
            return;
        }
        vmAlertPodIp.forEach(pod -> {
            String reloadUrl = String.format("http://%s:%s/-/reload", pod, this.vmAlertPort);
            log.info("AlertManagerVMClient reload url: {}", (Object)reloadUrl);
            String getRes = Http.innerRequest((String)"", (String)reloadUrl, (String)"GET");
            log.info("AlertManagerVMClient reload result: {}", (Object)getRes);
        });
    }

    private Set<String> getVMAlertPodIp() {
        HashSet<String> hashSet;
        HashSet<String> podNameSet = new HashSet<String>();
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        try {
            String labelName = "app";
            String labelValue = this.vmAlertLabel;
            PodList podList = (PodList)((FilterWatchListDeletable)client.pods().withLabel(labelName, labelValue)).list();
            podList.getItems().forEach(pod -> podNameSet.add(pod.getStatus().getPodIP()));
            hashSet = podNameSet;
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("AlertManagerClient getVMAgentPodName error: {}", (Throwable)e);
                return null;
            }
        }
        client.close();
        return hashSet;
    }
}

