/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.logging.slf4j;

import org.mybatis.generator.logging.Log;
import org.mybatis.generator.logging.LogFactory;
import org.mybatis.generator.logging.slf4j.Slf4jImpl;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

class Slf4jLocationAwareLoggerImpl
implements Log {
    private static Marker MARKER = MarkerFactory.getMarker((String)LogFactory.MARKER);
    private static final String FQCN = Slf4jImpl.class.getName();
    private LocationAwareLogger logger;

    Slf4jLocationAwareLoggerImpl(LocationAwareLogger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        this.logger.log(MARKER, FQCN, 40, s, null, e);
    }

    @Override
    public void error(String s) {
        this.logger.log(MARKER, FQCN, 40, s, null, null);
    }

    @Override
    public void debug(String s) {
        this.logger.log(MARKER, FQCN, 10, s, null, null);
    }

    @Override
    public void warn(String s) {
        this.logger.log(MARKER, FQCN, 30, s, null, null);
    }
}

