/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.runner;

import java.util.Date;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.runner.NutLock;

public abstract class NutRunner
implements Runnable {
    protected Log log;
    protected Thread myThread;
    protected String rnm;
    protected NutLock lock;
    protected int count;
    protected long interval;
    protected int sleepAfterError;
    protected Date upAt;
    protected Date downAt;
    protected boolean debug = true;

    public NutRunner(String rname) {
        this.rnm = rname;
        this.count = 0;
        this.sleepAfterError = 30;
        this.lock = new NutLock();
    }

    public NutRunner setSleepAfterError(int sec) {
        this.sleepAfterError = sec;
        return this;
    }

    @Override
    public void run() {
        if (this.log == null) {
            this.log = Logs.get().setTag(this.rnm);
        }
        this.myThread = Thread.currentThread();
        this.beforeStart(this);
        this.doIt();
        this.afterStop(this);
    }

    public abstract long exec() throws Exception;

    @Deprecated
    public void reg(NutRunner me) {
    }

    @Deprecated
    public void unreg(NutRunner me) {
    }

    public void beforeStart(NutRunner me) {
        this.reg(me);
    }

    public void afterStop(NutRunner me) {
        this.unreg(me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIt() {
        while (!this.lock.isStop()) {
            NutLock nutLock = this.lock;
            synchronized (nutLock) {
                try {
                    this.upAt = Times.now();
                    this.downAt = null;
                    if (this.debug && this.log.isDebugEnabled()) {
                        this.log.debugf("%s [%d] : up", this.rnm, ++this.count);
                    }
                    this.interval = this.exec();
                    if (this.interval < 1L) {
                        this.interval = 1L;
                    }
                    this.downAt = Times.now();
                    if (this.debug && this.log.isDebugEnabled()) {
                        this.log.debugf("%s [%d] : wait %ds(%dms)", this.rnm, this.count, this.interval / 1000L, this.interval);
                    }
                    this.lock.wait(this.interval);
                }
                catch (InterruptedException e) {
                    this.log.warn(String.format("%s has been interrupted", this.rnm), e);
                    break;
                }
                catch (Throwable e) {
                    this.log.warn(String.format("%s has some error", this.rnm), e);
                    try {
                        this.lock.wait(this.sleepAfterError * 1000);
                    }
                    catch (Throwable e1) {
                        this.log.warn(String.format("%s has some error again", this.rnm), e);
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        return String.format("[%s:%d] %s/%s - %d", this.rnm, this.count, this.upAt == null ? "NONE" : Times.sDT(this.upAt), this.downAt == null ? "NONE" : Times.sDT(this.downAt), this.interval);
    }

    public boolean isWaiting() {
        return null != this.downAt;
    }

    public boolean isRunning() {
        return null == this.downAt;
    }

    public long getInterval() {
        return this.interval;
    }

    public Date getUpAt() {
        return this.upAt;
    }

    public Date getDownAt() {
        return this.downAt;
    }

    public String getName() {
        return this.rnm;
    }

    public int getCount() {
        return this.count;
    }

    public NutLock getLock() {
        return this.lock;
    }

    public boolean isAlive() {
        if (this.myThread != null) {
            return this.myThread.isAlive();
        }
        return false;
    }

    public void stop(Throwable err) {
        this.myThread.stop(err);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

