/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.born;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.lang.MatchType;
import org.nutz.lang.Mirror;
import org.nutz.lang.born.BornContext;
import org.nutz.lang.born.ConstructorBorning;
import org.nutz.lang.born.ConstructorCastingBorning;
import org.nutz.lang.born.DynaMethodBorning;
import org.nutz.lang.born.DynamicConstructorBorning;
import org.nutz.lang.born.EmptyArgsConstructorBorning;
import org.nutz.lang.born.EmptyArgsMethodBorning;
import org.nutz.lang.born.MethodBorning;
import org.nutz.lang.born.MethodCastingBorning;

public abstract class Borns {
    public static <T> BornContext<T> evalByArgTypes(Class<T> type, Class<?> ... argTypes) {
        BornContext<T> re = argTypes.length == 0 ? Borns.evalWithoutArgs(type) : Borns.evalWithArgTypes(true, type, argTypes, null);
        return re;
    }

    public static <T> BornContext<T> eval(Class<T> type, Object ... args) {
        BornContext<T> re = args.length == 0 ? Borns.evalWithoutArgs(type) : Borns.evalWithArgs(type, args);
        return re;
    }

    private static <T> BornContext<T> evalWithArgs(Class<T> type, Object[] args) {
        Object dynaArg = Mirror.evalArgToSameTypeRealArray(args);
        Class<?>[] argTypes = Mirror.evalToTypes(args);
        BornContext<T> re = Borns.evalWithArgTypes(false, type, argTypes, dynaArg);
        if (null == re) {
            return null;
        }
        if (MatchType.LACK == re.getMatchType()) {
            re.setArgs(Lang.arrayLast(args, re.getLackArg()));
        } else {
            re.setArgs(args);
        }
        switch (re.getMatchType()) {
            case LACK: {
                re.setArgs(Lang.arrayLast(args, re.getLackArg()));
                break;
            }
            case NEED_CAST: {
                re.setArgs(Lang.array2ObjectArray(args, re.getCastType()));
                break;
            }
            default: {
                re.setArgs(args);
            }
        }
        return re;
    }

    private static <T> BornContext<T> evalWithArgTypes(boolean accurate, Class<T> type, Class<?>[] argTypes, Object dynaArg) {
        Class<?>[] pts;
        BornContext<Object> re = new BornContext<Object>();
        Mirror<Class<T>> mirror = Mirror.me(type);
        for (Constructor<?> cc : type.getConstructors()) {
            Class<?>[] classArray = cc.getParameterTypes();
            MatchType mt = Mirror.matchParamTypes(classArray, argTypes);
            re.setMatchType(mt);
            if (MatchType.YES == mt) {
                return re.setBorning(new ConstructorBorning(cc));
            }
            if (MatchType.LACK == mt) {
                re.setLackArg(Mirror.blankArrayArg(classArray));
                return re.setBorning(new ConstructorBorning(cc));
            }
            if (null == dynaArg || classArray.length != 1 || classArray[0] != dynaArg.getClass()) continue;
            return re.setBorning(new DynamicConstructorBorning(cc));
        }
        Method[] sms = mirror.getStaticMethods();
        for (Method method : sms) {
            pts = method.getParameterTypes();
            MatchType mt = Mirror.matchParamTypes(pts, argTypes);
            re.setMatchType(mt);
            if (MatchType.YES == mt) {
                return re.setBorning(new MethodBorning(method));
            }
            if (MatchType.LACK == mt) {
                re.setLackArg(Mirror.blankArrayArg(pts));
                return re.setBorning(new MethodBorning(method));
            }
            if (null == dynaArg || pts.length != 1 || pts[0] != dynaArg.getClass()) continue;
            return re.setBorning(new DynaMethodBorning(method));
        }
        if (!accurate) {
            try {
                for (Executable executable : type.getConstructors()) {
                    pts = ((Constructor)executable).getParameterTypes();
                    if (!Borns.canBeCasted(argTypes, pts)) continue;
                    re.setMatchType(MatchType.NEED_CAST);
                    re.setCastType(pts);
                    return re.setBorning(new ConstructorCastingBorning(executable));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                for (Executable executable : sms) {
                    pts = ((Method)executable).getParameterTypes();
                    if (!Borns.canBeCasted(argTypes, pts)) continue;
                    re.setMatchType(MatchType.NEED_CAST);
                    re.setCastType(pts);
                    return re.setBorning(new MethodCastingBorning((Method)executable));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean canBeCasted(Class<?>[] argTypes, Class<?>[] pts) {
        if (pts.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < pts.length; ++i) {
            if (Castors.me().canCast(argTypes[i], pts[i])) continue;
            return false;
        }
        return true;
    }

    private static <T> BornContext<T> evalWithoutArgs(Class<T> type) {
        Class<?>[] pts;
        BornContext re = new BornContext();
        Mirror<Class<T>> mirror = Mirror.me(type);
        boolean isAbstract = Modifier.isAbstract(type.getModifiers());
        try {
            if (!isAbstract) {
                re.setBorning(new EmptyArgsConstructorBorning<T>(type.getConstructor(new Class[0])));
                return re.setArgs(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Method[] stMethods = mirror.getStaticMethods();
        for (Method method : stMethods) {
            if (!method.getReturnType().equals(type) || method.getParameterTypes().length != 0) continue;
            return re.setBorning(new EmptyArgsMethodBorning(method)).setArgs(new Object[0]);
        }
        if (!isAbstract) {
            for (Executable executable : type.getConstructors()) {
                pts = ((Constructor)executable).getParameterTypes();
                if (pts.length != 1 || !pts[0].isArray()) continue;
                Object[] args = new Object[]{Mirror.blankArrayArg(pts)};
                return re.setBorning(new ConstructorBorning(executable)).setArgs(args);
            }
        }
        for (Executable executable : stMethods) {
            pts = ((Method)executable).getParameterTypes();
            if (((Method)executable).getReturnType() != type || ((Method)executable).getParameterTypes().length != 1 || !pts[0].isArray()) continue;
            Object[] args = new Object[]{Mirror.blankArrayArg(pts)};
            return re.setBorning(new MethodBorning((Method)executable)).setArgs(args);
        }
        return null;
    }
}

