/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.json.JsonEntityFieldMaker;
import org.nutz.json.JsonException;
import org.nutz.json.JsonFormat;
import org.nutz.json.JsonRender;
import org.nutz.json.JsonTypeHandler;
import org.nutz.json.entity.JsonEntity;
import org.nutz.json.handler.JsonArrayHandler;
import org.nutz.json.handler.JsonBooleanHandler;
import org.nutz.json.handler.JsonClassHandler;
import org.nutz.json.handler.JsonDateTimeHandler;
import org.nutz.json.handler.JsonEnumHandler;
import org.nutz.json.handler.JsonIterableHandler;
import org.nutz.json.handler.JsonJsonRenderHandler;
import org.nutz.json.handler.JsonLocalDateLikeHandler;
import org.nutz.json.handler.JsonMapHandler;
import org.nutz.json.handler.JsonMirrorHandler;
import org.nutz.json.handler.JsonNumberHandler;
import org.nutz.json.handler.JsonPojoHandler;
import org.nutz.json.handler.JsonStringLikeHandler;
import org.nutz.json.impl.JsonCompileImplV2;
import org.nutz.json.impl.JsonEntityFieldMakerImpl;
import org.nutz.json.impl.JsonRenderImpl;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.util.NutType;
import org.nutz.lang.util.PType;
import org.nutz.mapl.Mapl;

public class Json {
    private static Class<? extends JsonRender> jsonRenderCls;
    private static final ConcurrentHashMap<String, JsonEntity> entities;
    protected static JsonFormat deft;
    private static JsonEntityFieldMaker deftMaker;
    protected static List<JsonTypeHandler> handlers;

    public static Object fromJson(Reader reader) throws JsonException {
        return new JsonCompileImplV2().parse(reader);
    }

    public static <T> T fromJson(Class<T> type, Reader reader) throws JsonException {
        return (T)Json.parse(type, reader);
    }

    public static Object fromJson(Type type, Reader reader) throws JsonException {
        return Json.parse(type, reader);
    }

    private static Object parse(Type type, Reader reader) {
        Object obj = Json.fromJson(reader);
        if (type != null) {
            return Mapl.maplistToObj(obj, type);
        }
        return obj;
    }

    public static Object fromJson(Type type, CharSequence cs) throws JsonException {
        return Json.fromJson(type, Lang.inr(cs));
    }

    public static <T> T fromJson(PType<T> type, Reader reader) throws JsonException {
        return (T)Json.fromJson(type, reader);
    }

    public static <T> T fromJson(PType<T> type, CharSequence cs) throws JsonException {
        return (T)Json.fromJson(type, cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromJsonFile(Class<T> type, File f) {
        BufferedReader br = null;
        try {
            br = Streams.buffr(Streams.fileInr(f));
            T t = Json.fromJson(type, (Reader)br);
            return t;
        }
        finally {
            Streams.safeClose(br);
        }
    }

    public static Object fromJson(CharSequence cs) throws JsonException {
        return Json.fromJson(Lang.inr(cs));
    }

    public static <T> T fromJson(Class<T> type, CharSequence cs) throws JsonException {
        return Json.fromJson(type, Lang.inr(cs));
    }

    public static Class<? extends JsonRender> getJsonRenderCls() {
        return jsonRenderCls;
    }

    public static void setJsonRenderCls(Class<? extends JsonRender> cls) {
        jsonRenderCls = cls;
    }

    public static String toJson(Object obj) {
        return Json.toJson(obj, null);
    }

    public static String toJson(Object obj, JsonFormat format) {
        StringBuilder sb = new StringBuilder();
        Json.toJson(Lang.opw(sb), obj, format);
        return sb.toString();
    }

    public static void toJson(Writer writer, Object obj) {
        Json.toJson(writer, obj, null);
    }

    public static void toJson(Writer writer, Object obj, JsonFormat format) {
        try {
            Class<? extends JsonRender> jrCls;
            if (format == null) {
                format = deft;
            }
            JsonRender jr = (jrCls = Json.getJsonRenderCls()) == null ? new JsonRenderImpl() : (JsonRender)((Object)Mirror.me(jrCls).born(new Object[0]));
            jr.setWriter(writer);
            jr.setFormat(format);
            jr.render(obj);
            writer.flush();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e, JsonException.class);
        }
    }

    public static void toJsonFile(File f, Object obj) {
        Json.toJsonFile(f, obj, null);
    }

    public static void toJsonFile(File f, Object obj, JsonFormat format) {
        Writer writer = null;
        try {
            Files.createFileIfNoExists(f);
            writer = Streams.fileOutw(f);
            Json.toJson(writer, obj, format);
            writer.append('\n');
        }
        catch (IOException e) {
            try {
                throw Lang.wrapThrow(e);
            }
            catch (Throwable throwable) {
                Streams.safeClose(writer);
                throw throwable;
            }
        }
        Streams.safeClose(writer);
    }

    public static void clearEntityCache() {
        entities.clear();
    }

    public static JsonEntity getEntity(Mirror<?> mirror) {
        JsonEntity je = entities.get(mirror.getTypeId());
        if (null == je) {
            je = new JsonEntity(mirror);
            entities.put(mirror.getTypeId(), je);
        }
        return je;
    }

    public static <T> List<T> fromJsonAsList(Class<T> eleType, CharSequence cs) {
        return (List)Json.fromJson(NutType.list(eleType), cs);
    }

    public static <T> List<T> fromJsonAsList(Class<T> eleType, Reader reader) {
        return (List)Json.fromJson(NutType.list(eleType), reader);
    }

    public static <T> T[] fromJsonAsArray(Class<T> eleType, CharSequence cs) {
        return (Object[])Json.fromJson(NutType.array(eleType), cs);
    }

    public static <T> T[] fromJsonAsArray(Class<T> eleType, Reader reader) {
        return (Object[])Json.fromJson(NutType.array(eleType), reader);
    }

    public static <T> Map<String, T> fromJsonAsMap(Class<T> eleType, CharSequence cs) {
        return (Map)Json.fromJson(NutType.mapStr(eleType), cs);
    }

    public static <T> Map<String, T> fromJsonAsMap(Class<T> eleType, Reader reader) {
        return (Map)Json.fromJson(NutType.mapStr(eleType), reader);
    }

    public static void setDefaultJsonformat(JsonFormat defaultJf) {
        if (defaultJf == null) {
            defaultJf = JsonFormat.nice();
        }
        deft = defaultJf;
    }

    public static void setDefaultFieldMaker(JsonEntityFieldMaker fieldMaker) {
        if (fieldMaker != null) {
            deftMaker = fieldMaker;
        }
    }

    public static JsonEntityFieldMaker getDefaultFieldMaker() {
        return deftMaker;
    }

    public static void addTypeHandler(JsonTypeHandler handler) {
        if (!handlers.contains(handler)) {
            handlers.add(0, handler);
        }
    }

    public static List<JsonTypeHandler> getTypeHandlers() {
        return Collections.unmodifiableList(handlers);
    }

    static {
        entities = new ConcurrentHashMap();
        deft = JsonFormat.nice();
        deftMaker = new JsonEntityFieldMakerImpl();
        handlers = new ArrayList<JsonTypeHandler>();
        handlers.add(new JsonJsonRenderHandler());
        handlers.add(new JsonClassHandler());
        handlers.add(new JsonMirrorHandler());
        handlers.add(new JsonEnumHandler());
        handlers.add(new JsonNumberHandler());
        handlers.add(new JsonBooleanHandler());
        handlers.add(new JsonStringLikeHandler());
        handlers.add(new JsonDateTimeHandler());
        try {
            Class.forName("java.time.temporal.TemporalAccessor");
            handlers.add(new JsonLocalDateLikeHandler());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        handlers.add(new JsonMapHandler());
        handlers.add(new JsonIterableHandler());
        handlers.add(new JsonArrayHandler());
        handlers.add(new JsonPojoHandler());
    }
}

