/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.meta;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.nutz.ioc.Iocs;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.NutMap;

public class IocValue {
    public static final String TYPE_NORMAL = "normal";
    public static final String TYPE_INNER = "inner";
    public static final String TYPE_REFER = "refer";
    public static final String TYPE_REFER_TYPE = "refer_type";
    public static final String TYPE_ENV = "env";
    public static final String TYPE_SYS = "sys";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_JAVA = "java";
    public static final String TYPE_JNDI = "jndi";
    public static final String TYPE_EL = "el";
    public static final String TYPE_APP = "app";
    public static Set<String> types = new HashSet<String>();
    private String type;
    private Object value;

    public IocValue() {
    }

    public IocValue(String key) {
        if (key.contains(":")) {
            IocValue tmp = Iocs.convert(key, false);
            this.type = tmp.type;
            this.value = tmp.value;
        } else {
            this.type = TYPE_NORMAL;
            this.value = key;
        }
    }

    public IocValue(String type, Object val) {
        this.type = type;
        this.value = val;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return String.format("{%s:%s}", this.type, Json.toJson(this.value));
    }

    public String toJson(JsonFormat jf) {
        if (this.type == null || TYPE_NORMAL.equals(this.type)) {
            return Json.toJson(this.value, jf);
        }
        if (TYPE_REFER_TYPE.equals(this.type) && this.value instanceof Field) {
            Field field = (Field)this.value;
            String val = field.getName() + "#" + field.getType().getName();
            return Json.toJson(new NutMap().addv(this.type, val), jf);
        }
        return Json.toJson(new NutMap().addv(this.type, this.value), jf);
    }

    static {
        Mirror<Class<IocValue>> mirror = Mirror.me(IocValue.class);
        for (Field field : IocValue.class.getFields()) {
            if (!field.getName().startsWith("TYPE_")) continue;
            types.add(mirror.getValue(null, field).toString());
        }
    }
}

