/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.nutz.dao.entity.MappingField;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Regex;

public class FieldMatcher
implements Serializable {
    private Pattern actived;
    private Pattern locked;
    private Boolean ignoreNull = true;
    private Boolean ignoreBlankStr;
    private Boolean ignoreZero;
    private Boolean ignoreDate;
    private Boolean ignoreId = true;
    private Boolean ignoreName;
    private Boolean ignorePk;
    private Boolean ignoreFalse;

    public static FieldMatcher make(String actived, String locked, boolean ignoreNull) {
        FieldMatcher fm = new FieldMatcher();
        fm.ignoreNull = ignoreNull;
        if (!Strings.isBlank(actived)) {
            fm.actived = Regex.getPattern(actived);
        }
        if (!Strings.isBlank(locked)) {
            fm.locked = Regex.getPattern(locked);
        }
        return fm;
    }

    public static FieldMatcher create(boolean ignoreId) {
        FieldMatcher fm = new FieldMatcher();
        fm.ignoreId = ignoreId;
        return fm;
    }

    public static FieldMatcher make(String actived, String locked, boolean ignoreNull, boolean ignoreZero, boolean ignoreDate, boolean ignoreId, boolean ignoreName, boolean ignorePk) {
        FieldMatcher fm = FieldMatcher.make(actived, locked, ignoreNull);
        fm.ignoreZero = ignoreZero;
        fm.ignoreDate = ignoreDate;
        fm.ignoreId = ignoreId;
        fm.ignoreName = ignoreName;
        fm.ignorePk = ignorePk;
        return fm;
    }

    public static FieldMatcher make(String actived, String locked, boolean ignoreNull, boolean ignoreZero, boolean ignoreDate, boolean ignoreId, boolean ignoreName, boolean ignorePk, boolean ignoreBlankStr) {
        FieldMatcher fm = FieldMatcher.make(actived, locked, ignoreNull);
        fm.ignoreZero = ignoreZero;
        fm.ignoreDate = ignoreDate;
        fm.ignoreId = ignoreId;
        fm.ignoreName = ignoreName;
        fm.ignorePk = ignorePk;
        fm.ignoreBlankStr = ignoreBlankStr;
        return fm;
    }

    public boolean match(String str) {
        if (null != this.locked && this.locked.matcher(str).find()) {
            return false;
        }
        return null == this.actived || this.actived.matcher(str).find();
    }

    public boolean match(MappingField mf, Object obj) {
        String fieldName = mf.getName();
        if (null != this.locked && this.locked.matcher(fieldName).find()) {
            return false;
        }
        if (null != this.actived && !this.actived.matcher(fieldName).find()) {
            return false;
        }
        if (this.ignoreId != null && this.ignoreId.booleanValue() && mf.isId()) {
            return false;
        }
        if (this.ignoreName != null && this.ignoreName.booleanValue() && mf.isName()) {
            return false;
        }
        if (this.ignorePk != null && this.ignorePk.booleanValue() && mf.isCompositePk()) {
            return false;
        }
        Object val = mf.getValue(obj);
        if (val == null) {
            if (this.ignoreNull != null && this.ignoreNull.booleanValue()) {
                return false;
            }
        } else {
            if (this.ignoreZero != null && this.ignoreZero.booleanValue() && val instanceof Number && ((Number)val).doubleValue() == 0.0) {
                return false;
            }
            if (this.ignoreDate != null && this.ignoreDate.booleanValue() && val instanceof Date) {
                return false;
            }
            if (this.ignoreBlankStr != null && this.ignoreBlankStr.booleanValue() && val instanceof CharSequence && Strings.isBlank((CharSequence)val)) {
                return false;
            }
            if (val instanceof Boolean && this.ignoreFalse != null && this.ignoreFalse.booleanValue() && !((Boolean)val).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public FieldMatcher setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    public Pattern getActived() {
        return this.actived;
    }

    public Pattern getLocked() {
        return this.locked;
    }

    public FieldMatcher setActived(String actived) {
        this.actived = actived != null ? Regex.getPattern(actived) : null;
        return this;
    }

    public FieldMatcher setLocked(String locked) {
        this.locked = locked != null ? Regex.getPattern(locked) : null;
        return this;
    }

    public boolean isIgnoreZero() {
        return this.ignoreZero;
    }

    public FieldMatcher setIgnoreZero(boolean ignoreZero) {
        this.ignoreZero = ignoreZero;
        return this;
    }

    public boolean isIgnoreDate() {
        return this.ignoreDate;
    }

    public FieldMatcher setIgnoreDate(boolean ignoreDate) {
        this.ignoreDate = ignoreDate;
        return this;
    }

    public boolean isIgnoreId() {
        return this.ignoreId;
    }

    public FieldMatcher setIgnoreId(boolean ignoreId) {
        this.ignoreId = ignoreId;
        return this;
    }

    public boolean isIgnoreName() {
        return this.ignoreName;
    }

    public FieldMatcher setIgnoreName(boolean ignoreName) {
        this.ignoreName = ignoreName;
        return this;
    }

    public boolean isIgnorePk() {
        return this.ignorePk;
    }

    public FieldMatcher setIgnorePk(boolean ignorePk) {
        this.ignorePk = ignorePk;
        return this;
    }

    public boolean isIgnoreBlankStr() {
        return this.ignoreBlankStr != null && this.ignoreBlankStr != false;
    }

    public FieldMatcher setIgnoreBlankStr(boolean ignoreBlankStr) {
        this.ignoreBlankStr = ignoreBlankStr;
        return this;
    }

    public void setIgnoreFalse(Boolean ignoreFalse) {
        this.ignoreFalse = ignoreFalse;
    }

    public static FieldMatcher simple(String ... fields) {
        final HashSet<String> m = new HashSet<String>(Arrays.asList(fields));
        return new FieldMatcher(){

            @Override
            public boolean match(String str) {
                return m.contains(str);
            }

            @Override
            public boolean match(MappingField mf, Object obj) {
                return this.match(mf.getName());
            }
        };
    }
}

