/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.consumer;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.xiaomi.youpin.prometheus.client.multi.MutiMetrics;
import com.xiaomi.youpin.prometheus.client.multi.MutiPrometheus;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.ozhera.trace.etl.consumer.EnterManager;
import org.apache.ozhera.trace.etl.consumer.MutiMetricsCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataCacheService {
    private static final Logger log = LoggerFactory.getLogger(DataCacheService.class);
    private CopyOnWriteArrayList<byte[]> cacheData = new CopyOnWriteArrayList();
    private boolean startCache = false;
    @Resource
    private MutiMetricsCall call;
    @Resource
    private EnterManager enterManager;
    @NacosValue(value="${prometheus.pull.header}", autoRefreshed=true)
    private String prometheusPullHeader;

    public int dataSize() {
        return this.cacheData.size();
    }

    @PostConstruct
    public void init() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            try {
                if (this.cacheData.size() > 4) {
                    log.info("clear cache data:{}", (Object)this.cacheData.size());
                    this.cacheData.clear();
                }
            }
            catch (Throwable ex) {
                log.error(ex.getMessage());
            }
        }, 0L, 60L, TimeUnit.SECONDS);
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            if (this.startCache) {
                try {
                    Stopwatch sw = Stopwatch.createStarted();
                    this.enterManager.getMonitor().enter();
                    try {
                        while (this.enterManager.getProcessNum().get() > 0) {
                            TimeUnit.MILLISECONDS.sleep(20L);
                        }
                        this.call.change();
                    }
                    finally {
                        this.enterManager.getMonitor().leave();
                        log.info("change use time:{}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                    }
                    this.cacheData();
                }
                catch (Throwable ex) {
                    log.error(ex.getMessage(), ex);
                }
            }
        }, 0L, 15L, TimeUnit.SECONDS);
    }

    public byte[] getData() {
        log.info("get data");
        Stopwatch sw = Stopwatch.createStarted();
        try {
            if (this.cacheData.size() >= 1) {
                byte[] byArray = this.cacheData.remove(0);
                return byArray;
            }
        }
        finally {
            log.info("get data use time:{}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        }
        return new byte[0];
    }

    public void cacheData() {
        Executors.newSingleThreadExecutor().submit(() -> {
            log.info("cache data");
            Stopwatch sw = Stopwatch.createStarted();
            List<Object> list = new ArrayList();
            MutiMetrics old = this.call.old();
            CollectorRegistry registry = old.getRegistry();
            try {
                Field field = registry.getClass().getDeclaredField("namesToCollectors");
                field.setAccessible(true);
                Map namesToCollectors = (Map)field.get(registry);
                list = namesToCollectors.keySet().stream().filter(it -> !it.endsWith("created")).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.info("export metrics error : ", (Throwable)e);
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 OutputStreamWriter writer = new OutputStreamWriter(baos);){
                TextFormat.writeFormat((String)this.prometheusPullHeader, (Writer)writer, (Enumeration)registry.filteredMetricFamilySamples((Set)Sets.newHashSet(list)));
                writer.flush();
                byte[] bytes = baos.toByteArray();
                this.cacheData.add(bytes);
            }
            catch (Throwable ex) {
                log.error(ex.getMessage());
            }
            finally {
                this.clearMetrics(old);
            }
            log.info("cache data use time:{} ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        });
    }

    /*
     * Exception decompiling
     */
    public byte[] cacheDataSync() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clearMetrics(MutiMetrics old) {
        try {
            MutiPrometheus prometheus = old.gMetricsMgr;
            if (prometheus != null) {
                Map prometheusMetrics = prometheus.getPrometheusMetrics();
                this.clearTypeMetrics(prometheusMetrics, old.getRegistry());
                prometheus.getPrometheusMetrics().clear();
                prometheus.getPrometheusTypeMetrics().clear();
            }
        }
        catch (Exception e) {
            log.error("clear metrics error", (Throwable)e);
        }
    }

    private void clearTypeMetrics(Map<String, Object> prometheusMetrics, CollectorRegistry registry) {
        for (String key : prometheusMetrics.keySet()) {
            Object o = prometheusMetrics.get(key);
            if (o instanceof Counter) {
                Counter counter = (Counter)o;
                registry.unregister((Collector)counter);
                continue;
            }
            if (o instanceof Gauge) {
                Gauge gauge = (Gauge)o;
                gauge.clear();
                registry.unregister((Collector)gauge);
                continue;
            }
            if (o instanceof Histogram) {
                Histogram histogram = (Histogram)o;
                histogram.clear();
                registry.unregister((Collector)histogram);
                continue;
            }
            log.error("metrics : " + key + " Type conversion failed, original type : " + o.getClass().getName());
        }
    }

    public boolean isStartCache() {
        return this.startCache;
    }

    public void setStartCache(boolean startCache) {
        this.startCache = startCache;
    }

    private static /* synthetic */ boolean lambda$cacheDataSync$4(String it) {
        return !it.endsWith("created");
    }
}

