/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import org.apache.dubbo.rpc.cluster.support.BroadcastResult;

public class BroadcastCluster2Invoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(BroadcastCluster2Invoker.class);
    private static final String BROADCAST_RESULTS_KEY = "broadcast.results";
    private final ExecutorService executor = Executors.newCachedThreadPool(new NamedInternalThreadFactory("broadcast_cluster2", true));

    public BroadcastCluster2Invoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        this.checkInvokers(invokers, invocation);
        RpcContext.getContext().setInvokers(invokers);
        InvokeResult res = this.invoke(invokers, invocation);
        if (this.hasException(res.exception)) {
            return this.createResult(invocation, res.exception, res.resultList);
        }
        Object value = res.resultList.stream().map(it -> it.getData()).findFirst().orElse(null);
        return this.createResult(invocation, (Object)value, res.resultList);
    }

    private InvokeResult invoke(List<Invoker<T>> invokers, Invocation invocation) {
        List<Object> resultList = new ArrayList(invokers.size());
        List<Callable<BroadcastResult>> tasks = this.getCallables(invokers, invocation);
        try {
            List<Future<BroadcastResult>> futures = this.executor.invokeAll(tasks);
            resultList = futures.stream().map(it -> {
                try {
                    return (BroadcastResult)it.get();
                }
                catch (Throwable e) {
                    BroadcastResult br = new BroadcastResult();
                    br.setException(this.getRpcException(e));
                    br.setExceptionMsg(br.getException().getMessage());
                    return br;
                }
            }).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            BroadcastResult br = new BroadcastResult();
            br.setException(this.getRpcException(e));
            br.setExceptionMsg(br.getException().getMessage());
            resultList.add(br);
        }
        return new InvokeResult(resultList.stream().map(BroadcastResult::getException).filter(it -> null != it).findFirst().orElse(null), resultList);
    }

    private List<Callable<BroadcastResult>> getCallables(List<Invoker<T>> invokers, Invocation invocation) {
        List<Callable<BroadcastResult>> tasks = invokers.stream().map(it -> () -> {
            BroadcastResult br = new BroadcastResult(it.getUrl().getIp(), it.getUrl().getPort());
            Result result = null;
            try {
                result = it.invoke(invocation);
                if (null != result && result.hasException()) {
                    Throwable resultException = result.getException();
                    if (null != resultException) {
                        RpcException exception = this.getRpcException(result.getException());
                        br.setExceptionMsg(exception.getMessage());
                        br.setException(exception);
                        logger.warn(exception.getMessage(), exception);
                    }
                } else if (null != result) {
                    br.setData(result.getValue());
                    br.setResult(result);
                }
            }
            catch (Throwable ex) {
                RpcException exception = this.getRpcException(result.getException());
                br.setExceptionMsg(exception.getMessage());
                br.setException(exception);
                logger.warn(exception.getMessage(), exception);
            }
            return br;
        }).collect(Collectors.toList());
        return tasks;
    }

    private boolean hasException(RpcException exception) {
        return null != exception;
    }

    private Result createResult(Invocation invocation, RpcException exception, final List<BroadcastResult> resultList) {
        AppResponse result = new AppResponse(invocation){

            @Override
            public Result whenCompleteWithContext(BiConsumer<Result, Throwable> fn) {
                RpcContext.getServerContext().setAttachment(BroadcastCluster2Invoker.BROADCAST_RESULTS_KEY, new Gson().toJson((Object)resultList));
                return new AppResponse();
            }
        };
        result.setException(exception);
        return result;
    }

    private Result createResult(Invocation invocation, final Object value, final List<BroadcastResult> resultList) {
        return new AppResponse(invocation){

            @Override
            public Result whenCompleteWithContext(BiConsumer<Result, Throwable> fn) {
                RpcContext.getServerContext().setAttachment(BroadcastCluster2Invoker.BROADCAST_RESULTS_KEY, new Gson().toJson((Object)resultList));
                AppResponse res = new AppResponse();
                res.setValue(value);
                return res;
            }
        };
    }

    private RpcException getRpcException(Throwable throwable) {
        RpcException rpcException = null;
        rpcException = throwable instanceof RpcException ? (RpcException)throwable : new RpcException(throwable.getMessage(), throwable);
        return rpcException;
    }

    private class InvokeResult {
        public RpcException exception;
        public List<BroadcastResult> resultList;

        public InvokeResult(RpcException ex, List<BroadcastResult> resultList) {
            this.exception = ex;
            this.resultList = resultList;
        }
    }
}

