/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.support.Parameter;

public class ModuleConfig
extends AbstractConfig {
    private static final long serialVersionUID = 5508512956753757169L;
    private String name;
    private String version;
    private String owner;
    private String organization;
    private List<RegistryConfig> registries;
    private MonitorConfig monitor;

    public ModuleConfig() {
    }

    public ModuleConfig(String name) {
        this.setName(name);
    }

    @Parameter(key="module")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (StringUtils.isEmpty(this.id)) {
            this.id = name;
        }
    }

    @Parameter(key="module.version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public RegistryConfig getRegistry() {
        return CollectionUtils.isEmpty(this.registries) ? null : this.registries.get(0);
    }

    public void setRegistry(RegistryConfig registry) {
        ArrayList<RegistryConfig> registries = new ArrayList<RegistryConfig>(1);
        registries.add(registry);
        this.registries = registries;
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<? extends RegistryConfig> registries) {
        this.registries = registries;
    }

    public MonitorConfig getMonitor() {
        return this.monitor;
    }

    public void setMonitor(MonitorConfig monitor) {
        this.monitor = monitor;
    }

    public void setMonitor(String monitor) {
        this.monitor = new MonitorConfig(monitor);
    }
}

