/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.json;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.io.Bytes;
import org.apache.dubbo.common.json.JSONConverter;
import org.apache.dubbo.common.json.JSONNode;
import org.apache.dubbo.common.json.JSONWriter;

@Deprecated
public class GenericJSONConverter
implements JSONConverter {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Map<Class<?>, Encoder> GLOBAL_ENCODER_MAP = new HashMap();
    private static final Map<Class<?>, Decoder> GLOBAL_DECODER_MAP = new HashMap();

    @Override
    public void writeValue(Object obj, JSONWriter jb, boolean writeClass) throws IOException {
        if (obj == null) {
            jb.valueNull();
            return;
        }
        Class<?> c = obj.getClass();
        Encoder encoder = GLOBAL_ENCODER_MAP.get(c);
        if (encoder != null) {
            encoder.encode(obj, jb);
        } else if (obj instanceof JSONNode) {
            ((JSONNode)obj).writeJSON(this, jb, writeClass);
        } else if (c.isEnum()) {
            jb.valueString(((Enum)obj).name());
        } else if (c.isArray()) {
            int len = Array.getLength(obj);
            jb.arrayBegin();
            for (int i = 0; i < len; ++i) {
                this.writeValue(Array.get(obj, i), jb, writeClass);
            }
            jb.arrayEnd();
        } else if (Map.class.isAssignableFrom(c)) {
            jb.objectBegin();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                Object key = entry.getKey();
                if (key == null) continue;
                jb.objectItem(key.toString());
                Object value = entry.getValue();
                if (value == null) {
                    jb.valueNull();
                    continue;
                }
                this.writeValue(value, jb, writeClass);
            }
            jb.objectEnd();
        } else if (Collection.class.isAssignableFrom(c)) {
            jb.arrayBegin();
            for (Object item : (Collection)obj) {
                if (item == null) {
                    jb.valueNull();
                    continue;
                }
                this.writeValue(item, jb, writeClass);
            }
            jb.arrayEnd();
        } else if (obj instanceof Locale) {
            jb.valueString(obj.toString());
        } else {
            String[] pns;
            jb.objectBegin();
            Wrapper w = Wrapper.getWrapper(c);
            for (String pn : pns = w.getPropertyNames()) {
                if (obj instanceof Throwable && ("localizedMessage".equals(pn) || "cause".equals(pn) || "suppressed".equals(pn) || "stackTrace".equals(pn))) continue;
                jb.objectItem(pn);
                Object value = w.getPropertyValue(obj, pn);
                if (value == null || value == obj) {
                    jb.valueNull();
                    continue;
                }
                this.writeValue(value, jb, writeClass);
            }
            if (writeClass) {
                jb.objectItem("class");
                this.writeValue(obj.getClass().getName(), jb, writeClass);
            }
            jb.objectEnd();
        }
    }

    @Override
    public Object readValue(Class<?> c, Object jv) throws IOException {
        if (jv == null) {
            return null;
        }
        Decoder decoder = GLOBAL_DECODER_MAP.get(c);
        if (decoder != null) {
            return decoder.decode(jv);
        }
        if (c.isEnum()) {
            return Enum.valueOf(c, String.valueOf(jv));
        }
        return jv;
    }

    static {
        Encoder e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueBoolean((Boolean)obj);
            }
        };
        GLOBAL_ENCODER_MAP.put(Boolean.TYPE, e);
        GLOBAL_ENCODER_MAP.put(Boolean.class, e);
        e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueInt(((Number)obj).intValue());
            }
        };
        GLOBAL_ENCODER_MAP.put(Integer.TYPE, e);
        GLOBAL_ENCODER_MAP.put(Integer.class, e);
        GLOBAL_ENCODER_MAP.put(Short.TYPE, e);
        GLOBAL_ENCODER_MAP.put(Short.class, e);
        GLOBAL_ENCODER_MAP.put(Byte.TYPE, e);
        GLOBAL_ENCODER_MAP.put(Byte.class, e);
        GLOBAL_ENCODER_MAP.put(AtomicInteger.class, e);
        e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueString(Character.toString(((Character)obj).charValue()));
            }
        };
        GLOBAL_ENCODER_MAP.put(Character.TYPE, e);
        GLOBAL_ENCODER_MAP.put(Character.class, e);
        e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueLong(((Number)obj).longValue());
            }
        };
        GLOBAL_ENCODER_MAP.put(Long.TYPE, e);
        GLOBAL_ENCODER_MAP.put(Long.class, e);
        GLOBAL_ENCODER_MAP.put(AtomicLong.class, e);
        GLOBAL_ENCODER_MAP.put(BigInteger.class, e);
        e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueFloat(((Number)obj).floatValue());
            }
        };
        GLOBAL_ENCODER_MAP.put(Float.TYPE, e);
        GLOBAL_ENCODER_MAP.put(Float.class, e);
        e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueDouble(((Number)obj).doubleValue());
            }
        };
        GLOBAL_ENCODER_MAP.put(Double.TYPE, e);
        GLOBAL_ENCODER_MAP.put(Double.class, e);
        GLOBAL_ENCODER_MAP.put(BigDecimal.class, e);
        e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueString(obj.toString());
            }
        };
        GLOBAL_ENCODER_MAP.put(String.class, e);
        GLOBAL_ENCODER_MAP.put(StringBuilder.class, e);
        GLOBAL_ENCODER_MAP.put(StringBuffer.class, e);
        e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueString(Bytes.bytes2base64((byte[])obj));
            }
        };
        GLOBAL_ENCODER_MAP.put(byte[].class, e);
        e = new Encoder(){

            @Override
            public void encode(Object obj, JSONWriter jb) throws IOException {
                jb.valueString(new SimpleDateFormat(GenericJSONConverter.DATE_FORMAT).format((Date)obj));
            }
        };
        GLOBAL_ENCODER_MAP.put(Date.class, e);
        Decoder d = Object::toString;
        GLOBAL_DECODER_MAP.put(String.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Boolean) {
                    return (boolean)((Boolean)jv);
                }
                return false;
            }
        };
        GLOBAL_DECODER_MAP.put(Boolean.TYPE, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Boolean) {
                    return (Boolean)jv;
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Boolean.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof String && ((String)jv).length() > 0) {
                    return Character.valueOf(((String)jv).charAt(0));
                }
                return Character.valueOf('\u0000');
            }
        };
        GLOBAL_DECODER_MAP.put(Character.TYPE, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof String && ((String)jv).length() > 0) {
                    return Character.valueOf(((String)jv).charAt(0));
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Character.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).intValue();
                }
                return 0;
            }
        };
        GLOBAL_DECODER_MAP.put(Integer.TYPE, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).intValue();
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Integer.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).shortValue();
                }
                return (short)0;
            }
        };
        GLOBAL_DECODER_MAP.put(Short.TYPE, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).shortValue();
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Short.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).longValue();
                }
                return 0L;
            }
        };
        GLOBAL_DECODER_MAP.put(Long.TYPE, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).longValue();
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Long.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return Float.valueOf(((Number)jv).floatValue());
                }
                return Float.valueOf(0.0f);
            }
        };
        GLOBAL_DECODER_MAP.put(Float.TYPE, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return new Float(((Number)jv).floatValue());
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Float.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).doubleValue();
                }
                return 0.0;
            }
        };
        GLOBAL_DECODER_MAP.put(Double.TYPE, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return new Double(((Number)jv).doubleValue());
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Double.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).byteValue();
                }
                return (byte)0;
            }
        };
        GLOBAL_DECODER_MAP.put(Byte.TYPE, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) {
                if (jv instanceof Number) {
                    return ((Number)jv).byteValue();
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Byte.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                if (jv instanceof String) {
                    return Bytes.base642bytes((String)jv);
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(byte[].class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                return new StringBuilder(jv.toString());
            }
        };
        GLOBAL_DECODER_MAP.put(StringBuilder.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                return new StringBuffer(jv.toString());
            }
        };
        GLOBAL_DECODER_MAP.put(StringBuffer.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                if (jv instanceof Number) {
                    return BigInteger.valueOf(((Number)jv).longValue());
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(BigInteger.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                if (jv instanceof Number) {
                    return BigDecimal.valueOf(((Number)jv).doubleValue());
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(BigDecimal.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                if (jv instanceof Number) {
                    return new AtomicInteger(((Number)jv).intValue());
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(AtomicInteger.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                if (jv instanceof Number) {
                    return new AtomicLong(((Number)jv).longValue());
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(AtomicLong.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                if (jv instanceof String) {
                    try {
                        return new SimpleDateFormat(GenericJSONConverter.DATE_FORMAT).parse((String)jv);
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(e.getMessage(), e);
                    }
                }
                if (jv instanceof Number) {
                    return new Date(((Number)jv).longValue());
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Date.class, d);
        d = new Decoder(){

            @Override
            public Object decode(Object jv) throws IOException {
                if (jv instanceof String) {
                    String[] items = ((String)jv).split("_");
                    if (items.length == 1) {
                        return new Locale(items[0]);
                    }
                    if (items.length == 2) {
                        return new Locale(items[0], items[1]);
                    }
                    return new Locale(items[0], items[1], items[2]);
                }
                return null;
            }
        };
        GLOBAL_DECODER_MAP.put(Locale.class, d);
    }

    protected static interface Decoder {
        public Object decode(Object var1) throws IOException;
    }

    protected static interface Encoder {
        public void encode(Object var1, JSONWriter var2) throws IOException;
    }
}

