/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateDetailMapper;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateMapper;
import org.apache.ozhera.log.manager.model.convert.MilogLogTemplateConvert;
import org.apache.ozhera.log.manager.model.convert.MilogLongTemplateDetailConvert;
import org.apache.ozhera.log.manager.model.dto.LogTemplateDTO;
import org.apache.ozhera.log.manager.model.dto.LogTemplateDetailDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTemplateDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTemplateDetailDO;
import org.apache.ozhera.log.manager.service.LogTemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class LogTemplateServiceImpl
extends ServiceImpl<MilogLogTemplateMapper, MilogLogTemplateDO>
implements LogTemplateService {
    private static final Logger log = LoggerFactory.getLogger(LogTemplateServiceImpl.class);
    @Resource
    private MilogLogTemplateMapper milogLogTemplateMapper;
    @Resource
    private MilogLogTemplateDetailMapper templateDetailMapper;

    @Override
    public Result<List<LogTemplateDTO>> getLogTemplateList(String area) {
        List<MilogLogTemplateDO> logTemplateDOList = this.milogLogTemplateMapper.selectSupportedTemplate(area);
        List<LogTemplateDTO> logTemplateDTOList = MilogLogTemplateConvert.INSTANCE.fromDOList(logTemplateDOList);
        this.assembleLogTemplateDetail(logTemplateDTOList);
        return Result.success(logTemplateDTOList);
    }

    private void assembleLogTemplateDetail(List<LogTemplateDTO> logTemplateDTOList) {
        if (CollectionUtils.isNotEmpty(logTemplateDTOList)) {
            logTemplateDTOList.forEach(logTemplateDTO -> {
                logTemplateDTO.setLogTemplateDetailDTOList((LogTemplateDetailDTO)this.getLogTemplateById(logTemplateDTO.getValue()).getData());
                LogTypeEnum logTypeEnum = LogTypeEnum.type2enum((Integer)logTemplateDTO.getType());
                logTemplateDTO.setDescribe(null != logTypeEnum ? logTypeEnum.getDescribe() : "");
            });
        }
    }

    @Override
    public Result<LogTemplateDetailDTO> getLogTemplateById(long logTemplateId) {
        MilogLogTemplateDO logTemplate = (MilogLogTemplateDO)this.milogLogTemplateMapper.selectById(Long.valueOf(logTemplateId));
        MilogLogTemplateDetailDO templateDetail = this.templateDetailMapper.getByTemplateId(logTemplateId);
        if (templateDetail == null) {
            return Result.success(null);
        }
        LogTemplateDetailDTO dto = MilogLongTemplateDetailConvert.INSTANCE.fromDO(logTemplate, templateDetail);
        return Result.success((Object)dto);
    }
}

