/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.lang.Assert;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.app.model.vo.HeraEnvIpVo;
import org.apache.ozhera.log.api.enums.LogStructureEnum;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.enums.ProjectTypeEnum;
import org.apache.ozhera.log.api.enums.RateLimitEnum;
import org.apache.ozhera.log.api.model.meta.FilterDefine;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.common.Utils;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.utils.ManagerUtil;
import org.apache.ozhera.log.manager.common.validation.HeraConfigValid;
import org.apache.ozhera.log.manager.dao.MilogAppMiddlewareRelDao;
import org.apache.ozhera.log.manager.dao.MilogAppTopicRelDao;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.dao.MilogSpaceDao;
import org.apache.ozhera.log.manager.mapper.MilogLogSearchSaveMapper;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateMapper;
import org.apache.ozhera.log.manager.model.bo.LogTailParam;
import org.apache.ozhera.log.manager.model.bo.MlogParseParam;
import org.apache.ozhera.log.manager.model.dto.AppTypeTailDTO;
import org.apache.ozhera.log.manager.model.dto.DockerScaleBo;
import org.apache.ozhera.log.manager.model.dto.LogTailDTO;
import org.apache.ozhera.log.manager.model.dto.MapDTO;
import org.apache.ozhera.log.manager.model.dto.MilogAppEnvDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.apache.ozhera.log.manager.model.vo.QuickQueryVO;
import org.apache.ozhera.log.manager.service.BaseService;
import org.apache.ozhera.log.manager.service.LogTailService;
import org.apache.ozhera.log.manager.service.bind.LogTypeProcessor;
import org.apache.ozhera.log.manager.service.bind.LogTypeProcessorFactory;
import org.apache.ozhera.log.manager.service.env.HeraEnvIpServiceFactory;
import org.apache.ozhera.log.manager.service.extension.agent.MilogAgentService;
import org.apache.ozhera.log.manager.service.extension.agent.MilogAgentServiceFactory;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionService;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionService;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionService;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.impl.HeraAppEnvServiceImpl;
import org.apache.ozhera.log.manager.service.impl.HeraAppServiceImpl;
import org.apache.ozhera.log.manager.service.impl.MilogAppMiddlewareRelServiceImpl;
import org.apache.ozhera.log.manager.service.impl.MilogConfigNacosServiceImpl;
import org.apache.ozhera.log.manager.service.impl.MilogStreamServiceImpl;
import org.apache.ozhera.log.manager.service.nacos.impl.StreamConfigNacosProvider;
import org.apache.ozhera.log.parse.LogParser;
import org.apache.ozhera.log.parse.LogParserFactory;
import org.apache.ozhera.log.utils.IndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class LogTailServiceImpl
extends BaseService
implements LogTailService {
    private static final Logger log = LoggerFactory.getLogger(LogTailServiceImpl.class);
    @Resource
    private HeraEnvIpServiceFactory heraEnvIpServiceFactory;
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private MilogLogstoreDao logStoreDao;
    @Resource
    private MilogSpaceDao milogSpaceDao;
    @Resource
    private MilogConfigNacosServiceImpl milogConfigNacosServiceImpl;
    @Resource
    private MilogAppTopicRelDao milogAppTopicRelDao;
    @Resource
    private MilogStreamServiceImpl milogStreamService;
    @Resource
    private MilogAppMiddlewareRelServiceImpl milogAppMiddlewareRelService;
    @Resource
    private MilogAppMiddlewareRelDao milogAppMiddlewareRelDao;
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Resource
    private StreamConfigNacosProvider streamConfigNacosProvider;
    @Value(value="$log_type_mq_not_consume")
    private String logTypeMqNotConsume;
    @Value(value="$dubbo.miline.rpc.env")
    private String dubboMilineRpcEnv;
    @Value(value="$server.type")
    private String serverType;
    @Resource
    private HeraAppServiceImpl heraAppService;
    @Resource
    private HeraAppEnvServiceImpl heraAppEnvService;
    @Resource
    private MilogLogTemplateMapper milogLogTemplateMapper;
    @Resource
    private MilogLogSearchSaveMapper searchSaveMapper;
    @Resource
    private HeraConfigValid heraConfigValid;
    @Resource
    private LogTailServiceImpl logTailService;
    @Resource
    private LogTypeProcessorFactory logTypeProcessorFactory;
    private LogTypeProcessor logTypeProcessor;
    private TailExtensionService tailExtensionService;
    private MilogAgentService milogAgentService;
    private StoreExtensionService storeExtensionService;
    private ResourceExtensionService resourceExtensionService;

    public void init() {
        this.logTypeProcessorFactory.setMilogLogTemplateMapper(this.milogLogTemplateMapper);
        this.logTypeProcessor = this.logTypeProcessorFactory.getLogTypeProcessor();
        this.tailExtensionService = TailExtensionServiceFactory.getTailExtensionService();
        this.milogAgentService = MilogAgentServiceFactory.getAgentExtensionService();
        this.storeExtensionService = StoreExtensionServiceFactory.getStoreExtensionService();
        this.resourceExtensionService = ResourceExtensionServiceFactory.getResourceExtensionService();
    }

    private static boolean filterNameEmpty(MilogLogTailDo milogLogTailDo) {
        return StringUtils.isNotBlank((CharSequence)milogLogTailDo.getTail());
    }

    private QuickQueryVO applyQueryVO(MilogLogTailDo logTailDo) {
        Integer isFavourite = this.searchSaveMapper.isMyFavouriteTail(MoneUserContext.getCurrentUser().getUser(), logTailDo.getId());
        return this.applyQueryVO(logTailDo, isFavourite);
    }

    private QuickQueryVO applyQueryVO(MilogLogTailDo logTailDo, Integer isFavourite) {
        return QuickQueryVO.builder().spaceId(logTailDo.getSpaceId()).storeId(logTailDo.getStoreId()).tailId(logTailDo.getId()).tailName(logTailDo.getTail()).envId(logTailDo.getEnvId()).envName(logTailDo.getEnvName()).isFavourite(isFavourite == null || isFavourite < 1 ? 0 : 1).deploySpace(logTailDo.getDeploySpace()).collectionReady(logTailDo.getCollectionReady()).build();
    }

    private void handleMqTailParam(MilogLogStoreDO logStoreDO, LogTailParam param) {
        param.setMiddlewareConfig(param.getMiddlewareConfig().stream().filter(Objects::nonNull).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(param.getMiddlewareConfig()) && param.getMiddlewareConfig().size() == 3) {
            param.setMiddlewareConfigId(((Double)param.getMiddlewareConfig().get(1)).longValue());
            param.setTopicName((String)param.getMiddlewareConfig().get(2));
        } else if (CollectionUtils.isNotEmpty(param.getMiddlewareConfig()) && param.getMiddlewareConfig().size() == 2) {
            param.setMiddlewareConfigId(((Double)param.getMiddlewareConfig().get(1)).longValue());
            this.deleteMqRel(param.getMilogAppId(), param.getId());
        } else if (this.tailExtensionService.tailHandlePreprocessingSwitch(logStoreDO, param)) {
            this.deleteMqRel(param.getMilogAppId(), param.getId());
            MilogMiddlewareConfig config = null != logStoreDO.getMqResourceId() ? this.milogMiddlewareConfigDao.queryById(logStoreDO.getMqResourceId()) : this.milogMiddlewareConfigDao.queryDefaultMiddlewareConfig();
            param.setMiddlewareConfigId(config.getId());
        }
    }

    private void deleteMqRel(Long milogAppId, Long tailId) {
        if (null != tailId) {
            this.milogAppMiddlewareRelDao.deleteRel(milogAppId, tailId);
        }
    }

    @Override
    public Result<LogTailDTO> newMilogLogTail(LogTailParam param) {
        String errorMsg = this.heraConfigValid.verifyLogTailParam(param);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            return new Result(CommonError.ParamsError.getCode(), errorMsg);
        }
        MilogLogStoreDO logStore = this.logStoreDao.queryById(param.getStoreId());
        if (logStore == null) {
            return new Result(CommonError.ParamsError.getCode(), "logStore not found");
        }
        String machineRoom = logStore.getMachineRoom();
        String tail = param.getTail();
        if (this.heraConfigValid.checkTailNameSame(tail, null, machineRoom, param.getSpaceId())) {
            return new Result(CommonError.ParamsError.getCode(), "The alias is duplicated, please confirm and submit");
        }
        param.setValueList(IndexUtils.getNumberValueList((String)logStore.getKeyList(), (String)param.getValueList()));
        this.handleMqTailParam(logStore, param);
        AppBaseInfo appBaseInfo = this.getAppBaseInfo(param);
        MilogLogTailDo mt = this.buildLogTailDo(param, logStore, appBaseInfo, MoneUserContext.getCurrentUser().getUser());
        MilogLogTailDo milogLogtailDo = this.milogLogtailDao.add(mt);
        boolean supportedConsume = this.logTypeProcessor.supportedConsume(logStore.getLogType());
        try {
            if (null != milogLogtailDo) {
                if (this.tailExtensionService.bindMqResourceSwitch(logStore, param.getAppType())) {
                    this.tailExtensionService.defaultBindingAppTailConfigRel(milogLogtailDo.getId(), param.getMilogAppId(), null == param.getMiddlewareConfigId() ? logStore.getMqResourceId() : param.getMiddlewareConfigId(), param.getTopicName(), param.getBatchSendSize());
                    this.tailExtensionService.sendMessageOnCreate(param, mt, param.getMilogAppId(), supportedConsume);
                } else if (this.tailExtensionService.bindPostProcessSwitch(param.getStoreId())) {
                    this.tailExtensionService.defaultBindingAppTailConfigRelPostProcess(milogLogtailDo.getSpaceId(), milogLogtailDo.getStoreId(), milogLogtailDo.getId(), milogLogtailDo.getMilogAppId(), logStore.getMqResourceId());
                    this.tailExtensionService.sendMessageOnCreate(param, mt, param.getMilogAppId(), supportedConsume);
                }
                LogTailDTO ret = new LogTailDTO();
                ret.setId(mt.getId());
                return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), (Object)ret);
            }
            log.warn("[MilogLogtailService.newMilogLogtail] creator MilogLogtail err,milogAppId:{},logpath:{}", (Object)param.getMilogAppId(), (Object)param.getLogPath());
            return new Result(CommonError.UnknownError.getCode(), CommonError.UnknownError.getMessage());
        }
        catch (Exception e) {
            log.warn("[MilogLogtailService.newMilogLogtail] creator MilogLogtail err,milogAppId:{},logpath:{}", new Object[]{param.getMilogAppId(), param.getLogPath(), e});
            return new Result(CommonError.UnknownError.getCode(), e.getMessage());
        }
    }

    @Override
    public void sengMessageNewTail(LogTailParam param, MilogLogTailDo milogLogtailDo, MilogLogStoreDO milogLogStore) {
        this.milogAppMiddlewareRelService.bindingTailConfigRel(milogLogtailDo.getId(), param.getMilogAppId(), param.getMiddlewareConfigId(), param.getTopicName());
        this.tailExtensionService.sendMessageOnCreate(param, milogLogtailDo, param.getMilogAppId(), this.logTypeProcessor.supportedConsume(milogLogStore.getLogType()));
    }

    @Override
    public MilogLogTailDo buildLogTailDo(LogTailParam param, MilogLogStoreDO milogLogStore, AppBaseInfo appBaseInfo, String creator) {
        MilogLogTailDo mt = this.logTailParam2Do(param, milogLogStore, appBaseInfo);
        this.wrapBaseCommon(mt, OperateEnum.ADD_OPERATE, creator);
        return mt;
    }

    private boolean checkTailNameSame(String tailName, Long id, String machineRoom, Long spaceId) {
        List<MilogLogTailDo> logtailDoList = this.milogLogtailDao.queryTailNameExists(tailName, machineRoom, spaceId);
        if (null == id) {
            return CollectionUtils.isNotEmpty(logtailDoList);
        }
        if (CollectionUtils.isEmpty(logtailDoList)) {
            return false;
        }
        MilogLogTailDo milogLogtailDo = logtailDoList.get(logtailDoList.size() - 1);
        return !milogLogtailDo.getId().equals(id);
    }

    @Override
    public void sengMessageToAgent(Long milogAppId, MilogLogTailDo logtailDo) {
        this.milogAgentService.publishIncrementConfig(logtailDo.getId(), milogAppId, logtailDo.getIps());
    }

    @Override
    public void sengMessageToStream(MilogLogTailDo mt, Integer type) {
        this.handleNacosConfigByMotorRoom(mt, MachineRegionEnum.CN_MACHINE.getEn(), type, ProjectTypeEnum.MIONE_TYPE.getCode());
    }

    @Override
    public void handleNacosConfigByMotorRoom(MilogLogTailDo mt, String motorRoomEn, Integer type, Integer projectType) {
        this.milogConfigNacosServiceImpl.chooseCurrentEnvNacosService(motorRoomEn);
        if (OperateEnum.ADD_OPERATE.getCode().equals(type) || OperateEnum.UPDATE_OPERATE.getCode().equals(type)) {
            this.milogConfigNacosServiceImpl.publishStreamConfig(mt.getSpaceId(), type, projectType, motorRoomEn);
        }
        this.milogConfigNacosServiceImpl.publishNameSpaceConfig(motorRoomEn, mt.getSpaceId(), mt.getStoreId(), mt.getId(), type, "");
    }

    @Override
    public boolean deleteConfigRemote(Long spaceId, Long id, String motorRoomEn, LogStructureEnum logStructureEnum) {
        Assert.notNull((Object)spaceId, (String)"deleteConfigRemote spaceId can not null", (Object[])new Object[0]);
        Assert.notNull((Object)id, (String)"deleteConfigRemote id can not null", (Object[])new Object[0]);
        this.milogConfigNacosServiceImpl.chooseCurrentEnvNacosService(motorRoomEn);
        if (LogStructureEnum.SPACE == logStructureEnum) {
            this.milogConfigNacosServiceImpl.publishStreamConfig(spaceId, OperateEnum.DELETE_OPERATE.getCode(), null, motorRoomEn);
            return true;
        }
        if (LogStructureEnum.STORE == logStructureEnum) {
            this.milogConfigNacosServiceImpl.publishNameSpaceConfig(motorRoomEn, spaceId, id, null, OperateEnum.DELETE_OPERATE.getCode(), logStructureEnum.getCode());
            return true;
        }
        MilogLogTailDo tailDo = this.milogLogtailDao.queryById(id);
        this.milogConfigNacosServiceImpl.publishNameSpaceConfig(motorRoomEn, spaceId, tailDo.getStoreId(), id, OperateEnum.DELETE_OPERATE.getCode(), logStructureEnum.getCode());
        return true;
    }

    @Override
    public Result<LogTailDTO> getMilogLogtailById(Long id) {
        MilogLogTailDo tail = this.milogLogtailDao.queryById(id);
        if (null != tail) {
            MilogLogStoreDO logStore = this.logStoreDao.queryById(tail.getStoreId());
            if (null != logStore && StringUtils.isNotEmpty((CharSequence)logStore.getKeyList())) {
                String keyList = logStore.getKeyList();
                String valueList = Utils.getKeyValueList(keyList, tail.getValueList());
                tail.setValueList(valueList);
            }
            LogTailDTO logTailDTO = this.milogLogtailDO2DTO(tail);
            if (this.tailExtensionService.decorateTailDTOValId(logStore.getLogType(), (int)logTailDTO.getAppType())) {
                this.decorateMilogTailDTO(logTailDTO);
            }
            return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), (Object)logTailDTO);
        }
        return new Result(CommonError.UnknownError.getCode(), "tail not found");
    }

    private void decorateMilogTailDTO(LogTailDTO logTailDTO) {
        Optional<AppBaseInfo> optionalAppBaseInfo = Optional.ofNullable(this.heraAppService.queryById(logTailDTO.getMilogAppId()));
        optionalAppBaseInfo.ifPresent(appBaseInfo -> {
            logTailDTO.setSource(appBaseInfo.getPlatformType().toString());
            List<MilogAppMiddlewareRel> milogAppMiddlewareRels = this.milogAppMiddlewareRelDao.queryByCondition(logTailDTO.getMilogAppId(), null, logTailDTO.getId());
            if (CollectionUtils.isNotEmpty(milogAppMiddlewareRels)) {
                MilogAppMiddlewareRel milogAppMiddlewareRel = milogAppMiddlewareRels.get(0);
                MilogMiddlewareConfig config = this.milogMiddlewareConfigDao.queryById(milogAppMiddlewareRel.getMiddlewareId());
                logTailDTO.setMiddlewareConfig(Arrays.asList(Long.valueOf(config.getType().intValue()), config.getId(), milogAppMiddlewareRel.getConfig().getTopic()));
                logTailDTO.setBatchSendSize(milogAppMiddlewareRel.getConfig().getBatchSendSize());
            }
        });
    }

    @Override
    public Result<Map<String, Object>> getMilogLogBypage(Long storeId, int page, int pagesize) {
        List<MilogLogTailDo> ret = this.milogLogtailDao.getMilogLogtailByPage(storeId, page, pagesize);
        ArrayList res = Lists.newArrayList();
        ret.forEach(v -> res.add(this.milogLogtailDO2DTO((MilogLogTailDo)v)));
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("list", res);
        result.put("total", Integer.valueOf(this.milogLogtailDao.getTailCount(storeId)));
        result.put("page", Integer.valueOf(page));
        result.put("pageSize", Integer.valueOf(pagesize));
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), result);
    }

    @Override
    public Result<Map<String, Object>> getLogTailCountByStoreId(Long storeId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("count", this.milogLogtailDao.getTailCount(storeId));
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), result);
    }

    @Override
    public Result<List<LogTailDTO>> getMilogLogtailByIds(List<Long> ids) {
        List<MilogLogTailDo> ret = this.milogLogtailDao.getMilogLogtail(ids);
        ArrayList res = Lists.newArrayList();
        ret.forEach(v -> res.add(this.milogLogtailDO2DTO((MilogLogTailDo)v)));
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), (Object)res);
    }

    @Override
    public Result<Void> updateMilogLogTail(LogTailParam param) {
        MilogLogTailDo ret = this.milogLogtailDao.queryById(param.getId());
        if (ret == null) {
            return new Result(CommonError.ParamsError.getCode(), "tail does not exist");
        }
        String errorMsg = this.heraConfigValid.verifyLogTailParam(param);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            return new Result(CommonError.ParamsError.getCode(), errorMsg);
        }
        MilogLogStoreDO logStoreDO = this.logStoreDao.queryById(param.getStoreId());
        if (logStoreDO == null) {
            return new Result(CommonError.ParamsError.getCode(), "Logstore does not exist");
        }
        this.handleMqTailParam(logStoreDO, param);
        String tail = param.getTail();
        Long id = param.getId();
        String machineRoom = logStoreDO.getMachineRoom();
        if (this.checkTailNameSame(tail, id, machineRoom, param.getSpaceId())) {
            return new Result(CommonError.ParamsError.getCode(), "The alias is duplicated, please confirm and submit");
        }
        param.setValueList(IndexUtils.getNumberValueList((String)logStoreDO.getKeyList(), (String)param.getValueList()));
        AppBaseInfo appBaseInfo = this.getAppBaseInfo(param);
        FilterDefine filterDefine = FilterDefine.consRateLimitFilterDefine((String)param.getTailRate());
        ArrayList<FilterDefine> defines = new ArrayList<FilterDefine>();
        if (filterDefine != null) {
            defines.add(filterDefine);
        }
        MilogLogTailDo milogLogtailDo = this.logTailParam2Do(param, logStoreDO, appBaseInfo);
        this.wrapBaseCommon(milogLogtailDo, OperateEnum.UPDATE_OPERATE);
        boolean isSucceed = this.milogLogtailDao.update(milogLogtailDo);
        if (isSucceed) {
            Integer appType = param.getAppType();
            boolean processSwitch = this.tailExtensionService.bindPostProcessSwitch(param.getStoreId());
            if (this.tailExtensionService.bindMqResourceSwitch(logStoreDO, appType) || processSwitch) {
                if (null != param.getMiddlewareConfigId()) {
                    this.tailExtensionService.defaultBindingAppTailConfigRel(param.getId(), param.getMilogAppId(), param.getMiddlewareConfigId(), param.getTopicName(), param.getBatchSendSize());
                }
                try {
                    List<String> oldIps = ret.getIps();
                    boolean supportedConsume = this.logTypeProcessor.supportedConsume(logStoreDO.getLogType());
                    this.tailExtensionService.updateSendMsg(milogLogtailDo, oldIps, supportedConsume);
                }
                catch (Exception e) {
                    log.error("update tail error", (Throwable)e);
                }
            }
            return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage());
        }
        log.warn("[MilogLogtailService.updateMilogLogtail] update MilogLogtail err,id:{}", (Object)param.getId());
        return new Result(CommonError.UnknownError.getCode(), CommonError.UnknownError.getMessage());
    }

    private AppBaseInfo getAppBaseInfo(LogTailParam param) {
        return this.heraAppService.queryById(param.getMilogAppId());
    }

    public void compareChangeDelIps(Long tailId, String logPath, List<String> newIps, List<String> oldIps) {
        if (CollectionUtils.isEmpty(oldIps)) {
            return;
        }
        List<String> delIps = oldIps.stream().filter(s -> !newIps.contains(s)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delIps)) {
            this.milogAgentService.delLogCollDirectoryByIp(tailId, ManagerUtil.getPhysicsDirectory(logPath), delIps);
        }
    }

    @Override
    public Result<Void> deleteLogTail(Long id) {
        MilogLogTailDo milogLogtailDo = this.milogLogtailDao.queryById(id);
        if (null == milogLogtailDo) {
            return new Result(CommonError.ParamsError.getCode(), "tail does not exist");
        }
        String validMsg = this.tailExtensionService.deleteCheckProcessPre(id);
        if (StringUtils.isNotEmpty((CharSequence)validMsg)) {
            return new Result(CommonError.ParamsError.getCode(), validMsg);
        }
        MilogLogStoreDO logStoreDO = this.logStoreDao.queryById(milogLogtailDo.getStoreId());
        this.deleteRemoteConfig(id, logStoreDO);
        if (this.milogLogtailDao.deleteMilogLogtail(id)) {
            if (this.storeExtensionService.isNeedSendMsgType(logStoreDO.getLogType())) {
                CompletableFuture.runAsync(() -> this.sendMessageOnDelete(milogLogtailDo, logStoreDO));
                this.tailExtensionService.logTailDelPostProcess(logStoreDO, milogLogtailDo);
            }
            return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage());
        }
        log.warn("[LogTailService.deleteLogTail] delete LogTail error,id:{}", (Object)id);
        return new Result(CommonError.UnknownError.getCode(), CommonError.UnknownError.getMessage());
    }

    private void deleteRemoteConfig(Long id, MilogLogStoreDO storeDO) {
        if (this.logTypeProcessor.supportedConsume(storeDO.getLogType())) {
            this.logTailService.deleteConfigRemote(storeDO.getSpaceId(), id, storeDO.getMachineRoom(), LogStructureEnum.TAIL);
        }
    }

    @Override
    public void sendMessageOnDelete(MilogLogTailDo mt, MilogLogStoreDO logStoreDO) {
        log.info("Send delete configuration information\uff0cmt:{}", (Object)Constant.GSON.toJson((Object)mt));
        this.resourceExtensionService.deleteMqResourceProcessing(mt, logStoreDO);
        this.milogAgentService.publishIncrementDel(mt.getId(), mt.getMilogAppId(), mt.getIps());
        this.milogAppMiddlewareRelDao.deleteRel(mt.getMilogAppId(), mt.getId());
    }

    @Override
    public Result<List<MapDTO>> getAppInfoByName(String appName, Integer type) {
        return Result.success(this.queryAllApps(appName, type));
    }

    private List<MapDTO> queryAllApps(String appName, Integer type) {
        List<MapDTO> mapDTOS = this.queryAppInfo(appName, type);
        return mapDTOS;
    }

    private List<MapDTO> queryAppInfo(String appName, Integer type) {
        List<AppBaseInfo> apps = this.heraAppService.queryAppInfoWithLog(appName, type);
        List<Object> mapDTOList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(apps)) {
            mapDTOList = apps.stream().map(response -> {
                MapDTO<String, Integer> mapDTO = new MapDTO<String, Integer>();
                mapDTO.setLabel(String.format("%s_%s", response.getPlatformName(), response.getAppName()));
                mapDTO.setValue(response.getId());
                mapDTO.setKey(response.getBindId());
                return mapDTO;
            }).collect(Collectors.toList());
        }
        return mapDTOList;
    }

    @Override
    public Result<List<MilogAppEnvDTO>> getEnInfosByAppId(Long milogAppId, Integer deployWay, String machineRoom) {
        if (null == milogAppId) {
            return Result.failParam((String)"The parameter cannot be empty");
        }
        AppBaseInfo appBaseInfo = this.heraAppService.queryById(milogAppId);
        if (null == appBaseInfo) {
            return Result.failParam((String)"The app does not exist");
        }
        List<MilogAppEnvDTO> appEnvDTOList = this.tailExtensionService.getEnInfosByAppId(appBaseInfo, milogAppId, deployWay, machineRoom);
        return Result.success(appEnvDTOList);
    }

    @Override
    public Result<List<String>> getTailNamesBystoreId(String tail, Integer appType, final Long id) {
        List<MilogLogTailDo> milogLogTailDos = this.milogLogtailDao.getMilogLogtailByIdsAndName((List<Long>)new ArrayList<Long>(){
            {
                this.add(id);
            }
        }, tail, appType);
        List<Object> ret = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(milogLogTailDos)) {
            ret = milogLogTailDos.stream().filter(LogTailServiceImpl::filterNameEmpty).map(MilogLogTailDo::getTail).distinct().collect(Collectors.toList());
        }
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), (Object)ret);
    }

    @Override
    public Result<List<MapDTO<String, String>>> tailRatelimit() {
        ArrayList<MapDTO> ret = new ArrayList<MapDTO>();
        ret.add(MapDTO.Of("\u5feb\u901f\u6536\u96c6-\u5c3d\u5feb\u6536\u96c6\uff0c\u5360\u7528\u4e00\u5b9a\u8d44\u6e90", RateLimitEnum.RATE_LIMIT_FAST.getRateLimit()));
        ret.add(MapDTO.Of("\u5e38\u89c4\u6536\u96c6", RateLimitEnum.RATE_LIMIT_MEDIUM.getRateLimit()));
        ret.add(MapDTO.Of("\u6162\u901f\u6536\u96c6", RateLimitEnum.RATE_LIMIT_SLOW.getRateLimit()));
        ret.add(MapDTO.Of("\u505c\u6b62\u6536\u96c6", RateLimitEnum.RATE_LIMIT_NONE.getRateLimit()));
        return Result.success(ret);
    }

    @Override
    public void dockerScaleDynamic(DockerScaleBo projectInfo) {
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.queryByAppAndEnv(projectInfo.getProjectId(), projectInfo.getEnvId());
        if (CollectionUtils.isNotEmpty(projectInfo.getIps()) && CollectionUtils.isNotEmpty(milogLogtailDos)) {
            log.info("Dynamically expand the configuration in the current environment,projectId:{},envId:{},config:{}", new Object[]{projectInfo.getProjectId(), projectInfo.getEnvId(), Constant.GSON.toJson(milogLogtailDos)});
            for (MilogLogTailDo milogLogtailDo : milogLogtailDos) {
                List<String> newIps;
                List<String> exitIps = milogLogtailDo.getIps();
                if (CollectionUtils.isEqualCollection(exitIps, newIps = projectInfo.getIps())) continue;
                milogLogtailDo.setIps(newIps);
                this.milogLogtailDao.update(milogLogtailDo);
                this.compareIpToHandle(milogLogtailDo.getId(), milogLogtailDo.getLogPath(), exitIps, newIps);
            }
        }
    }

    public void compareIpToHandle(Long tailId, String logPath, List<String> exitIps, List<String> newIps) {
        List<String> stopFileCollIps;
        List<String> expandIps;
        if (null == this.milogAgentService) {
            this.init();
        }
        if (CollectionUtils.isNotEmpty(expandIps = newIps.stream().filter(ip -> !exitIps.contains(ip)).collect(Collectors.toList()))) {
            expandIps.forEach(ip -> {
                this.milogAgentService.configIssueAgent("", (String)ip, "");
                this.milogStreamService.configIssueStream((String)ip);
            });
        }
        if (CollectionUtils.isNotEmpty(stopFileCollIps = exitIps.stream().filter(ip -> !newIps.contains(ip)).collect(Collectors.toList()))) {
            this.milogAgentService.delLogCollDirectoryByIp(tailId, ManagerUtil.getPhysicsDirectory(logPath), stopFileCollIps);
        }
    }

    private MilogLogTailDo logTailParam2Do(LogTailParam logTailParam, MilogLogStoreDO logStoreDO, AppBaseInfo appBaseInfo) {
        MilogLogTailDo milogLogtailDo = new MilogLogTailDo();
        milogLogtailDo.setId(logTailParam.getId());
        milogLogtailDo.setTail(logTailParam.getTail());
        milogLogtailDo.setSpaceId(logTailParam.getSpaceId());
        milogLogtailDo.setStoreId(logTailParam.getStoreId());
        milogLogtailDo.setMilogAppId(logTailParam.getMilogAppId());
        milogLogtailDo.setAppId(logTailParam.getMilogAppId());
        milogLogtailDo.setAppName(logTailParam.getAppName());
        if (null != appBaseInfo) {
            milogLogtailDo.setMilogAppId(logTailParam.getMilogAppId());
            milogLogtailDo.setAppId(Long.valueOf(appBaseInfo.getBindId()));
            milogLogtailDo.setAppName(appBaseInfo.getAppName());
        }
        milogLogtailDo.setEnvId(logTailParam.getEnvId());
        milogLogtailDo.setEnvName(logTailParam.getEnvName());
        milogLogtailDo.setMachineType(logTailParam.getMachineType());
        Integer appType = logTailParam.getAppType();
        milogLogtailDo.setAppType(appType);
        milogLogtailDo.setParseType(logTailParam.getParseType());
        milogLogtailDo.setParseScript(StringUtils.isEmpty((CharSequence)logTailParam.getParseScript()) ? "|" : logTailParam.getParseScript());
        milogLogtailDo.setLogPath(logTailParam.getLogPath().trim());
        milogLogtailDo.setLogSplitExpress(StringUtils.isNotEmpty((CharSequence)logTailParam.getLogSplitExpress()) ? logTailParam.getLogSplitExpress().trim() : "");
        milogLogtailDo.setValueList(logTailParam.getValueList());
        FilterDefine filterDefine = FilterDefine.consRateLimitFilterDefine((String)logTailParam.getTailRate());
        if (filterDefine != null) {
            milogLogtailDo.setFilter(Arrays.asList(filterDefine));
        }
        this.tailExtensionService.logTailDoExtraFiled(milogLogtailDo, logStoreDO, logTailParam);
        milogLogtailDo.setDeployWay(logTailParam.getDeployWay());
        if (logStoreDO.isPlatformResourceStore()) {
            milogLogtailDo.setDeploySpace(StringUtils.isNotEmpty((CharSequence)logTailParam.getDeploySpace()) ? logTailParam.getDeploySpace().trim() : "");
        }
        milogLogtailDo.setFirstLineReg(StringUtils.isNotEmpty((CharSequence)logTailParam.getFirstLineReg()) ? logTailParam.getFirstLineReg() : "");
        milogLogtailDo.setCollectionReady(logTailParam.getCollectionReady());
        return milogLogtailDo;
    }

    @Override
    public LogTailDTO milogLogtailDO2DTO(MilogLogTailDo milogLogtailDo) {
        if (milogLogtailDo == null) {
            return null;
        }
        LogTailDTO logTailDTO = new LogTailDTO();
        logTailDTO.setId(milogLogtailDo.getId());
        logTailDTO.setCtime(milogLogtailDo.getCtime());
        logTailDTO.setUtime(milogLogtailDo.getUtime());
        logTailDTO.setSpaceId(milogLogtailDo.getSpaceId());
        logTailDTO.setStoreId(milogLogtailDo.getStoreId());
        logTailDTO.setMilogAppId(milogLogtailDo.getMilogAppId());
        logTailDTO.setAppId(milogLogtailDo.getAppId());
        logTailDTO.setAppName(milogLogtailDo.getAppName());
        logTailDTO.setEnvId(milogLogtailDo.getEnvId());
        logTailDTO.setEnvName(milogLogtailDo.getEnvName());
        List<String> list = milogLogtailDo.getIps();
        if (CollectionUtils.isNotEmpty(list)) {
            logTailDTO.setIps(list);
        }
        logTailDTO.setTail(milogLogtailDo.getTail());
        logTailDTO.setParseType(milogLogtailDo.getParseType());
        logTailDTO.setParseScript(milogLogtailDo.getParseScript());
        logTailDTO.setLogPath(milogLogtailDo.getLogPath());
        logTailDTO.setLogSplitExpress(milogLogtailDo.getLogSplitExpress());
        logTailDTO.setValueList(milogLogtailDo.getValueList());
        logTailDTO.setAppType(milogLogtailDo.getAppType());
        logTailDTO.setMachineType(milogLogtailDo.getMachineType());
        logTailDTO.setMotorRooms(milogLogtailDo.getMotorRooms());
        logTailDTO.setTailRate(RateLimitEnum.consTailRate(milogLogtailDo.getFilter()));
        logTailDTO.setDeployWay(milogLogtailDo.getDeployWay());
        logTailDTO.setDeploySpace(milogLogtailDo.getDeploySpace());
        logTailDTO.setFirstLineReg(milogLogtailDo.getFirstLineReg());
        logTailDTO.setCollectionReady(milogLogtailDo.getCollectionReady());
        return logTailDTO;
    }

    @Override
    public Result<List<MapDTO>> queryAppByStoreId(Long storeId) {
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.queryAppIdByStoreId(storeId);
        if (CollectionUtils.isNotEmpty(milogLogtailDos)) {
            return Result.success(milogLogtailDos.stream().map(milogLogtailDo -> MapDTO.Of(milogLogtailDo.getAppName(), milogLogtailDo.getMilogAppId())).distinct().collect(Collectors.toList()));
        }
        return Result.success((Object)Lists.newArrayList());
    }

    @Override
    public Result<List<AppTypeTailDTO>> queryAppTailByStoreId(Long storeId) {
        if (null == storeId) {
            return Result.failParam((String)"The storeId cannot be empty");
        }
        ArrayList appTypeTailDTOS = Lists.newArrayList();
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.queryAppIdByStoreId(storeId);
        if (CollectionUtils.isNotEmpty(milogLogtailDos)) {
            Map<Integer, List<MilogLogTailDo>> appTypeMap = milogLogtailDos.stream().collect(Collectors.groupingBy(MilogLogTailDo::getAppType));
            MilogLogStoreDO milogLogstoreDO = this.logStoreDao.queryById(storeId);
            String nameEn = milogLogstoreDO.getMachineRoom();
            for (Map.Entry<Integer, List<MilogLogTailDo>> listEntry : appTypeMap.entrySet()) {
                AppTypeTailDTO appTypeTailDTO = new AppTypeTailDTO();
                appTypeTailDTO.setAppType(listEntry.getKey());
                appTypeTailDTO.setAppTypName(ProjectTypeEnum.queryTypeByCode((Integer)listEntry.getKey()));
                ArrayList tailAppList = Lists.newArrayList();
                AppTypeTailDTO.TailApp tailApp = new AppTypeTailDTO.TailApp();
                tailApp.setNameEn(nameEn);
                tailApp.setNameCn(CommonExtensionServiceFactory.getCommonExtensionService().getMachineRoomName(nameEn));
                List<MilogLogTailDo> logtailDos = listEntry.getValue();
                if (CollectionUtils.isNotEmpty(logtailDos)) {
                    List<AppTypeTailDTO.TailInfo> tailInfos = logtailDos.stream().map(milogLogtailDo -> {
                        AppTypeTailDTO.TailInfo tailInfo = new AppTypeTailDTO.TailInfo();
                        tailInfo.setId(milogLogtailDo.getId());
                        tailInfo.setTailName(milogLogtailDo.getTail());
                        return tailInfo;
                    }).collect(Collectors.toList());
                    tailApp.setTailInfos(tailInfos);
                }
                tailAppList.add(tailApp);
                appTypeTailDTO.setTailAppList(tailAppList);
                appTypeTailDTOS.add(appTypeTailDTO);
            }
        }
        return Result.success((Object)appTypeTailDTOS);
    }

    @Override
    public Result<List<MilogLogStoreDO>> queryLogStoreByRegionEn(String nameEn) {
        if (StringUtils.isEmpty((CharSequence)nameEn)) {
            return Result.failParam((String)"storeId Cannot be empty");
        }
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.queryStoreIdByRegionNameEN(nameEn);
        if (CollectionUtils.isNotEmpty(milogLogtailDos)) {
            return Result.success((Object)milogLogtailDos.stream().map(milogLogtailDo -> this.logStoreDao.queryById(milogLogtailDo.getStoreId())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MilogLogStoreDO>(Comparator.comparing(o -> o.getLogstoreName()))), ArrayList::new)));
        }
        return Result.success((Object)Lists.newArrayList());
    }

    @Override
    public Result<List<LogTailDTO>> getTailByStoreId(Long storeId) {
        if (storeId == null) {
            return Result.failParam((String)"storeId Cannot be empty");
        }
        List<MilogLogTailDo> tailList = this.milogLogtailDao.getMilogLogtailByStoreId(storeId);
        ArrayList<LogTailDTO> dtoList = new ArrayList<LogTailDTO>();
        for (MilogLogTailDo milogLogtailDo : tailList) {
            LogTailDTO logTailDTO = this.milogLogtailDO2DTO(milogLogtailDo);
            if (milogLogtailDo == null) continue;
            dtoList.add(logTailDTO);
        }
        return Result.success(dtoList);
    }

    @Override
    public Result<Object> parseScriptTest(MlogParseParam mlogParseParam) {
        String checkMsg = this.checkParseParam(mlogParseParam);
        if (StringUtils.isNotEmpty((CharSequence)checkMsg)) {
            return Result.failParam((String)checkMsg);
        }
        MilogLogStoreDO logstoreDO = this.logStoreDao.queryById(mlogParseParam.getStoreId());
        if (null == logstoreDO) {
            return Result.fail((Integer)CommonError.NOT_EXISTS_DATA.getCode(), (String)"logStore does not exist");
        }
        String keyList = Utils.parse2KeyAndTypeList(logstoreDO.getKeyList(), logstoreDO.getColumnTypeList());
        String valueList = IndexUtils.getNumberValueList((String)logstoreDO.getKeyList(), (String)mlogParseParam.getValueList());
        Long currentStamp = Instant.now().toEpochMilli();
        try {
            LogParser logParser = LogParserFactory.getLogParser((Integer)mlogParseParam.getParseType(), (String)keyList, (String)valueList, (String)mlogParseParam.getParseScript());
            Map parseMsg = logParser.parseSimple(mlogParseParam.getMsg(), currentStamp);
            return Result.success((Object)parseMsg);
        }
        catch (Exception e) {
            log.info("Parsing configuration information errors: Configuration information:{}", (Object)Constant.GSON.toJson((Object)mlogParseParam), (Object)e);
            return Result.success((Object)"Resolution error Please check the configuration information");
        }
    }

    public Result<Object> parseExample(MlogParseParam mlogParseParam) {
        String checkMsg = this.heraConfigValid.checkParseExampleParam(mlogParseParam);
        if (StringUtils.isNotEmpty((CharSequence)checkMsg)) {
            return Result.failParam((String)checkMsg);
        }
        try {
            LogParser logParser = LogParserFactory.getLogParser((Integer)mlogParseParam.getParseType(), (String)"", (String)"", (String)mlogParseParam.getParseScript());
            List parsedLog = logParser.parseLogData(mlogParseParam.getMsg());
            return Result.success((Object)parsedLog);
        }
        catch (Exception e) {
            log.info("Parsing configuration information errors: Configuration information:{}", (Object)Constant.GSON.toJson((Object)mlogParseParam), (Object)e);
            return Result.success((Object)"Resolution error Please check the configuration information");
        }
    }

    private String checkParseParam(MlogParseParam mlogParseParam) {
        StringBuilder sb = new StringBuilder();
        if (null == mlogParseParam.getStoreId()) {
            sb.append("store cannot be empty;");
        }
        if (null == mlogParseParam.getParseScript()) {
            sb.append("The parsing script cannot be empty;");
        }
        if (null == mlogParseParam.getValueList()) {
            sb.append("Indexing rules cannot be empty;");
        }
        if (null == mlogParseParam.getMsg()) {
            sb.append("Log information cannot be empty;");
        }
        return sb.toString();
    }

    @Override
    public Result<List<QuickQueryVO>> quickQueryByApp(Long milogAppId) {
        if (null == milogAppId) {
            return Result.failParam((String)"The milog App ID cannot be empty");
        }
        List<MilogLogTailDo> milogLogTailDos = this.milogLogtailDao.getLogTailByMilogAppId(milogAppId);
        List<Object> quickQueryVOS = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(milogLogTailDos)) {
            quickQueryVOS = milogLogTailDos.stream().map(this::applyQueryVO).collect(Collectors.toList());
            this.wrapStoreSpaceName(quickQueryVOS);
        }
        return Result.success((Object)quickQueryVOS);
    }

    private void wrapStoreSpaceName(List<QuickQueryVO> quickQueryVOS) {
        List<Long> storeIds = quickQueryVOS.stream().map(QuickQueryVO::getStoreId).collect(Collectors.toList());
        List<MilogLogStoreDO> milogLogStoreDOS = this.logStoreDao.queryByIds(storeIds);
        List<Long> spaceIds = quickQueryVOS.stream().map(QuickQueryVO::getSpaceId).collect(Collectors.toList());
        List<MilogSpaceDO> milogSpaceDOS = this.milogSpaceDao.queryByIds(spaceIds);
        quickQueryVOS.stream().map(quickQueryVO -> {
            milogLogStoreDOS.stream().filter(milogLogsSoreDO -> Objects.equals(quickQueryVO.getStoreId(), milogLogsSoreDO.getId())).findFirst().map(milogLogStoreDO -> {
                quickQueryVO.setStoreName(milogLogStoreDO.getLogstoreName());
                return true;
            });
            milogSpaceDOS.stream().filter(milogSpaceDO -> Objects.equals(quickQueryVO.getSpaceId(), milogSpaceDO.getId())).findFirst().map(milogSpaceDO -> {
                quickQueryVO.setSpaceName(milogSpaceDO.getSpaceName());
                return true;
            });
            return quickQueryVO;
        }).collect(Collectors.toList());
    }

    @Override
    public void machineIpChange(HeraEnvIpVo heraEnvIpVo) {
        List<MilogLogTailDo> logTailDos = this.milogLogtailDao.queryByMilogAppAndEnvId(heraEnvIpVo.getHeraAppId(), heraEnvIpVo.getId());
        if (CollectionUtils.isNotEmpty(logTailDos)) {
            log.info("Dynamically expand the configuration in the current environment\uff0cheraAppEnvVo:{}\uff0clogTailDos:{}", (Object)Constant.GSON.toJson((Object)heraEnvIpVo), (Object)Constant.GSON.toJson(logTailDos));
            for (MilogLogTailDo milogLogtailDo : logTailDos) {
                List newIps;
                List<String> exitIps = milogLogtailDo.getIps();
                if (CollectionUtils.isEqualCollection(exitIps, (Collection)(newIps = heraEnvIpVo.getIpList()))) continue;
                milogLogtailDo.setIps(newIps);
                milogLogtailDo.setUtime(Instant.now().toEpochMilli());
                milogLogtailDo.setUpdater("job");
                this.milogLogtailDao.updateIps(milogLogtailDo);
                this.compareIpToHandle(milogLogtailDo.getId(), milogLogtailDo.getLogPath(), exitIps, newIps);
            }
        }
    }

    @Override
    public Result<QuickQueryVO> queryAppStore(Long appId, Integer platFormCode) {
        if (null == appId || null == platFormCode) {
            return Result.failParam((String)"The parameter cannot be empty");
        }
        AppBaseInfo appBaseInfo = this.heraAppService.queryByAppIdPlatFormType(appId.toString(), platFormCode);
        if (null == appBaseInfo) {
            log.info("queryAppStore app not exist,milogAppId:{},platFormCode:{}", (Object)appId, (Object)platFormCode);
            return Result.success((Object)new QuickQueryVO());
        }
        List<MilogLogTailDo> logTailDos = this.milogLogtailDao.queryByAppId(appId, appBaseInfo.getId().longValue());
        if (CollectionUtils.isEmpty(logTailDos)) {
            return Result.success((Object)new QuickQueryVO());
        }
        return Result.success((Object)this.applyQueryVO(logTailDos.get(logTailDos.size() - 1), null));
    }
}

