/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common.validation;

import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.model.bo.LogTailParam;
import org.apache.ozhera.log.manager.model.bo.MlogParseParam;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.service.extension.agent.MilogAgentService;
import org.apache.ozhera.log.manager.service.extension.agent.MilogAgentServiceFactory;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionService;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionService;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionService;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionServiceFactory;
import org.apache.ozhera.log.parse.LogParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class HeraConfigValid {
    private static final Logger log = LoggerFactory.getLogger(HeraConfigValid.class);
    @Value(value="$server.type")
    private String serverType;
    @Resource
    private MilogLogstoreDao milogLogstoreDao;
    @Resource
    private MilogLogTailDao milogLogtailDao;
    private TailExtensionService tailExtensionService;
    private MilogAgentService milogAgentService;
    private StoreExtensionService storeExtensionService;
    private ResourceExtensionService resourceExtensionService;

    public void init() {
        this.tailExtensionService = TailExtensionServiceFactory.getTailExtensionService();
        this.milogAgentService = MilogAgentServiceFactory.getAgentExtensionService();
        this.storeExtensionService = StoreExtensionServiceFactory.getStoreExtensionService();
        this.resourceExtensionService = ResourceExtensionServiceFactory.getResourceExtensionService();
    }

    public String verifyLogTailParam(LogTailParam param) {
        if (null == param.getMilogAppId()) {
            return "The selected app cannot be empty";
        }
        if (null == param || StringUtils.isBlank((CharSequence)param.getLogPath())) {
            return "The path cannot be empty";
        }
        if (null == param.getSpaceId()) {
            return "The space ID cannot be empty";
        }
        if (null == param.getStoreId()) {
            return "The store ID cannot be empty";
        }
        String path = param.getLogPath();
        if (path.equals("/home/work/log/") || path.equals("/home/work/log") || path.startsWith("/home/work/log") && path.split("/").length < 4) {
            return "The log path is wrong, please confirm and submit";
        }
        String validMsg = this.tailExtensionService.validLogPath(param);
        return StringUtils.isNotEmpty((CharSequence)validMsg) ? validMsg : "";
    }

    public String checkParseExampleParam(MlogParseParam mlogParseParam) {
        StringBuilder sb = new StringBuilder();
        if (!(LogParserFactory.LogParserEnum.JSON_PARSE.getCode().equals(mlogParseParam.getParseType()) || null != mlogParseParam.getParseScript() && "" != mlogParseParam.getParseScript())) {
            sb.append("The parsing script cannot be empty;");
        }
        if (null == mlogParseParam.getMsg()) {
            sb.append("Log information cannot be empty;");
        }
        return sb.toString();
    }

    public boolean checkTailNameSame(String tailName, Long id, String machineRoom, Long spaceId) {
        List<MilogLogTailDo> logtailDoList = this.milogLogtailDao.queryTailNameExists(tailName, machineRoom, spaceId);
        if (null == id) {
            return CollectionUtils.isNotEmpty(logtailDoList);
        }
        if (CollectionUtils.isEmpty(logtailDoList)) {
            return false;
        }
        MilogLogTailDo milogLogtailDo = logtailDoList.get(logtailDoList.size() - 1);
        return !milogLogtailDo.getId().equals(id);
    }
}

