/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.prometheus.JobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ScrapeJobController {
    private static final Logger log = LoggerFactory.getLogger(ScrapeJobController.class);
    @Autowired
    JobService jobService;
    private final Gson gson = new Gson();
    @NacosValue(value="${grafana.backend.users}", autoRefreshed=true)
    private String grafanaBackendUsers;

    @PostMapping(value={"/mimonitor/createScrapeJob"})
    public Result createScrapeJob(HttpServletRequest request, String jobDesc, @RequestBody String body) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (StringUtils.isNotEmpty((CharSequence)body)) {
            return this.jobService.createJob(null, user, body, jobDesc);
        }
        return Result.fail((ErrorCode)ErrorCode.RequestBodyIsEmpty);
    }

    @GetMapping(value={"/mimonitor/searchScrapeJob"})
    public Result searchScrapeJob(HttpServletRequest request, Integer id) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (id != null && id != 0) {
            return this.jobService.searchJob(null, user, id.intValue());
        }
        return Result.fail((ErrorCode)ErrorCode.ScrapeIdIsEmpty);
    }

    @PostMapping(value={"/mimonitor/deleteScrapeJob"})
    public Result deleteScrapeJob(HttpServletRequest request, @RequestBody String body) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(body, JsonObject.class);
        Integer primaryId = jsonObject.get("primaryId").getAsInt();
        if (primaryId != null && primaryId != 0) {
            return this.jobService.deleteJob(null, user, primaryId.intValue());
        }
        return Result.fail((ErrorCode)ErrorCode.invalidParamError);
    }

    @PostMapping(value={"/mimonitor/updateScrapeJob"})
    public Result updateScrapeJob(HttpServletRequest request, String jobDesc, Integer primaryId, @RequestBody String body) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (primaryId != null && primaryId != 0 && StringUtils.isNotEmpty((CharSequence)body)) {
            return this.jobService.updateJob(null, user, body, primaryId.intValue(), jobDesc);
        }
        return Result.fail((ErrorCode)ErrorCode.invalidParamError);
    }

    @GetMapping(value={"/mimonitor/searchScrapeJobList"})
    public Result searchScrapeJobList(HttpServletRequest request, Integer pageSize, Integer page) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        if (page == 0) {
            page = 1;
        }
        return this.jobService.searchJobList(null, user, pageSize, page);
    }

    public String checkUser(HttpServletRequest request) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            return "";
        }
        String user = userInfo.genFullAccount();
        log.info("ScrapeJobController checkUser user:{}", (Object)user);
        if (Arrays.stream(this.grafanaBackendUsers.split(",")).collect(Collectors.toList()).contains(user)) {
            return user;
        }
        return "";
    }
}

