/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.google.common.collect.Lists;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.aop.HeraRequestMapping;
import org.apache.ozhera.monitor.bo.AlarmStrategyInfo;
import org.apache.ozhera.monitor.bo.AlarmStrategyParam;
import org.apache.ozhera.monitor.bo.AlarmStrategyType;
import org.apache.ozhera.monitor.bo.InterfaceNameEnum;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlarmStrategyService;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionStrategyDelete;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionStrategyEnable;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.user.UserConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alarm/strategy"})
public class AlarmStrategyController {
    private static final Logger log = LoggerFactory.getLogger(AlarmStrategyController.class);
    @Autowired
    private AlarmStrategyService alarmStrategyService;
    @Autowired
    UserConfigService userConfigService;

    @RequestMapping(value={"/type_list"})
    public Result typeList(HttpServletRequest request, @RequestBody AlarmStrategyParam param) {
        if (param.isTemplateNeed()) {
            return Result.success((Object)AlarmStrategyType.getTemplateStrategyTypeList());
        }
        if (param.isRuleNeed()) {
            return Result.success((Object)AlarmStrategyType.getRuleStrategyTypeList());
        }
        return Result.success(null);
    }

    @HeraRequestMapping(value={"/enabled"}, interfaceName=InterfaceNameEnum.STRATEGY_ENABLE, actionClass=HeraRequestMappingActionStrategyEnable.class)
    public Result enabled(HttpServletRequest request, @RequestBody AlarmStrategyParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlarmStrategyController.enabled param : {} ", (Object)param);
            if (param.getId() <= 0 || param.getStatus() != 0 && param.getStatus() != 1) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmStrategyController.enabled request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmStrategyController.enabled param : {} ,user : {}", (Object)param, (Object)user);
            return this.alarmStrategyService.enabled(user, param);
        }
        catch (Exception e) {
            log.error("AlarmStrategyController.enabled exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @HeraRequestMapping(value={"/deleteById"}, interfaceName=InterfaceNameEnum.STRATEGY_DELETE, actionClass=HeraRequestMappingActionStrategyDelete.class)
    public Result deleteById(HttpServletRequest request, @RequestBody AlarmStrategyParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlarmStrategyController.deleteById param : {} ", (Object)param);
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmStrategyController.deleteById request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmStrategyController.deleteById param : {} ,user : {}", (Object)param, (Object)user);
            if (param.getIds() == null) {
                param.setIds((List)Lists.newArrayList());
            }
            if (param.getId() != null && !param.getIds().contains(param.getId())) {
                param.getIds().add(param.getId());
            }
            return this.alarmStrategyService.batchDeleteStrategy(user, param.getIds());
        }
        catch (Exception e) {
            log.error("AlarmStrategyController.deleteById exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @GetMapping(value={"/deleteByStrategyId"})
    public Result deleteByStrategyId(HttpServletRequest request, Integer strategyId) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlarmStrategyController.deleteByStrategyId strategyId : {} ", (Object)strategyId);
            if (strategyId <= 0) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmStrategyController.deleteByStrategyId request info error no user info found! strategyId : {} ", (Object)strategyId);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            if (!this.userConfigService.isSuperAdmin(userInfo.genFullAccount())) {
                return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmStrategyController.deleteByStrategyId strategyId : {} ,user : {}", (Object)strategyId, (Object)user);
            return this.alarmStrategyService.deleteByStrategyId(user, strategyId);
        }
        catch (Exception e) {
            log.error("AlarmStrategyController.deleteByStrategyId exception! strategyId : {} ,userInfo :{}", new Object[]{strategyId, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/detailed"})
    public Result<AlarmStrategyInfo> detailed(HttpServletRequest request, @RequestBody AlarmStrategyParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlarmStrategyController.detailed param : {} ", (Object)param);
            if (param.getId() <= 0) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmStrategyController.detailed request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmStrategyController.detailed param : {} ,user : {}", (Object)param, (Object)user);
            return this.alarmStrategyService.detailed(user, param);
        }
        catch (Exception e) {
            log.error("AlarmStrategyController.detailed exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/search"})
    public Result<PageData<List<AlarmStrategyInfo>>> search(HttpServletRequest request, @RequestBody AlarmStrategyParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlarmStrategyController.search param : {} ", (Object)param);
            param.pageQryInit();
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmStrategyController.search request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            Result result = this.alarmStrategyService.search(user, param);
            log.info("AlarmStrategyController.search param : {} ,user : {},result:{}", new Object[]{param, user, result});
            return result;
        }
        catch (Exception e) {
            log.error("AlarmStrategyController.search exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/dubbo_search"})
    public Result<PageData> dubboSearch(HttpServletRequest request, @RequestBody AlarmStrategyParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlarmStrategyController.dubboSearch param : {} ", (Object)param);
            if (StringUtils.isBlank((CharSequence)param.getAppName()) || param.getAppId() == null) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            param.pageQryInit();
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmStrategyController.dubboSearch request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmStrategyController.dubboSearch param : {} ,user : {}", (Object)param, (Object)user);
            return this.alarmStrategyService.dubboSearch(user, param);
        }
        catch (Exception e) {
            log.error("AlarmStrategyController.dubboSearch exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }
}

