/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.recovery;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.Utils$;
import org.apache.livy.server.recovery.StateStore;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\n\u0015\u0001}A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)1\b\u0001C\u0001y!)1\b\u0001C\u0001\u0001\"9a\u0007\u0001b\u0001\n\u0013\u0011\u0005B\u0002$\u0001A\u0003%1\tC\u0004H\u0001\t\u0007I\u0011\u0002%\t\rE\u0003\u0001\u0015!\u0003J\u0011\u001d\u0011\u0006A1A\u0005\nMCa\u0001\u0016\u0001!\u0002\u0013\u0019\u0004\"B+\u0001\t\u00032\u0006\"B8\u0001\t\u0003\u0002\bbBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002<\u0001!\t!!\u0012\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z\t!b)\u001b7f'f\u001cH/Z7Ti\u0006$Xm\u0015;pe\u0016T!!\u0006\f\u0002\u0011I,7m\u001c<fefT!a\u0006\r\u0002\rM,'O^3s\u0015\tI\"$\u0001\u0003mSZL(BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001A\u0011\u0002\"!\t\u0012\u000e\u0003QI!a\t\u000b\u0003\u0015M#\u0018\r^3Ti>\u0014X\r\u0005\u0002&M5\t\u0001$\u0003\u0002(1\t9Aj\\4hS:<\u0017\u0001\u00037jmf\u001cuN\u001c4\u0011\u0005\u0015R\u0013BA\u0016\u0019\u0005!a\u0015N^=D_:4\u0017aD7pG.4\u0015\u000e\\3D_:$X\r\u001f;\u0011\u00079\n4'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019y\u0005\u000f^5p]B\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0003MNT!\u0001\u000f\u000e\u0002\r!\fGm\\8q\u0013\tQTGA\u0006GS2,7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002>}}\u0002\"!\t\u0001\t\u000b!\u001a\u0001\u0019A\u0015\t\u000b1\u001a\u0001\u0019A\u0017\u0015\u0005u\n\u0005\"\u0002\u0015\u0005\u0001\u0004IS#A\"\u0011\u0005Q\"\u0015BA#6\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\u0004MN\u0004\u0013!\u00024t+JLW#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015a\u00018fi*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\r)&+S\u0001\u0007MN,&/\u001b\u0011\u0002\u0017\u0019LG.Z\"p]R,\u0007\u0010^\u000b\u0002g\u0005aa-\u001b7f\u0007>tG/\u001a=uA\u0005\u00191/\u001a;\u0015\u0007]Sv\r\u0005\u0002/1&\u0011\u0011l\f\u0002\u0005+:LG\u000fC\u0003\\\u0017\u0001\u0007A,A\u0002lKf\u0004\"!\u00183\u000f\u0005y\u0013\u0007CA00\u001b\u0005\u0001'BA1\u001f\u0003\u0019a$o\\8u}%\u00111mL\u0001\u0007!J,G-\u001a4\n\u0005\u00154'AB*ue&twM\u0003\u0002d_!)\u0001n\u0003a\u0001S\u0006)a/\u00197vKB\u0011!.\\\u0007\u0002W*\u0011A.T\u0001\u0005Y\u0006tw-\u0003\u0002oW\n1qJ\u00196fGR\f1aZ3u+\t\th\u000fF\u0002s\u0003\u001f!\"a]@\u0011\u00079\nD\u000f\u0005\u0002vm2\u0001A!B<\r\u0005\u0004A(!\u0001+\u0012\u0005ed\bC\u0001\u0018{\u0013\tYxFA\u0004O_RD\u0017N\\4\u0011\u00059j\u0018B\u0001@0\u0005\r\te.\u001f\u0005\n\u0003\u0003a\u0011\u0011!a\u0002\u0003\u0007\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0015\t)!a\u0003u\u001b\t\t9AC\u0002\u0002\n=\nqA]3gY\u0016\u001cG/\u0003\u0003\u0002\u000e\u0005\u001d!\u0001C\"mCN\u001cH+Y4\t\u000bmc\u0001\u0019\u0001/\u0002\u0017\u001d,Go\u00115jY\u0012\u0014XM\u001c\u000b\u0005\u0003+\t9\u0003E\u0003\u0002\u0018\u0005\u0005BL\u0004\u0003\u0002\u001a\u0005uabA0\u0002\u001c%\t\u0001'C\u0002\u0002 =\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0005\u0015\"aA*fc*\u0019\u0011qD\u0018\t\u000bmk\u0001\u0019\u0001/\u0002\rI,Wn\u001c<f)\r9\u0016Q\u0006\u0005\u00067:\u0001\r\u0001X\u0001\bC\n\u001c\b+\u0019;i)\u0011\t\u0019$!\u000f\u0011\u0007Q\n)$C\u0002\u00028U\u0012A\u0001U1uQ\")1l\u0004a\u00019\u0006q\u0011n\u001d$t\u0013:\u001c\u0016MZ3N_\u0012,GCAA !\rq\u0013\u0011I\u0005\u0004\u0003\u0007z#a\u0002\"p_2,\u0017M\u001c\u000b\u0005\u0003\u007f\t9\u0005C\u0004\u0002JE\u0001\r!a\u0013\u0002\u0007\u001147\u000f\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tfN\u0001\u0005Q\u001247/\u0003\u0003\u0002V\u0005=#!\u0006#jgR\u0014\u0018NY;uK\u00124\u0015\u000e\\3TsN$X-\\\u0001\u0013gR\f'\u000f^*bM\u0016lu\u000eZ3DQ\u0016\u001c7\u000eF\u0001X\u0001")
public class FileSystemStateStore
extends StateStore
implements Logging {
    private final LivyConf livyConf;
    private final FileSystem fs;
    private final URI fsUri;
    private final FileContext fileContext;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FileSystemStateStore fileSystemStateStore = this;
        synchronized (fileSystemStateStore) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private URI fsUri() {
        return this.fsUri;
    }

    private FileContext fileContext() {
        return this.fileContext;
    }

    @Override
    public void set(String key, Object value) {
        Path tmpPath = this.absPath(new StringBuilder(4).append(key).append(".tmp").toString());
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        Utils$.MODULE$.usingResource((Closeable)this.fileContext().create(tmpPath, createFlag, new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1 & Serializable & scala.Serializable)tmpFile -> {
            FileSystemStateStore.$anonfun$set$1(this, value, tmpPath, key, tmpFile);
            return BoxedUnit.UNIT;
        });
        try {
            Path crcPath = new Path(tmpPath.getParent(), new StringBuilder(5).append(".").append(tmpPath.getName()).append(".crc").toString());
            this.fileContext().delete(crcPath, false);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
            }
            throw throwable;
        }
    }

    @Override
    public <T> Option<T> get(String key, ClassTag<T> evidence$1) {
        None$ none$;
        try {
            none$ = (Option)Utils$.MODULE$.usingResource((Closeable)this.fileContext().open(this.absPath(key)), (Function1 & Serializable & scala.Serializable)is -> Option$.MODULE$.apply(this.deserialize(IOUtils.toByteArray((InputStream)is), evidence$1)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            none$ = None$.MODULE$;
        }
        catch (IOException e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to read ").append(key).append(" from state store.").toString(), e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Seq<String> getChildren(String key) {
        Seq seq;
        try {
            seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileContext().util().listStatus(this.absPath(key)))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().getName(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            seq = (Seq)Nil$.MODULE$;
        }
        catch (IOException e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to list ").append(key).append(" from state store.").toString(), e);
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    @Override
    public void remove(String key) {
        try {
            this.fileContext().delete(this.absPath(key), false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Failed to remove non-existed file: ").append(key).toString());
        }
    }

    private Path absPath(String key) {
        return new Path(this.fsUri().getPath(), key);
    }

    public boolean isFsInSafeMode() {
        FileSystem fileSystem = this.fs();
        if (fileSystem instanceof DistributedFileSystem) {
            DistributedFileSystem distributedFileSystem = (DistributedFileSystem)fileSystem;
            return this.isFsInSafeMode(distributedFileSystem);
        }
        return false;
    }

    public boolean isFsInSafeMode(DistributedFileSystem dfs) {
        return dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
    }

    public void startSafeModeCheck() {
        int safeModeInterval = this.livyConf.getInt(LivyConf$.MODULE$.HDFS_SAFE_MODE_INTERVAL_IN_SECONDS());
        int safeModeMaxRetryAttempts = this.livyConf.getInt(LivyConf$.MODULE$.HDFS_SAFE_MODE_MAX_RETRY_ATTEMPTS());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), safeModeMaxRetryAttempts).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)retryAttempts -> this.isFsInSafeMode()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)retryAttempts -> {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "HDFS is still in safe mode. Waiting...");
            Thread.sleep(TimeUnit.SECONDS.toMillis(safeModeInterval));
        });
        if (this.isFsInSafeMode()) {
            throw new IllegalStateException("Reached max retry attempts for safe mode check in hdfs file system");
        }
    }

    public static final /* synthetic */ void $anonfun$set$1(FileSystemStateStore $this, Object value$1, Path tmpPath$1, String key$1, FSDataOutputStream tmpFile) {
        tmpFile.write($this.serializeToBytes(value$1));
        tmpFile.close();
        $this.fileContext().rename(tmpPath$1, $this.absPath(key$1), new Options.Rename[]{Options.Rename.OVERWRITE});
    }

    public FileSystemStateStore(LivyConf livyConf, Option<FileContext> mockFileContext) {
        block4: {
            block3: {
                this.livyConf = livyConf;
                super(livyConf);
                Logging.$init$((Logging)this);
                this.fs = FileSystem.newInstance((Configuration)livyConf.hadoopConf());
                String fsPath = livyConf.get(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL());
                Predef$.MODULE$.require(fsPath != null && !fsPath.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Please config ").append(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL().key()).append(".").toString());
                this.fsUri = new URI(fsPath);
                this.fileContext = (FileContext)mockFileContext.getOrElse((Function0 & Serializable & scala.Serializable)() -> FileContext.getFileContext((URI)this.fsUri()));
                this.fileContext().setUMask(new FsPermission("077"));
                this.startSafeModeCheck();
                Path stateStorePath = this.absPath(".");
                try {
                    this.fileContext().mkdir(stateStorePath, FsPermission.getDirDefault(), true);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    if (this.fileContext().getFileStatus(stateStorePath).isDirectory()) break block3;
                    throw new IOException(new StringBuilder(20).append(stateStorePath).append(" is not a directory.").toString());
                }
            }
            FileStatus fileStatus = this.fileContext().getFileStatus(this.absPath("."));
            FsAction fsAction = fileStatus.getPermission().getUserAction();
            FsAction fsAction2 = FsAction.ALL;
            Predef$.MODULE$.require(!(fsAction != null ? !fsAction.equals(fsAction2) : fsAction2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Livy doesn't have permission to access state store: ").append(this.fsUri()).append(".").toString());
            FsAction fsAction3 = fileStatus.getPermission().getGroupAction();
            FsAction fsAction4 = FsAction.NONE;
            if (fsAction3 == null ? fsAction4 != null : !fsAction3.equals(fsAction4)) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Group users have permission to access state store: ").append(this.fsUri()).append(". This is insecure.").toString());
            }
            FsAction fsAction5 = fileStatus.getPermission().getOtherAction();
            FsAction fsAction6 = FsAction.NONE;
            if (!(fsAction5 == null ? fsAction6 != null : !fsAction5.equals(fsAction6))) break block4;
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Other users have permission to access state store: ").append(this.fsUri()).append(". This is in secure.").toString());
        }
    }

    public FileSystemStateStore(LivyConf livyConf) {
        this(livyConf, (Option<FileContext>)None$.MODULE$);
    }
}

