/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.ModelVersionMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.ModelVersionMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.ModelVersionPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class ModelVersionMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, ModelVersionMetaBaseSQLProvider> MODEL_VERSION_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new ModelVersionMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new ModelVersionMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new ModelVersionMetaPostgreSQLProvider());

    public static ModelVersionMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return MODEL_VERSION_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertModelVersionMeta(@Param(value="modelVersionMeta") ModelVersionPO modelVersionPO) {
        return ModelVersionMetaSQLProviderFactory.getProvider().insertModelVersionMeta(modelVersionPO);
    }

    public static String listModelVersionMetasByModelId(@Param(value="modelId") Long modelId) {
        return ModelVersionMetaSQLProviderFactory.getProvider().listModelVersionMetasByModelId(modelId);
    }

    public static String selectModelVersionMeta(@Param(value="modelId") Long modelId, @Param(value="modelVersion") Integer modelVersion) {
        return ModelVersionMetaSQLProviderFactory.getProvider().selectModelVersionMeta(modelId, modelVersion);
    }

    public static String selectModelVersionMetaByAlias(@Param(value="modelId") Long modelId, @Param(value="alias") String alias) {
        return ModelVersionMetaSQLProviderFactory.getProvider().selectModelVersionMetaByAlias(modelId, alias);
    }

    public static String softDeleteModelVersionsBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return ModelVersionMetaSQLProviderFactory.getProvider().softDeleteModelVersionsBySchemaIdAndModelName(schemaId, modelName);
    }

    public static String softDeleteModelVersionMetaByModelIdAndVersion(@Param(value="modelId") Long modelId, @Param(value="modelVersion") Integer modelVersion) {
        return ModelVersionMetaSQLProviderFactory.getProvider().softDeleteModelVersionMetaByModelIdAndVersion(modelId, modelVersion);
    }

    public static String softDeleteModelVersionMetaByModelIdAndAlias(@Param(value="modelId") Long modelId, @Param(value="alias") String alias) {
        return ModelVersionMetaSQLProviderFactory.getProvider().softDeleteModelVersionMetaByModelIdAndAlias(modelId, alias);
    }

    public static String softDeleteModelVersionMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return ModelVersionMetaSQLProviderFactory.getProvider().softDeleteModelVersionMetasBySchemaId(schemaId);
    }

    public static String softDeleteModelVersionMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return ModelVersionMetaSQLProviderFactory.getProvider().softDeleteModelVersionMetasByCatalogId(catalogId);
    }

    public static String softDeleteModelVersionMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return ModelVersionMetaSQLProviderFactory.getProvider().softDeleteModelVersionMetasByMetalakeId(metalakeId);
    }

    public static String deleteModelVersionMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return ModelVersionMetaSQLProviderFactory.getProvider().deleteModelVersionMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class ModelVersionMetaH2Provider
    extends ModelVersionMetaBaseSQLProvider {
        ModelVersionMetaH2Provider() {
        }
    }

    static class ModelVersionMetaMySQLProvider
    extends ModelVersionMetaBaseSQLProvider {
        ModelVersionMetaMySQLProvider() {
        }
    }
}

