/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.ops;

import com.google.common.base.Preconditions;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergCatalogBackend;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.utils.IcebergCatalogUtil;
import org.apache.gravitino.utils.IsolatedClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.rest.CatalogHandlers;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogWrapper
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(IcebergCatalogWrapper.class);
    protected Catalog catalog;
    private SupportsNamespaces asNamespaceCatalog;
    private final IcebergCatalogBackend catalogBackend;
    private String catalogUri = null;
    private Map<String, String> catalogPropertiesMap;

    public IcebergCatalogWrapper(IcebergConfig icebergConfig) {
        this.catalogBackend = IcebergCatalogBackend.valueOf((String)((String)icebergConfig.get(IcebergConfig.CATALOG_BACKEND)).toUpperCase(Locale.ROOT));
        if (!IcebergCatalogBackend.MEMORY.equals((Object)this.catalogBackend) && !IcebergCatalogBackend.REST.equals((Object)this.catalogBackend) && StringUtils.isBlank((CharSequence)((CharSequence)icebergConfig.get(IcebergConfig.CATALOG_WAREHOUSE)))) {
            throw new IllegalArgumentException("The 'warehouse' parameter must have a value.");
        }
        if (!IcebergCatalogBackend.MEMORY.equals((Object)this.catalogBackend)) {
            this.catalogUri = (String)icebergConfig.get(IcebergConfig.CATALOG_URI);
        }
        this.catalog = IcebergCatalogUtil.loadCatalogBackend(this.catalogBackend, icebergConfig);
        if (this.catalog instanceof SupportsNamespaces) {
            this.asNamespaceCatalog = (SupportsNamespaces)this.catalog;
        }
        this.catalogPropertiesMap = icebergConfig.getIcebergCatalogProperties();
    }

    private void validateNamespace(Optional<Namespace> namespace) {
        namespace.ifPresent(n -> Preconditions.checkArgument((!n.toString().isEmpty() ? 1 : 0) != 0, (Object)"Namespace couldn't be empty"));
        if (this.asNamespaceCatalog == null) {
            throw new UnsupportedOperationException("The underlying catalog doesn't support namespace operation");
        }
    }

    private ViewCatalog getViewCatalog() {
        if (!(this.catalog instanceof ViewCatalog)) {
            throw new UnsupportedOperationException(this.catalog.name() + " is not support view");
        }
        return (ViewCatalog)this.catalog;
    }

    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        this.validateNamespace(Optional.of(request.namespace()));
        return CatalogHandlers.createNamespace((SupportsNamespaces)this.asNamespaceCatalog, (CreateNamespaceRequest)request);
    }

    public void dropNamespace(Namespace namespace) {
        this.validateNamespace(Optional.of(namespace));
        CatalogHandlers.dropNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace);
    }

    public GetNamespaceResponse loadNamespace(Namespace namespace) {
        this.validateNamespace(Optional.of(namespace));
        return CatalogHandlers.loadNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace);
    }

    public boolean namespaceExists(Namespace namespace) {
        this.validateNamespace(Optional.of(namespace));
        return this.asNamespaceCatalog.namespaceExists(namespace);
    }

    public ListNamespacesResponse listNamespace(Namespace parent) {
        this.validateNamespace(Optional.empty());
        return CatalogHandlers.listNamespaces((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)parent);
    }

    public UpdateNamespacePropertiesResponse updateNamespaceProperties(Namespace namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest) {
        this.validateNamespace(Optional.of(namespace));
        return CatalogHandlers.updateNamespaceProperties((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace, (UpdateNamespacePropertiesRequest)updateNamespacePropertiesRequest);
    }

    public LoadTableResponse registerTable(Namespace namespace, RegisterTableRequest request) {
        return CatalogHandlers.registerTable((Catalog)this.catalog, (Namespace)namespace, (RegisterTableRequest)request);
    }

    public void reloadHadoopConf() {
        Configuration configuration = new Configuration();
        this.catalogPropertiesMap.forEach((arg_0, arg_1) -> ((Configuration)configuration).set(arg_0, arg_1));
        UserGroupInformation.setConfiguration((Configuration)configuration);
    }

    public LoadTableResponse createTable(Namespace namespace, CreateTableRequest request) {
        request.validate();
        if (request.stageCreate()) {
            return this.injectTableConfig(() -> CatalogHandlers.stageTableCreate((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
        }
        return this.injectTableConfig(() -> CatalogHandlers.createTable((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
    }

    public void dropTable(TableIdentifier tableIdentifier) {
        CatalogHandlers.dropTable((Catalog)this.catalog, (TableIdentifier)tableIdentifier);
    }

    public void purgeTable(TableIdentifier tableIdentifier) {
        CatalogHandlers.purgeTable((Catalog)this.catalog, (TableIdentifier)tableIdentifier);
    }

    public LoadTableResponse loadTable(TableIdentifier tableIdentifier) {
        return this.injectTableConfig(() -> CatalogHandlers.loadTable((Catalog)this.catalog, (TableIdentifier)tableIdentifier));
    }

    public boolean tableExists(TableIdentifier tableIdentifier) {
        return this.catalog.tableExists(tableIdentifier);
    }

    public ListTablesResponse listTable(Namespace namespace) {
        return CatalogHandlers.listTables((Catalog)this.catalog, (Namespace)namespace);
    }

    public void renameTable(RenameTableRequest renameTableRequest) {
        CatalogHandlers.renameTable((Catalog)this.catalog, (RenameTableRequest)renameTableRequest);
    }

    public LoadTableResponse updateTable(TableIdentifier tableIdentifier, UpdateTableRequest updateTableRequest) {
        return CatalogHandlers.updateTable((Catalog)this.catalog, (TableIdentifier)tableIdentifier, (UpdateTableRequest)updateTableRequest);
    }

    public LoadTableResponse updateTable(IcebergTableChange icebergTableChange) {
        Transaction transaction = icebergTableChange.getTransaction();
        transaction.commitTransaction();
        return this.loadTable(icebergTableChange.getTableIdentifier());
    }

    public LoadViewResponse createView(Namespace namespace, CreateViewRequest request) {
        request.validate();
        return CatalogHandlers.createView((ViewCatalog)this.getViewCatalog(), (Namespace)namespace, (CreateViewRequest)request);
    }

    public LoadViewResponse updateView(TableIdentifier viewIdentifier, UpdateTableRequest request) {
        request.validate();
        return CatalogHandlers.updateView((ViewCatalog)this.getViewCatalog(), (TableIdentifier)viewIdentifier, (UpdateTableRequest)request);
    }

    public LoadViewResponse loadView(TableIdentifier viewIdentifier) {
        return CatalogHandlers.loadView((ViewCatalog)this.getViewCatalog(), (TableIdentifier)viewIdentifier);
    }

    public void dropView(TableIdentifier viewIdentifier) {
        CatalogHandlers.dropView((ViewCatalog)this.getViewCatalog(), (TableIdentifier)viewIdentifier);
    }

    public void renameView(RenameTableRequest request) {
        request.validate();
        CatalogHandlers.renameView((ViewCatalog)this.getViewCatalog(), (RenameTableRequest)request);
    }

    public boolean viewExists(TableIdentifier viewIdentifier) {
        return this.getViewCatalog().viewExists(viewIdentifier);
    }

    public ListTablesResponse listView(Namespace namespace) {
        return CatalogHandlers.listViews((ViewCatalog)this.getViewCatalog(), (Namespace)namespace);
    }

    @Override
    public void close() throws Exception {
        if (this.catalog instanceof AutoCloseable) {
            ((AutoCloseable)this.catalog).close();
        }
        if (this.catalogUri != null && this.catalogUri.contains("mysql")) {
            this.closeMySQLCatalogResource();
        } else if (this.catalogUri != null && this.catalogUri.contains("postgresql")) {
            this.closePostgreSQLCatalogResource();
        } else if (this.catalogBackend.equals((Object)IcebergCatalogBackend.HIVE)) {
            // empty if block
        }
    }

    private void closeMySQLCatalogResource() {
        try {
            Class.forName("com.mysql.cj.jdbc.AbandonedConnectionCleanupThread").getMethod("uncheckedShutdown", new Class[0]).invoke(null, new Object[0]);
            LOG.info("AbandonedConnectionCleanupThread has been shutdown...");
            this.closeDriverLoadedByIsolatedClassLoader(this.catalogUri);
        }
        catch (Exception e) {
            LOG.warn("Failed to shutdown AbandonedConnectionCleanupThread or deregister MySQL driver", (Throwable)e);
        }
    }

    private void closeDriverLoadedByIsolatedClassLoader(String uri) {
        try {
            Driver driver = DriverManager.getDriver(uri);
            if (driver.getClass().getClassLoader().getClass() == IsolatedClassLoader.CUSTOM_CLASS_LOADER_CLASS) {
                DriverManager.deregisterDriver(driver);
                LOG.info("Driver {} has been deregistered...", (Object)driver);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to deregister driver", (Throwable)e);
        }
    }

    private void closePostgreSQLCatalogResource() {
        this.closeDriverLoadedByIsolatedClassLoader(this.catalogUri);
    }

    private LoadTableResponse injectTableConfig(Supplier<LoadTableResponse> supplier) {
        LoadTableResponse loadTableResponse = supplier.get();
        return LoadTableResponse.builder().withTableMetadata(loadTableResponse.tableMetadata()).build();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public static final class IcebergTableChange {
        private TableIdentifier tableIdentifier;
        private Transaction transaction;

        public IcebergTableChange(TableIdentifier tableIdentifier, Transaction transaction) {
            this.tableIdentifier = tableIdentifier;
            this.transaction = transaction;
        }

        public TableIdentifier getTableIdentifier() {
            return this.tableIdentifier;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public void setTableIdentifier(TableIdentifier tableIdentifier) {
            this.tableIdentifier = tableIdentifier;
        }

        public void setTransaction(Transaction transaction) {
            this.transaction = transaction;
        }
    }
}

