/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.SchemaTableName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.trino.connector.system.table.GravitinoSystemTableFactory;

public class GravitinoSystemConnectorMetadata
implements ConnectorMetadata {
    public List<String> listSchemaNames(ConnectorSession session) {
        return List.of("system");
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return GravitinoSystemTableFactory.SYSTEM_TABLES.keySet().stream().toList();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        return GravitinoSystemTableFactory.SYSTEM_TABLES.get(tableName) != null ? new SystemTableHandle(tableName) : null;
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        SchemaTableName tableName = ((SystemTableHandle)table).name;
        return GravitinoSystemTableFactory.getTableMetaData(tableName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = ((SystemTableHandle)tableHandle).name;
        HashMap<String, ColumnHandle> columnHandles = new HashMap<String, ColumnHandle>();
        List columns = GravitinoSystemTableFactory.getTableMetaData(tableName).getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            columnHandles.put(((ColumnMetadata)columns.get(i)).getName(), new SystemColumnHandle(i));
        }
        return columnHandles;
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        SchemaTableName tableName = ((SystemTableHandle)tableHandle).name;
        return (ColumnMetadata)GravitinoSystemTableFactory.getTableMetaData(tableName).getColumns().get(((SystemColumnHandle)columnHandle).index);
    }

    public static class SystemTableHandle
    implements ConnectorTableHandle {
        private final SchemaTableName name;

        @JsonCreator
        public SystemTableHandle(@JsonProperty(value="name") SchemaTableName name) {
            this.name = name;
        }

        @JsonProperty
        public SchemaTableName getName() {
            return this.name;
        }
    }

    public static class SystemColumnHandle
    implements ColumnHandle {
        private final int index;

        @JsonCreator
        public SystemColumnHandle(@JsonProperty(value="index") int index) {
            this.index = index;
        }

        @JsonProperty
        public int getIndex() {
            return this.index;
        }
    }
}

