/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenameFilesetRequest.class, name="rename"), @JsonSubTypes.Type(value=UpdateFilesetCommentRequest.class, name="updateComment"), @JsonSubTypes.Type(value=RemoveFilesetCommentRequest.class, name="removeComment"), @JsonSubTypes.Type(value=SetFilesetPropertiesRequest.class, name="setProperty"), @JsonSubTypes.Type(value=RemoveFilesetPropertiesRequest.class, name="removeProperty")})
public interface FilesetUpdateRequest
extends RESTRequest {
    public FilesetChange filesetChange();

    public static class RemoveFilesetCommentRequest
    implements FilesetUpdateRequest {
        @Override
        public FilesetChange filesetChange() {
            return FilesetChange.removeComment();
        }

        @Override
        public void validate() throws IllegalArgumentException {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveFilesetCommentRequest)) {
                return false;
            }
            RemoveFilesetCommentRequest other = (RemoveFilesetCommentRequest)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveFilesetCommentRequest;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "FilesetUpdateRequest.RemoveFilesetCommentRequest()";
        }
    }

    public static class RemoveFilesetPropertiesRequest
    implements FilesetUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        @Override
        public FilesetChange filesetChange() {
            return FilesetChange.removeProperty((String)this.property);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveFilesetPropertiesRequest)) {
                return false;
            }
            RemoveFilesetPropertiesRequest other = (RemoveFilesetPropertiesRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveFilesetPropertiesRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public RemoveFilesetPropertiesRequest() {
            this.property = null;
        }

        public RemoveFilesetPropertiesRequest(String property) {
            this.property = property;
        }

        public String toString() {
            return "FilesetUpdateRequest.RemoveFilesetPropertiesRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetFilesetPropertiesRequest
    implements FilesetUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        @Override
        public FilesetChange filesetChange() {
            return FilesetChange.setProperty((String)this.property, (String)this.value);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
            Preconditions.checkArgument((this.value != null ? 1 : 0) != 0, (Object)"\"value\" field is required and cannot be null");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetFilesetPropertiesRequest)) {
                return false;
            }
            SetFilesetPropertiesRequest other = (SetFilesetPropertiesRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetFilesetPropertiesRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public SetFilesetPropertiesRequest() {
            this.property = null;
            this.value = null;
        }

        public SetFilesetPropertiesRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String toString() {
            return "FilesetUpdateRequest.SetFilesetPropertiesRequest(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UpdateFilesetCommentRequest
    implements FilesetUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        @Override
        public FilesetChange filesetChange() {
            return FilesetChange.updateComment((String)this.newComment);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newComment), (Object)"\"newComment\" field is required and cannot be empty");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateFilesetCommentRequest)) {
                return false;
            }
            UpdateFilesetCommentRequest other = (UpdateFilesetCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateFilesetCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public UpdateFilesetCommentRequest() {
            this.newComment = null;
        }

        public UpdateFilesetCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        public String toString() {
            return "FilesetUpdateRequest.UpdateFilesetCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class RenameFilesetRequest
    implements FilesetUpdateRequest {
        @JsonProperty(value="newName")
        private final String newName;

        @Override
        public FilesetChange filesetChange() {
            return FilesetChange.rename((String)this.newName);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newName), (Object)"\"newName\" field is required and cannot be empty");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameFilesetRequest)) {
                return false;
            }
            RenameFilesetRequest other = (RenameFilesetRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameFilesetRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public RenameFilesetRequest() {
            this.newName = null;
        }

        public RenameFilesetRequest(String newName) {
            this.newName = newName;
        }

        public String toString() {
            return "FilesetUpdateRequest.RenameFilesetRequest(newName=" + this.getNewName() + ")";
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

