/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.InheritableMetadata;
import org.apache.iceberg.InheritableMetadataFactory;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.SystemConfigs;
import org.apache.iceberg.avro.AvroEncoderUtil;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.ContentCache;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFiles {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFiles.class);
    private static final Schema MANIFEST_AVRO_SCHEMA = AvroSchemaUtil.convert(ManifestFile.schema(), (Map<Types.StructType, String>)ImmutableMap.of((Object)ManifestFile.schema().asStruct(), (Object)GenericManifestFile.class.getName(), (Object)ManifestFile.PARTITION_SUMMARY_TYPE, (Object)GenericPartitionFieldSummary.class.getName()));
    private static final Cache<FileIO, ContentCache> CONTENT_CACHES = ManifestFiles.newManifestCacheBuilder().build();

    private ManifestFiles() {
    }

    @VisibleForTesting
    static Caffeine<Object, Object> newManifestCacheBuilder() {
        int maxSize = SystemConfigs.IO_MANIFEST_CACHE_MAX_FILEIO.value();
        return Caffeine.newBuilder().weakKeys().softValues().maximumSize((long)maxSize).removalListener((io, contentCache, cause) -> LOG.debug("Evicted {} from FileIO-level cache ({})", io, (Object)cause)).recordStats();
    }

    @VisibleForTesting
    static ContentCache contentCache(FileIO io) {
        return (ContentCache)CONTENT_CACHES.get((Object)io, fileIO -> new ContentCache(ManifestFiles.cacheDurationMs(fileIO), ManifestFiles.cacheTotalBytes(fileIO), ManifestFiles.cacheMaxContentLength(fileIO)));
    }

    public static synchronized void dropCache(FileIO fileIO) {
        CONTENT_CACHES.invalidate((Object)fileIO);
        CONTENT_CACHES.cleanUp();
    }

    public static CloseableIterable<String> readPaths(ManifestFile manifest, FileIO io) {
        return CloseableIterable.transform(ManifestFiles.read(manifest, io, null).select((Collection<String>)ImmutableList.of((Object)"file_path")).liveEntries(), entry -> ((DataFile)entry.file()).path().toString());
    }

    public static ManifestReader<DataFile> read(ManifestFile manifest, FileIO io) {
        return ManifestFiles.read(manifest, io, null);
    }

    public static ManifestReader<DataFile> read(ManifestFile manifest, FileIO io, Map<Integer, PartitionSpec> specsById) {
        Preconditions.checkArgument((manifest.content() == ManifestContent.DATA ? 1 : 0) != 0, (String)"Cannot read a delete manifest with a ManifestReader: %s", (Object)manifest);
        InputFile file = ManifestFiles.newInputFile(io, manifest);
        InheritableMetadata inheritableMetadata = InheritableMetadataFactory.fromManifest(manifest);
        return new ManifestReader<DataFile>(file, manifest.partitionSpecId(), specsById, inheritableMetadata, ManifestReader.FileType.DATA_FILES);
    }

    public static ManifestWriter<DataFile> write(PartitionSpec spec, OutputFile outputFile) {
        return ManifestFiles.write(1, spec, outputFile, null);
    }

    public static ManifestWriter<DataFile> write(int formatVersion, PartitionSpec spec, OutputFile outputFile, Long snapshotId) {
        switch (formatVersion) {
            case 1: {
                return new ManifestWriter.V1Writer(spec, outputFile, snapshotId);
            }
            case 2: {
                return new ManifestWriter.V2Writer(spec, outputFile, snapshotId);
            }
        }
        throw new UnsupportedOperationException("Cannot write manifest for table version: " + formatVersion);
    }

    public static ManifestReader<DeleteFile> readDeleteManifest(ManifestFile manifest, FileIO io, Map<Integer, PartitionSpec> specsById) {
        Preconditions.checkArgument((manifest.content() == ManifestContent.DELETES ? 1 : 0) != 0, (String)"Cannot read a data manifest with a DeleteManifestReader: %s", (Object)manifest);
        InputFile file = ManifestFiles.newInputFile(io, manifest);
        InheritableMetadata inheritableMetadata = InheritableMetadataFactory.fromManifest(manifest);
        return new ManifestReader<DeleteFile>(file, manifest.partitionSpecId(), specsById, inheritableMetadata, ManifestReader.FileType.DELETE_FILES);
    }

    public static ManifestWriter<DeleteFile> writeDeleteManifest(int formatVersion, PartitionSpec spec, OutputFile outputFile, Long snapshotId) {
        switch (formatVersion) {
            case 1: {
                throw new IllegalArgumentException("Cannot write delete files in a v1 table");
            }
            case 2: {
                return new ManifestWriter.V2DeleteWriter(spec, outputFile, snapshotId);
            }
        }
        throw new UnsupportedOperationException("Cannot write manifest for table version: " + formatVersion);
    }

    public static byte[] encode(ManifestFile manifestFile) throws IOException {
        GenericManifestFile genericManifestFile = (GenericManifestFile)manifestFile;
        return AvroEncoderUtil.encode(genericManifestFile, MANIFEST_AVRO_SCHEMA);
    }

    public static ManifestFile decode(byte[] manifestData) throws IOException {
        return (ManifestFile)AvroEncoderUtil.decode(manifestData);
    }

    static ManifestReader<?> open(ManifestFile manifest, FileIO io) {
        return ManifestFiles.open(manifest, io, null);
    }

    static ManifestReader<?> open(ManifestFile manifest, FileIO io, Map<Integer, PartitionSpec> specsById) {
        switch (manifest.content()) {
            case DATA: {
                return ManifestFiles.read(manifest, io, specsById);
            }
            case DELETES: {
                return ManifestFiles.readDeleteManifest(manifest, io, specsById);
            }
        }
        throw new UnsupportedOperationException("Cannot read unknown manifest type: " + manifest.content());
    }

    static ManifestFile copyAppendManifest(int formatVersion, int specId, InputFile toCopy, Map<Integer, PartitionSpec> specsById, OutputFile outputFile, long snapshotId, SnapshotSummary.Builder summaryBuilder) {
        ManifestFile manifestFile;
        InheritableMetadata inheritableMetadata = InheritableMetadataFactory.forCopy(snapshotId);
        ManifestReader<DataFile> reader = new ManifestReader<DataFile>(toCopy, specId, specsById, inheritableMetadata, ManifestReader.FileType.DATA_FILES);
        Throwable throwable = null;
        try {
            manifestFile = ManifestFiles.copyManifestInternal(formatVersion, reader, outputFile, snapshotId, summaryBuilder, ManifestEntry.Status.ADDED);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    ManifestFiles.$closeResource(throwable, reader);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest: %s", new Object[]{toCopy.location()});
            }
        }
        ManifestFiles.$closeResource(throwable, reader);
        return manifestFile;
    }

    static ManifestFile copyRewriteManifest(int formatVersion, int specId, InputFile toCopy, Map<Integer, PartitionSpec> specsById, OutputFile outputFile, long snapshotId, SnapshotSummary.Builder summaryBuilder) {
        ManifestFile manifestFile;
        InheritableMetadata inheritableMetadata = InheritableMetadataFactory.empty();
        ManifestReader<DataFile> reader = new ManifestReader<DataFile>(toCopy, specId, specsById, inheritableMetadata, ManifestReader.FileType.DATA_FILES);
        Throwable throwable = null;
        try {
            manifestFile = ManifestFiles.copyManifestInternal(formatVersion, reader, outputFile, snapshotId, summaryBuilder, ManifestEntry.Status.EXISTING);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    ManifestFiles.$closeResource(throwable, reader);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest: %s", new Object[]{toCopy.location()});
            }
        }
        ManifestFiles.$closeResource(throwable, reader);
        return manifestFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ManifestFile copyManifestInternal(int formatVersion, ManifestReader<DataFile> reader, OutputFile outputFile, long snapshotId, SnapshotSummary.Builder summaryBuilder, ManifestEntry.Status allowedEntryStatus) {
        ManifestWriter<DataFile> writer = ManifestFiles.write(formatVersion, reader.spec(), outputFile, snapshotId);
        boolean threw = true;
        try {
            for (ManifestEntry entry : reader.entries()) {
                Preconditions.checkArgument((allowedEntryStatus == entry.status() ? 1 : 0) != 0, (String)"Invalid manifest entry status: %s (allowed status: %s)", (Object)((Object)entry.status()), (Object)((Object)allowedEntryStatus));
                switch (entry.status()) {
                    case ADDED: {
                        summaryBuilder.addedFile(reader.spec(), (DataFile)entry.file());
                        writer.add(entry);
                        break;
                    }
                    case EXISTING: {
                        writer.existing(entry);
                        break;
                    }
                    case DELETED: {
                        summaryBuilder.deletedFile(reader.spec(), (DataFile)entry.file());
                        writer.delete(entry);
                    }
                }
            }
            threw = false;
        }
        catch (Throwable throwable) {
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                if (threw) throw throwable;
                throw new RuntimeIOException(e, "Failed to close manifest: %s", new Object[]{outputFile});
            }
        }
        try {
            writer.close();
            return writer.toManifestFile();
        }
        catch (IOException e) {
            if (threw) return writer.toManifestFile();
            throw new RuntimeIOException(e, "Failed to close manifest: %s", new Object[]{outputFile});
        }
    }

    private static InputFile newInputFile(FileIO io, ManifestFile manifest) {
        InputFile input = io.newInputFile(manifest);
        if (ManifestFiles.cachingEnabled(io)) {
            return ManifestFiles.contentCache(io).tryCache(input);
        }
        return input;
    }

    static boolean cachingEnabled(FileIO io) {
        try {
            return PropertyUtil.propertyAsBoolean(io.properties(), "io.manifest.cache-enabled", false);
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    static long cacheDurationMs(FileIO io) {
        return PropertyUtil.propertyAsLong(io.properties(), "io.manifest.cache.expiration-interval-ms", CatalogProperties.IO_MANIFEST_CACHE_EXPIRATION_INTERVAL_MS_DEFAULT);
    }

    static long cacheTotalBytes(FileIO io) {
        return PropertyUtil.propertyAsLong(io.properties(), "io.manifest.cache.max-total-bytes", 0x6400000L);
    }

    static long cacheMaxContentLength(FileIO io) {
        return PropertyUtil.propertyAsLong(io.properties(), "io.manifest.cache.max-content-length", 0x800000L);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

