/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.IllegalNamespaceException;

public class NamespaceUtil {
    private NamespaceUtil() {
    }

    public static Namespace ofMetalake() {
        return Namespace.empty();
    }

    public static Namespace ofCatalog(String metalake) {
        return Namespace.of((String[])new String[]{metalake});
    }

    public static Namespace ofSchema(String metalake, String catalog) {
        return Namespace.of((String[])new String[]{metalake, catalog});
    }

    public static Namespace ofTable(String metalake, String catalog, String schema) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema});
    }

    public static Namespace ofFileset(String metalake, String catalog, String schema) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema});
    }

    public static Namespace ofTopic(String metalake, String catalog, String schema) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema});
    }

    public static void checkMetalake(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.isEmpty(), "Metalake namespace must be non-null and empty, the input namespace is %s", namespace);
    }

    public static void checkCatalog(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 1, "Catalog namespace must be non-null and have 1 level, the input namespace is %s", namespace);
    }

    public static void checkSchema(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 2, "Schema namespace must be non-null and have 2 levels, the input namespace is %s", namespace);
    }

    public static void checkTable(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 3, "Table namespace must be non-null and have 3 levels, the input namespace is %s", namespace);
    }

    public static void checkFileset(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 3, "Fileset namespace must be non-null and have 3 levels, the input namespace is %s", namespace);
    }

    public static void checkTopic(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 3, "Topic namespace must be non-null and have 3 levels, the input namespace is %s", namespace);
    }

    @FormatMethod
    public static void check(boolean expression, @FormatString String message, Object ... args) {
        if (!expression) {
            throw new IllegalNamespaceException(message, args);
        }
    }
}

