/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.SchemaMetaService;

public class CommonMetaService {
    private static final CommonMetaService INSTANCE = new CommonMetaService();

    public static CommonMetaService getInstance() {
        return INSTANCE;
    }

    private CommonMetaService() {
    }

    public Long getParentEntityIdByNamespace(Namespace namespace) {
        Preconditions.checkArgument((!namespace.isEmpty() && namespace.levels().length <= 3 ? 1 : 0) != 0, (Object)"Namespace should not be empty and length should be less than or equal to 3.");
        Long parentEntityId = null;
        if (namespace.levels().length >= 1) {
            parentEntityId = MetalakeMetaService.getInstance().getMetalakeIdByName(namespace.level(0));
        }
        if (namespace.levels().length >= 2) {
            parentEntityId = CatalogMetaService.getInstance().getCatalogIdByMetalakeIdAndName(parentEntityId, namespace.level(1));
        }
        if (namespace.levels().length >= 3) {
            parentEntityId = SchemaMetaService.getInstance().getSchemaIdByCatalogIdAndName(parentEntityId, namespace.level(2));
        }
        Preconditions.checkState((parentEntityId != null && parentEntityId > 0L ? 1 : 0) != 0, (Object)"Parent entity id should not be null and should be greater than 0.");
        return parentEntityId;
    }
}

