/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.kv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.Config;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.storage.TransactionIdGenerator;
import org.apache.gravitino.storage.kv.KvBackend;
import org.apache.gravitino.storage.kv.KvRange;
import org.apache.gravitino.storage.kv.TransactionalKvBackend;
import org.apache.gravitino.storage.kv.ValueStatusEnum;
import org.apache.gravitino.utils.ByteUtils;
import org.apache.gravitino.utils.Bytes;

@ThreadSafe
public class TransactionalKvBackendImpl
implements TransactionalKvBackend {
    private final KvBackend kvBackend;
    private final TransactionIdGenerator transactionIdGenerator;
    @VisibleForTesting
    final ThreadLocal<List<Pair<byte[], byte[]>>> putPairs = ThreadLocal.withInitial(Lists::newArrayList);
    private final ThreadLocal<List<byte[]>> originalKeys = ThreadLocal.withInitial(Lists::newArrayList);
    @VisibleForTesting
    final ThreadLocal<Long> txId = new ThreadLocal();
    private static final byte[] TRANSACTION_PREFIX = new byte[]{30};
    private static final int LENGTH_OF_VALUE_PREFIX = 8;
    private static final byte[] SEPARATOR = new byte[]{31};
    private static final int LENGTH_OF_TRANSACTION_ID = 8;
    private static final int LENGTH_OF_SEPARATOR = SEPARATOR.length;
    private static final int LENGTH_OF_VALUE_STATUS = 1;

    public TransactionalKvBackendImpl(KvBackend kvBackend, TransactionIdGenerator transactionIdGenerator) {
        this.kvBackend = kvBackend;
        this.transactionIdGenerator = transactionIdGenerator;
    }

    @Override
    public void begin() {
        if (!this.putPairs.get().isEmpty()) {
            throw new IllegalStateException("The transaction is has not committed or rollback yet, you should commit or rollback it first");
        }
        this.txId.set(this.transactionIdGenerator.nextId());
    }

    @Override
    public void commit() throws IOException {
        try {
            if (this.putPairs.get().isEmpty()) {
                return;
            }
            for (Pair<byte[], byte[]> pair : this.putPairs.get()) {
                this.kvBackend.put((byte[])pair.getKey(), (byte[])pair.getValue(), true);
            }
            this.kvBackend.put(TransactionalKvBackendImpl.generateCommitKey(this.txId.get()), SerializationUtils.serialize((Serializable)((Serializable)((Object)this.originalKeys.get()))), true);
        }
        finally {
            this.putPairs.get().clear();
            this.originalKeys.get().clear();
            this.txId.remove();
        }
    }

    @Override
    public void rollback() throws IOException {
        for (Pair<byte[], byte[]> pair : this.putPairs.get()) {
            this.kvBackend.delete((byte[])pair.getKey());
        }
    }

    @Override
    public void closeTransaction() {
        this.putPairs.remove();
        this.originalKeys.remove();
        this.txId.remove();
    }

    @Override
    public boolean inTransaction() {
        return this.txId.get() != null;
    }

    @Override
    public void initialize(Config config) throws IOException {
    }

    @Override
    public void put(byte[] key, byte[] value, boolean overwrite) throws IOException, EntityAlreadyExistsException {
        byte[] oldValue = this.get(key);
        if (oldValue != null && !overwrite) {
            throw new EntityAlreadyExistsException("Key already exists: %s", Bytes.wrap(key));
        }
        this.putPairs.get().add((Pair<byte[], byte[]>)Pair.of((Object)TransactionalKvBackendImpl.generateKey(key, this.txId.get()), (Object)this.constructValue(value, ValueStatusEnum.NORMAL)));
        this.originalKeys.get().add(key);
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        byte[] rawValue = this.getNextReadableValue(key);
        if (rawValue == null) {
            return null;
        }
        return TransactionalKvBackendImpl.getRealValue(rawValue);
    }

    @Override
    public boolean delete(byte[] key) throws IOException {
        byte[] oldValue = this.get(key);
        if (oldValue == null) {
            return false;
        }
        byte[] deletedValue = this.constructValue(oldValue, ValueStatusEnum.DELETED);
        this.putPairs.get().add((Pair<byte[], byte[]>)Pair.of((Object)TransactionalKvBackendImpl.generateKey(key, this.txId.get()), (Object)deletedValue));
        this.originalKeys.get().add(key);
        return true;
    }

    @Override
    public boolean deleteRange(KvRange kvRange) throws IOException {
        List<Pair<byte[], byte[]>> pairs = this.scan(kvRange);
        pairs.forEach(p -> this.putPairs.get().add((Pair<byte[], byte[]>)Pair.of((Object)TransactionalKvBackendImpl.generateKey((byte[])p.getKey(), this.txId.get()), (Object)this.constructValue((byte[])p.getValue(), ValueStatusEnum.DELETED))));
        return true;
    }

    @Override
    public List<Pair<byte[], byte[]>> scan(KvRange scanRange) throws IOException {
        byte[] end = scanRange.getEnd();
        boolean endInclude = scanRange.isEndInclusive();
        if (endInclude) {
            end = TransactionalKvBackendImpl.endOfKey(end);
            endInclude = false;
        }
        KvRange kvRange = new KvRange.KvRangeBuilder().start(scanRange.getStart()).end(end).startInclusive(scanRange.isStartInclusive()).endInclusive(endInclude).predicate((k, v) -> {
            byte[] transactionId = TransactionalKvBackendImpl.getBinaryTransactionId(k);
            return this.kvBackend.get(TransactionalKvBackendImpl.generateCommitKey(transactionId)) != null;
        }).limit(Integer.MAX_VALUE).build();
        List<Pair<byte[], byte[]>> rawPairs = this.kvBackend.scan(kvRange);
        ArrayList result = Lists.newArrayList();
        int i = 0;
        int j = 0;
        while (i < scanRange.getLimit() && j < rawPairs.size()) {
            Pair<byte[], byte[]> pair = rawPairs.get(j);
            byte[] rawKey = (byte[])pair.getKey();
            byte[] realKey = TransactionalKvBackendImpl.getRealKey(rawKey);
            Bytes minNextKey = Bytes.increment(Bytes.wrap(Bytes.concat(realKey, SEPARATOR)));
            if (!scanRange.isStartInclusive() && Bytes.wrap(realKey).compareTo(scanRange.getStart()) == 0) {
                while (j < rawPairs.size() && minNextKey.compareTo((byte[])rawPairs.get(j).getKey()) >= 0) {
                    ++j;
                }
                continue;
            }
            if (!scanRange.isEndInclusive() && Bytes.wrap(realKey).compareTo(scanRange.getEnd()) == 0) break;
            byte[] value = TransactionalKvBackendImpl.getRealValue((byte[])pair.getValue());
            if (value != null) {
                result.add(Pair.of((Object)realKey, (Object)value));
                ++i;
            }
            ++j;
            while (j < rawPairs.size() && minNextKey.compareTo((byte[])rawPairs.get(j).getKey()) >= 0) {
                ++j;
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    public static byte[] getRealValue(byte[] rawValue) {
        byte[] firstType = ArrayUtils.subarray((byte[])rawValue, (int)0, (int)1);
        ValueStatusEnum statusEnum = ValueStatusEnum.fromCode(firstType[0]);
        if (statusEnum == ValueStatusEnum.DELETED) {
            return null;
        }
        return ArrayUtils.subarray((byte[])rawValue, (int)8, (int)rawValue.length);
    }

    @VisibleForTesting
    byte[] constructValue(byte[] value, ValueStatusEnum status) {
        byte[] statusCode = new byte[]{status.getCode()};
        byte[] prefix = new byte[8];
        System.arraycopy(statusCode, 0, prefix, 0, statusCode.length);
        return Bytes.concat(prefix, value);
    }

    @VisibleForTesting
    byte[] constructKey(byte[] key) {
        return Bytes.concat(key, SEPARATOR, TransactionalKvBackendImpl.revertByteArray(ByteUtils.longToByte(this.txId.get())));
    }

    private byte[] getNextReadableValue(byte[] key) throws IOException {
        List<Pair<byte[], byte[]>> pairs = this.kvBackend.scan(new KvRange.KvRangeBuilder().start(key).startInclusive(false).end(TransactionalKvBackendImpl.endOfKey(key)).endInclusive(false).predicate((k, v) -> {
            byte[] transactionId = TransactionalKvBackendImpl.getBinaryTransactionId(k);
            return this.kvBackend.get(TransactionalKvBackendImpl.generateCommitKey(transactionId)) != null;
        }).limit(1).build());
        if (pairs.isEmpty()) {
            return null;
        }
        return (byte[])pairs.get(0).getValue();
    }

    @VisibleForTesting
    static byte[] revertByteArray(byte[] bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = ~bytes[i];
        }
        return result;
    }

    static byte[] generateKey(byte[] key, long transactionId) {
        return TransactionalKvBackendImpl.generateKey(key, TransactionalKvBackendImpl.revertByteArray(ByteUtils.longToByte(transactionId)));
    }

    static byte[] generateKey(byte[] key, byte[] binaryTransactionId) {
        return Bytes.concat(key, SEPARATOR, binaryTransactionId);
    }

    static byte[] generateCommitKey(long transactionId) {
        byte[] binaryTransactionId = ByteUtils.longToByte(transactionId);
        return TransactionalKvBackendImpl.generateCommitKey(TransactionalKvBackendImpl.revertByteArray(binaryTransactionId));
    }

    static byte[] generateCommitKey(byte[] transactionId) {
        return Bytes.concat(TRANSACTION_PREFIX, SEPARATOR, transactionId);
    }

    static byte[] endOfTransactionId() {
        return TransactionalKvBackendImpl.generateCommitKey(1L);
    }

    static byte[] endOfKey(byte[] key) {
        return TransactionalKvBackendImpl.generateKey(key, 1L);
    }

    static byte[] getRealKey(byte[] rawKey) {
        return ArrayUtils.subarray((byte[])rawKey, (int)0, (int)(rawKey.length - 8 - LENGTH_OF_SEPARATOR));
    }

    static byte[] getBinaryTransactionId(byte[] rawKey) {
        return ArrayUtils.subarray((byte[])rawKey, (int)(rawKey.length - 8), (int)rawKey.length);
    }

    static long getTransactionId(byte[] binaryTransactionId) {
        byte[] reverted = TransactionalKvBackendImpl.revertByteArray(binaryTransactionId);
        return ByteUtils.byteToLong(reverted);
    }
}

